;PASSTRHM.ASM: fichier passthru adapt au DSP56303
;***************************************************************************

      nolist
      include 'ioequ.asm'
      include 'intequ.asm'
      include 'ada_equ.asm'
      include 'vectors.asm'  
	list
  
;******************************************************************************

;---Buffer for talking to the CS4218

       org    x:$0
RX_BUFF_BASE	equ     *
RX_data_1_2	ds	1	; data time slot 1/2 for RX ISR (left audio)
RX_data_3_4	ds	1	; data time slot 3/4 for RX ISR (right audio)

TX_BUFF_BASE	equ	*
TX_data_1_2	ds	1	; data time slot 1/2 for TX ISR (left audio)
TX_data_3_4	ds	1	; data time slot 3/4 for TX ISR (right audio)

RX_PTR          ds      1	; Pointer for rx buffer
TX_PTR          ds      1	; Pointer for tx buffer

CTRL_WD_12      equ     MIN_LEFT_ATTN+MIN_RIGHT_ATTN+LIN2+RIN2
CTRL_WD_34      equ     MIN_LEFT_GAIN+MIN_RIGHT_GAIN




        org     p:$100
START
main
        movep   #$040006,x:M_PCTL  	; PLL 7 X 12.288 = 86.016MHz
        ori     #3,mr              	; mask interrupts
        movec   #0,sp              	; clear hardware stack pointer
        move    #0,omr             	; operating mode 0
        move    #$40,r7            	; initialize stack pointer
        move    #-1,m7             	; linear addressing
        jsr     ada_init           	; initialize codec

   
loop
        
        jset    #3,x:M_SSISR0,*    	; wait for rx frame sync
        jclr    #3,x:M_SSISR0,*    	; wait for rx frame sync

	move    x:RX_BUFF_BASE,a   	; receive left
        move    x:RX_BUFF_BASE+1,b 	; receive right

	move    a,x:TX_BUFF_BASE   	; transmit left
        move    b,x:TX_BUFF_BASE+1 	; transmit right
        
	jmp    loop

	include 'ada_init.asm'		; used to include codec initialization routines
echo
        end

