%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Oreille directe: filtre global (forme ferme)          %
%        ---------------------------------------------          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% Choix des paramtres
% --------------------
fs=48000;
f = [0:1:24000];

% Dfinition des coefficients
% ---------------------------
alpha  = 0.03374889909003
lambda  = -1.92146603658229
beta = 0.95521493567232

b1 = 0.00261116383261
b2 = -0.00261116383261
b3 = -1.99469393197813
b4 = 0.99477767233477

num = [alpha+b1 alpha*b3+b1*lambda alpha*b4+b1*beta+b2 b2*lambda b2*beta]
den = [1 b3+lambda b4+lambda*b3+beta lambda*b4+beta*b3 beta*b4]

Hglob = freqz(num,den,f,fs);

disp('Appuyez sur une touche pour continuer...')
pause;

% Affichage
% ---------
figure(1);
subplot(211),semilogx(f,20*log10(abs(Hglob))),grid, xlabel('Frquence normalise'),
title('Norme de la rponse frquentielle du filtre de l''oreille directe');
subplot(212),semilogx(f,20*log10(angle(Hglob))),grid, xlabel('Frquence normalise'),
title('Phase de la rponse frquentielle du filtre de l''oreille directe');

disp('Appuyez sur une touche pour continuer...')
pause;

% Stabilit du filtre
% -------------------
abs(roots(den)) %vu la def de roots ce sont bien les solutions en z et non z^-1

% Rponse impulsionnelle
% ----------------------
[h,t]=impz(num,den);
figure(2)
plot(t,h),
axis([0 355 -0.15 0.175]), grid, xlabel('Temps (en s)'),
title('Rponse impulsionnelle du filtre pour l''oreille directe');

disp('Appuyez sur une touche pour continuer...')
pause;

figure(3)
zplane(num,den)
grid,
title('Poles et zros');