%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            Oreille indirecte: filtres spars                         %
%                            ----------------------------------                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                              Passebande en basse frquence                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Choix des paramtres
% --------------------
fs=48000;
fc=70;
deltaf=40;              % bande de coupure
beta=cos(2*pi*fc/fs);
f = [0:1:24000];

% Calcul de alpha
% ---------------
BS=2*pi*deltaf/fs;
poly=[cos(BS) -2 cos(BS)];
sol=roots(poly);

% Etude de stabilit
% ------------------
disp('Calcul des poles')
disp('----------------')
disp('----------------')
for i=1:2
   den=[1 -beta*(1+sol(i)) sol(i)];
   disp(sprintf('Pour alpha %i',i))
   disp('------------')
   poles=roots(den)
   disp('----> normes:')
   normes=abs(poles)
   if (normes(1)<1)&(normes(2)<1)
      alpha=sol(i);
   end
end

% Affichage des paramtres
% ------------------------
disp('choix des paramtres:')
alpha
beta

disp('Appuyez sur une touche pour continuer...')
pause;

% Dfinition du filtre
% --------------------
num=(1-alpha)/2*[1 0 -1]; 
den=[1 -beta*(1+alpha) alpha];

% Etude du filtre
% ---------------
% Rponse frquentielle
HBP=freqz(num,den,f,fs); 
HBP = (1/(10^(6/20)))*HBP;

% Courbes
figure
subplot(211), semilogx(f,20*log10(abs(HBP))),grid, xlabel('Frquence normalise'),
axis([10^0 10^5 -70 35]),
title('Norme de la rponse frquentielle du filtre passe-bande');
subplot(212), semilogx(f,angle(HBP)),grid, xlabel('Frquence normalise'),
title('Phase de la rponse frquentielle du filtre passe-bande');

disp('Appuyez sur une touche pour continuer...')
pause;

% Affichage des coefficients du filtre
% ------------------------------------
disp('Numrateur')
num
disp('Dnominateur')
den

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                 Filtre passe-bas                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Choix des paramtres
% --------------------
fs=48000;
fc=3000;
f = [0:1:24000];
omegc = 2*pi*fc/fs

% Calcul de alpha
% ---------------
alpha = (1-sin(omegc))/cos(omegc)

% Filtre
% ------
b = (1-alpha)/2 * [1 1]
a = [1 -alpha];
HLPhf = freqz(b,a,f,fs);

% Affichage
% ---------
figure
subplot(211), semilogx(f,20*log10(abs(HLPhf))),grid, xlabel('Frquence normalise'),
axis([10^0 10^5 -50 20]);
title('Norme de la rponse frquentielle du filtre passe-bas');
subplot(212), semilogx(f,angle(HLPhf));,grid, xlabel('Frquence normalise'),
title('Phase de la rponse frquentielle du filtre passe-bas');

disp('Appuyez sur une touche pour continuer...')
pause;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%            ------------------>oreille indirecte : filtre global                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure;
Hglob = (1/(10^(0/20)))*(HLPhf + HBP);
subplot(211),semilogx(f,20*log10(abs(Hglob))),grid, xlabel('Frquence normalise'),
axis([10^0 10^5 -27.5 12.5]);
title('Norme de la rponse frquentielle du filtre de l''oreille indirecte');
subplot(212),semilogx(f,20*log10(angle(Hglob))),grid, xlabel('Frquence normalise'),
axis([10^0 10^5 -60 10]);
title('Phase de la rponse frquentielle du filtre de l''oreille indirecte');
