%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        Oreille indirecte: filtre global (forme ferme)          %
%        -----------------------------------------------          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% Choix des paramtres
% --------------------
fs=48000;
f = [0:1:24000];


% Dfinition des coefficients
% ---------------------------

a1 = 0.16591068104035
a2 = a1
a3 = -0.66817863791930

b1 = 0.00130868197782
b2 = -0.00130868197782
b3 = -1.99469393197813
b4 = 0.99477767233477

num = [a1+b1 a1*b3+a2+a3*b1 a1*b4+a2*b3+b2 a2*b4+a3*b2]
den = [1 b3+a3 b4+a3*b3 a3*b4]

Hglob = freqz(num,den,f,fs);

disp('Appuyez sur une touche pour continuer...')
pause;

% Affichage
% ---------
figure(1);
subplot(211), semilogx(f,20*log10(abs(Hglob))),grid, xlabel('Frquence normalise'),
title('Norme de la rponse frquentielle du filtre de l''oreille indirecte');
subplot(212), semilogx(f,20*log10(angle(Hglob))),grid, xlabel('Frquence normalise'),
title('Phase de la rponse frquentielle du filtre de l''oreille indirecte');

disp('Appuyez sur une touche pour continuer...')
pause;

% Stabilit du filtre
% -------------------
abs(roots(den)) %vu la def de roots ce sont bien les solutions en z et non z^-1

% Rponse impulsionnelle
% ----------------------
[h,t]=impz(num,den);
figure(2)
plot(t,h),
axis([0 39 -0.05 0.3]), grid, xlabel('Temps (en s)'),
title('Rponse impulsionnelle du filtre pour l''oreille directe');

disp('Appuyez sur une touche pour continuer...')
pause;

figure(3)
zplane(num,den)
grid,
title('Poles et zros');