;***************************************************************************
      nolist
      include 'ioequ.asm'
      include 'intequ.asm'
      include 'ada_equ.asm'
      include 'vectors.asm'  
	list
;******************************************************************************

;************
; Constantes
;************

; constante d'initialisation du coeur du dsp
INIT_PCTL	equ	$040007		; Fcore = fcrystal*MF = 12.288*8 = 98.304MHz

; constante d'initialisation du registre de status
INIT_SR	equ	$c00300		; interruptions masquees		

; taille des buffers circulaires
Ccoefs	equ	15
Cxl		equ	14
Cxr		equ	14
Cyd		equ	3
Cyi		equ	2

;***********
; Memoire x
;***********

; Communication avec le codec
; ---------------------------
	org    x:$0
; buffers et pointeurs de reception pour la communication avec le codec cs4218
RX_BUFF_BASE	equ     *		; adresse du buffer de reception	
RX_data_1_2		ds	1			; canal de reception audio gauche
RX_data_3_4		ds	1			; canal de reception audio droit

; buffers et pointeurs de transmission pour la communication avec le codec cs4218
TX_BUFF_BASE	equ	*		; adresse du buffer de transmission
TX_data_1_2		ds	1			; canal de transmission audio gauche
TX_data_3_4		ds	1			; canal de transmission audio droit

RX_PTR          ds      1		; pointeur vers buffer de reception
TX_PTR          ds      1		; pointeur vers buffer de transmission

CTRL_WD_12      equ     MIN_LEFT_ATTN+MIN_RIGHT_ATTN+LIN2+RIN2
CTRL_WD_34      equ     MIN_LEFT_GAIN+MIN_RIGHT_GAIN

; Utilisation par le programme
; --------------------------
	org     x:100  			; organisation de la mmoire X:
yld     bsm Cyd+1,$0
yli     bsm Cyi+1,$0
yrd     bsm Cyd+1,$0
yri     bsm Cyi+1,$0

;***********
; Memoire y
;***********

; Utilisation par le programme
; ----------------------------
	org     y:0  			; organisation de la mmoire Y:
coefs   bsm Ccoefs+1
	org     y:coefs	 
	dc	0.00454500786533  
	dc	-0.00904199835577   
	dc	0.00418196376755   
	dc	0.00062715782754
	dc 	-0.00031177783655
	dc	0.48951999607005   
	dc 	-0.72284115645998  
	dc	0.47709911840776
	dc	-0.11877831128594
	dc	0.04180484075454  
	dc	-0.04147619525565  
	dc	-0.04180136739964   
	dc	0.04147966861055
	dc	0.66571814247436   
	dc	-0.58189738671745  
	dc	0.16617229753329
xl      bsm Cxr+1,$0
xr      bsm Cxl+1,$0

; buffers pour la communication avec le port serie
SCI_RX	ds	1			

;*******************
; Memoire programme
;*******************

	org	p:$100
START
     	movep	#INIT_PCTL,x:M_PCTL	; initialise la frquence du coeur
	move	#INIT_SR,sr			; initialise le registre de status (interruptions masquees)
      movec #0,sp              	; initialise le pointeur de pile hardware
      ori   #3,mr             	; masque les interruptions
      move  #0,omr             	; initialise le mode d'operation 0
     	andi  #$f3,mr		      ; set scaling mode : no shift 

	jsr	sci_init                ; initialisation du port serie 
	jsr   ada_init           	; initialize codec
	movep	#$3,x:M_PCRE		; active le port sci (bits PCE1 et PCE1 de PCRE a 1)
	move	#0,x0
	nop
	move	x0,y:SCI_RX

; Initialisation des pointeurs

	move	#yld,r0				; r0 pointe sur les yld (mmoire X)
	move	#Cyd,m0				; configuration du buffer circulaire
	move	#yli,r1				; r1 pointe sur les yli (mmoire X)
	move	#Cyi,m1				; configuration du buffer circulaire
	move	#yrd,r2				; r2 pointe sur les yrd (mmoire X)
	move	#Cyd,m2				; configuration du buffer circulaire
	move	#yri,r3				; r3 pointe sur les yri (mmoire X)
	move	#Cyi,m3				; configuration du buffer circulaire
	move	#coefs,r4				; r4 pointe sur les coefficients (mmoire Y)
	move	#Ccoefs,m4				; configuration du buffer circulaire
	move  #xl,r5				; r5 pointe sur la ligne de dlai xl (mmoire Y)
	move	#Cxl,m5				; configuration du buffer circulaire
	move	#xr,r6				; r6 pointe sur la ligne de dlai xr (mmoire Y)
	move 	m5,m6					; configuration du buffer circulaire

loop
	jset  #3,x:M_SSISR0,*    	; wait for rx frame sync
      jclr  #3,x:M_SSISR0,*    	; wait for rx frame sync

; pour les tests
;	jmp filtre_on
 
; avec com srie  	
	move	y:SCI_RX,x0
	nop
	jset	#0,x0,filtre_on   	; si le bit 0 de SCI_RX est a 0, saute en filtre_on
	jmp 	filtre_off			; sinon, saute en filtre_off

filtre_off
	
	move  x:RX_BUFF_BASE,a   	; receive left
      move  x:RX_BUFF_BASE+1,b 	; receive right

	move  a,x:TX_BUFF_BASE   	; transmit left
      move  b,x:TX_BUFF_BASE+1 	; transmit right
      	  
	jmp loop

filtre_on

	move  x:RX_BUFF_BASE,a   	; receive left
	nop

	asr a1	
	asr a1

	jsr 	filtrageld
	jsr 	filtrageli

	move   x:RX_BUFF_BASE+1,a 	; receive right
	nop

	asr a1
	asr a1	

	jsr 	filtragerd
	jsr 	filtrageri

	; cre les chantillons de sortie

	; Sortie LEFT	
	move	x:(r1),x0
	move	x:(r2),a
	add	x0,a
;	clr a

	; Sortie RIGHT
	move	x:(r0),x0
	move	x:(r3),b	
	add	x0,b
;	clr	b

; test direct
;	move	x:(r0),b
	
;test indirect
;	move	x:(r3),b	

	nop
	move    a,x:TX_BUFF_BASE   	; transmit left
     	move    b,x:TX_BUFF_BASE+1 	; transmit right

	jmp loop


filtrageld
; Traitement oreille directe
; --------------------------

	move a,y:-(r5)

	move a,x1
	nop
	clr a	y:(r4)+,y1

	move 	#1,n5
	clr	b
	move	n5,b
	add	#1,b
	do #4,end1
	mac   x1,y1,a        y:(r4)+,y1
	move	y:(r5+n5),x1      
	move  b,n5
	add	#1,b
	nop
end1
 	
	mac   x1,y1,a        y:(r4)+,y1      x:(r0)+,x1	    
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r0)+,x1	    
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r0)+,x1	    
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r0),x1
	nop
	
      mac   x1,y1,a
	nop

	asl a
	nop
	asl a
	nop
	asl a
	nop

	move  a,x:(r0)

	rts

filtrageli
; Traitement oreille indirecte
; ----------------------------

	move 	#11,n5
	clr	b
	move	n5,b
	add	#1,b

	move	y:(r5+n5),x1
	nop
	clr 	a	y:(r4)+,y1

	move	b,n5
	add 	#1,b

	mac   x1,y1,a        y:(r4)+,y1
	nop
	move	y:(r5+n5),x1      
		
	move	b,n5
	add 	#1,b

 	mac   x1,y1,a        y:(r4)+,y1
	nop
	move	y:(r5+n5),x1      
	
	move	b,n5

	mac   x1,y1,a        y:(r4)+,y1      
	nop
	nop
	move	y:(r5+n5),x1

	mac   x1,y1,a        y:(r4)+,y1      x:(r1)+,x1	  
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r1)+,x1	  
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r1),x1
	nop
	
      mac   x1,y1,a
	nop

	asl a
	nop
	asl a
	nop

	move  a,x:(r1)

	rts

filtragerd
; Traitement oreille directe
; --------------------------

	move a,y:-(r6)

	move a,x1
	nop
	clr a	y:(r4)+,y1

	move 	#1,n6
	clr	b
	move	n6,b
	add	#1,b
	do #4,end2
	mac   x1,y1,a        y:(r4)+,y1
	move	y:(r6+n6),x1      
	move  b,n6
	add	#1,b
	nop
end2

	mac   x1,y1,a        y:(r4)+,y1      x:(r2)+,x1	  
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r2)+,x1	  
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r2)+,x1	  
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r2),x1
	nop
	
      mac   x1,y1,a
	nop

	asl a
	nop
	asl a
	nop
	asl a
	nop

	move  a,x:(r2)

	rts

filtrageri
; Traitement oreille indirecte
; ----------------------------

	move 	#11,n6
	clr	b
	move	n6,b
	add	#1,b

	move	y:(r6+n6),x1
	nop
	clr 	a	y:(r4)+,y1

	move	b,n6
	add 	#1,b

	mac   x1,y1,a        y:(r4)+,y1
	nop
	move	y:(r6+n6),x1      

	move	b,n6
	add 	#1,b

 	mac   x1,y1,a        y:(r4)+,y1
	nop
	move	y:(r6+n6),x1      

	move	b,n6
	
	mac   x1,y1,a        y:(r4)+,y1      
	nop
	nop
	move	y:(r6+n6),x1

	mac   x1,y1,a        y:(r4)+,y1      x:(r3)+,x1	    
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r3)+,x1	    
	nop

	mac   x1,y1,a        y:(r4)+,y1      x:(r3),x1
	nop
	
      mac   x1,y1,a
	nop

	asl a
	nop
	asl a
	nop

	move  a,x:(r3)

	rts

;******************************************************************************
	; inclu les routines
	include     'ada_init.asm'	; used to include codec initialization routines
	include	'sci_init'		; inclu la routine d'initialisation du port SCI	
;******************************************************************************

      end