;******************************************************************************
; $Id: clock.asm,v 0.4 2003/04/27 16:07:31 soldani Exp $
;
; Maxime DECHESNE (2EN), Renaud DEMARNEFFE (2ELIN), Philippe RIES (2EN),
; Cyril SOLDANI (2ELIN).
;
; Travail pratique dans le cadre du cours de Systmes Programms Enfouis.
; Horloge  persistance rtinienne.
;******************************************************************************

#include <p16f877.inc>
;#include <p16F877.inc>

; Choix et configuration du processeur (16f877)
;==============================================================================

	list	p=16F877, f=inhx16

	__CONFIG _CP_OFF & _DEBUG_OFF & _WRT_ENABLE_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC

; _CP_OFF		; Pas de protection du code
; _DEBUG_OFF		; RB6 et RB7 en utilisation normale
; _WRT_ENABLE_OFF	; Le programme ne peut pas crire dans la mmoire flash
; _CPD_OFF		; Mmoire EEPROM non protge
; _LVP_OFF		; RB3 en utilisation normale
; _BODEN_ON		; Reset du PIC si la tension tombe en dessous de 4 V
; _PWRTE_ON		; Dmarrage temporis
; _WDT_OFF		; Watchdog dsactiv
; _HS_OSC		; Oscillateur haute vitesse (4 MHz < f < 20 MHz)

; Constantes
;==============================================================================

; Valeur du registre d'options
; 7	RBPU	Rsistances de rappel du PORTB dsactives
; 6	INTEDG	Interruption sur flanc montant de RB0/INT
; 5	TOCS	TMR0 sur l'horloge interne
; 4	TOSE	N/A
; 3	PSA	Assignation du prdiviseur sur Watchdog
; 2:0	PS	Valeur du prdiviseur 1/1
#define	OPTION_VALUE b'11000000'

; Valeur du registre de contrle d'interruptions standards
; 7	GIE	Interruptions actives
; 6	PEIE	Interruptions priphriques actives
; 5	T0IE	Masque l'interruption d'overflow de TMR0
; 4	INTE	Active l'interruption RB0/INT
; 3	RBIE	Masque l'interruption RB4/RB7
; 2	T0IF	Mise  0 du flag TMR0
; 1	INTF	Mise  0 du flag RB0/INT
; 0	RBIF	Mise  0 du flag RB4/RB7
#define	INTCON_VALUE b'11010000'

; Valeur du registre de contrle d'interruptions priphriques 1
; 7	PSPIE	Port parallle dsactiv
; 6	ADIE	Convertisseur A/D dsactiv
; 5	RCIE	Rception USART dsactive
; 4	TXIE	Transmission USART dsactive
; 3	SSPIE	Port srie synchrone dsactiv
; 2	CCP1IE	Comparateur 1 dsactiv
; 1	TMR2IE	Masque l'interruption d'overflow de TMR2
; 0	TMR1IE	Masque l'interruption d'overflow de TMR1
#define	PIE1_VALUE b'00000000'

; Valeur du registre de contrle d'interruptions priphriques 2
; 7		Non implment
; 6		Rserv
; 5		Non implment
; 4	EEIE	Masque l'interruption d'criture EEPROM
; 3	BCLIE	Masque l'interruption de collision sur le bus
; 2		Non implment
; 1		Non implment
; 0	CCP2IE	Comparateur 2 dsactiv
#define	PIE2_VALUE b'00000000'

; Valeur du registre de contrle pour le compteur 1
; 7:6		Non implment
; 5:4	T1CKPS	Prdivision 1/1
; 3	T1OSCEN	Oscillateur coup
; 2	T1SYNC	N/A
; 1	TMR1CS	Horloge interne
; 0	TMR1ON	Compteur 1 activ
#define	T1CON_VALUE	b'00000001'

; Valeur du registre de contrle pour le comparateur 1
; 7:6		Non implment
; 5	CCP1X	N/A
; 6	CCP1Y	N/A
; 3:0	CCP1M	Comparaison avec interruption
#define	CCP1CON_VALUE b'00001010'

; Direction des ports d'entre/sortie (les autres ports sont par dfaut en
; entre)
#define	TRISB_VALUE	b'11111111'	; Direction PORTB
#define	TRISD_VALUE	b'00000100'	; Direction PORTD (sorties sauf PORTD2)

; Variables "drapeau"
#define	START		flags, 0	; Indique qu'on a pass le capteur
#define	DISPLAY		flags, 1	; Indique si on doit afficher ou non

; Addresses relatives des caractres en EEPROM
#define	ZERO	0x00
#define	ONE	0x06
#define	TWO	0x0c
#define	THREE	0x12
#define	FOUR	0x18
#define	FIVE	0x1E
#define	SIX	0x24
#define	SEVEN	0x2A
#define	EIGHT	0x30
#define	NINE	0x36
#define	COLON	0x3C

; Constantes pour la mesure des secondes
#define	SECOND2	b'01001100'		; Bits 23:16
#define	SECOND1	b'01001011'		; Bits 15:8
#define	SECOND0	b'01000000'		; Bits 7:0

; Macros
;==============================================================================

; Passage en banque 0
BANK0	macro
	bcf	STATUS, RP0
	bcf	STATUS, RP1
	endm

; Passage en banque 1
BANK1	macro
	bsf	STATUS, RP0
	bcf	STATUS, RP1
	endm

; Passage en banque 2
BANK2	macro
	bcf	STATUS, RP0
	bsf	STATUS, RP1
	endm

; Place la valeur  l'adresse donne dans l'EEPROM dans w.
; IN:
; - address: addresse de la valeur dans l'EEPROM (addresse relative)
; OUT:
; - valeur contenue dans l'EEPROM
; NOTE:
; - Le programme est plac en banque 0 aprs l'excution de cette macro
READ_EEPROM macro address
	movf	address, w	; Charge l'adresse EEPROM
	BANK2			; Passe en banque 2
	movwf	EEADR & 0x7F	; Place la valeur dans le registre d'adresse
	bsf	STATUS, RP0	; Passe en banque 3
	bsf	EECON1 & 0x7F, RD ; Effectue la lecture EEPROM
	bcf	STATUS, RP0	; Repasse en banque 2
	movf	EEDATA & 0x7F, w ; Place la valeur dans w
	BANK0			; Revient en banque 0
	endm

; Variables
;==============================================================================

; Banque 0
	cblock	0x20		; Dbut de zone (0x20  0x6F)
	; Variables "drapeau"
	flags : 1		; 0	START
				; 1	DISPLAY
	; Indicateurs d'avancement
	columns : 1		; Nombre de colonnes restant  afficher pour le
				; caractre courant
	chars : 1		; Indique les caractres dj affichs
	; Adresses des caractres en EEPROM
	char : 1		; Caractre courant
	; Secondes
	char1 : 1		; Premier caractre
	char2 : 1		; Deuxime caractre
	; Minutes
	char3 : 1		; Troisime caractre
	char4 : 1		; Quatrime caractre
	; Heures
	char5 : 1		; Cinquime caractre
	char6 : 1		; Sixime caractre
	; Dure du tour prcdent
	round2 : 1		; Bits 23:16
	round1 : 1		; Bits 15:8
	round0 : 1		; Bits 7:0
	; Dure inter-tranche
	slice1 : 1		; Bits 15:8
	slice0 : 1		; Bits 7:0
	; Compteur de temps
	time2 : 1		; Bits 23:16
	time1 : 1		; Bits 15:8
	time0 : 1		; Bits 7:0
	endc			; Fin de la zone

; Zone commune
	cblock	0x70		; Dbut de la zone (0x70  0x7F)
	; Variables pour la sauvegarde du contexte
	_w : 1			; Sauvegarde de l'accumulateur
	_STATUS : 1		; Sauvegarde de STATUS
	endc			; Fin de la zone

; Banque 1
	cblock	0xA0		; Dbut de la zone (0xA0  0xEF)
	endc			; Fin de la zone

; Banque 2
	cblock	0x120		; Dbut de la zone (0x120  0x16F)
	endc			; Fin de la zone

; Banque 3
	cblock	0x1A0		; Dbut de la zone (0x1A0  0x1EF)
	endc			; Fin de la zone

; Point d'entre sur reset
;==============================================================================

	org	0x000		; Adresse de dpart aprs reset
	goto	init		; Initialisation

; Interruptions
;==============================================================================

	org	0x004

; Sauvegarde du contexte
	movwf	_w		; Sauve l'accumulateur
	swapf	STATUS, w	; Swappe STATUS avec rsultat dans w
	movwf	_STATUS		; Sauve STATUS swapp

; Slection de l'interruption
	BANK0			; Passe en banque 0
	btfss	INTCON, INTF	; Y a-t-il une interruption RB0/INT en cours ?
	goto	CCP1		; Non => interruption du comparateur 1

; Interruption de capteur (RB0/INT)
	bcf	T1CON, TMR1ON	; Dsactive le compteur 1 pour viter de lire
				; une valeur errone
	; Mmorise la valeur du compteur 1 (bits 15:0 de la dure du tour
	; prcdent)
	movf	TMR1L, w	; Bits 7:0
	movwf	round0
	movf	TMR1H, w	; Bits 15:8
	movwf	round1
	; Remet en service le compteur 1 en tenant compte de la dure pendant
	; laquelle il est dsactiv (8 cycles)
	movlw	0x08		; Partie basse
	movwf	TMR1L
	clrf	TMR1H		; Partie haute
	bsf	T1CON, TMR1ON	; Ractive le compteur
	
	bsf	START		; Indique qu'on vient de passer le capteur
	
	bcf	INTCON, INTF	; Efface le flag d'interruption RB0/INT
	goto	restore		; Restaure le contexte

; Interruption de comparateur (CCP1)
CCP1:
	btfsc	DISPLAY		; Doit-on afficher ?
	goto	display		; Oui, faisons le
	bsf	DISPLAY		; Non, c'est pour la prochaine fois
	bcf	PIR1, CCP1IF 	; Efface le flag d'interruption CCP1
	goto	restore		; Restaure le contexte
	
display:
	; Place le pattern adquat sur les LEDs
	READ_EEPROM char	; Charge le pattern  partir de l'EEPROM
	movwf	PORTD		; Allume les LEDs
	decf	columns, f	; Dcrmente l'indicateur de colonne et vrifie
				; que ce n'est pas la dernire
	btfsc	STATUS, Z
	goto	update		; C'est la dernire, passe au caractre suivant
	incf	char, f		; Ce n'est pas la dernire, passe  la colonne
				; suivante
	goto	CCP1_end

update:				; Passe au caractre suivant
	btfss	chars, 0	; Choix du caractre
	goto	update2		; Deuxime (s)
	btfss	chars, 1
	goto	update_colon1	; :
	btfss	chars, 2
	goto	update3		; Troisime (m)
	btfss	chars, 3
	goto	update4		; Quatrime (m)
	btfss	chars, 4
	goto	update_colon2	; :
	btfss	chars, 5
	goto	update5		; Cinquime (h)
	btfss	chars, 6
	goto	update6		; Sixime (h)
	; Tous les caractres ont t affichs, dsactive l'interruption
	bsf	STATUS, RP0	; Passe en banque 1
	bcf	PIE1 & 0x7F, CCP1IE ; Dsactive le comparateur 1
	bcf	STATUS, RP0	; Repasse en banque 0
	bcf	PIR1, CCP1IF 	; Efface le flag d'interruption CCP1
	goto	restore

update2:			; Passage au caractre 2
	movf	char2, w	; Change le caractre
	movwf	char
	movlw	0x06		; Remet le compteur de colonnes  6
	movwf	columns
	bsf	chars, 0	; Indique que le caractre 1  t lu
	goto	CCP1_end
	
update_colon1:			; Passage au ':'
	movlw	COLON		; Change le caractre
	movwf	char
	movlw	0x05		; Met le compteur de colonnes  5
	movwf	columns
	bsf	chars, 1	; Indique que le caractre ':'  t lu
	goto	CCP1_end
	
update3:			; Passage au caractre 3
	movf	char3, w	; Change le caractre
	movwf	char
	movlw	0x06		; Remet le compteur de colonnes  6
	movwf	columns
	bsf	chars, 2	; Indique que le caractre 2  t lu
	goto	CCP1_end
	
update4:			; Passage au caractre 4
	movf	char4, w	; Change le caractre
	movwf	char
	movlw	0x06		; Remet le compteur de colonnes  6
	movwf	columns
	bsf	chars, 3	; Indique que le caractre 3  t lu
	goto	CCP1_end

update_colon2:			; Passage au ':'
	movlw	COLON		; Change le caractre
	movwf	char
	movlw	0x05		; Met le compteur de colonnes  5
	movwf	columns
	bsf	chars, 4	; Indique que le caractre ':'  t lu
	goto	CCP1_end
	
update5:			; Passage au caractre 5
	movf	char5, w	; Change le caractre
	movwf	char
	movlw	0x06		; Remet le compteur de colonnes  6
	movwf	columns
	bsf	chars, 5	; Indique que le caractre 5  t lu
	goto	CCP1_end
	
update6:			; Passage au caractre 6
	movf	char6, w	; Change le caractre
	movwf	char
	movlw	0x06		; Remet le compteur de colonnes  6
	movwf	columns
	bsf	chars, 6	; Indique que le caractre 3  t lu
	goto	CCP1_end

CCP1_end:
	; Rgle le comparateur avec la dure inter-tranche
	movf	slice0, w	; Partie basse
	addwf	CCPR1L, f
	btfsc	STATUS, C	; Y a-t-il eu un dbordement ?
	incf	CCPR1H, f	; Oui, incrmente la partie haute
	movf	slice1, w	; Partie haute
	addwf	CCPR1H, f
	bcf	PIR1, CCP1IF 	; Efface le flag d'interruption CCP1
;	goto	restore

; Restauration
restore:
	swapf	_STATUS, w	; Swappe l'ancien STATUS swapp, rsultat dans
				; w
	movwf	STATUS		; Restaure le STATUS
	swapf	_w, f		; Swappe l'ancien accumulateur, rsultat dans
				; _w
	swapf	_w, w		; Reswappe avec rsultat dans w (restauration
				; de w)
	retfie			; Retour au code interrompu

; Programme
;==============================================================================

; Initialisation
init:
	clrf	PCLATH		; Passage en page 0
	
	; Rglage des ports (les ports non configur ici ont les valeurs
	; souhaites aprs un reset)
	BANK1			; Slection de la banque 1
	movlw	TRISB_VALUE	; Direction de PORTB
	movwf	TRISB & 0x7F
	movlw	TRISD_VALUE	; Direction de PORTD
	movwf	TRISD & 0x7F
	
	; Initialisation des options
	movlw	OPTION_VALUE
	movwf	OPTION_REG & 0x7F
	
	; Initialisation des interruptions priphriques 1
	movlw	PIE1_VALUE
	movwf	PIE1 & 0x7F

	; Initialisation des interruptions priphriques 2
	movlw	PIE2_VALUE
	movwf	PIE2 & 0x7F
	
	; Initialisation du comparateur 1
	bcf	STATUS, RP0	; Passe en banque 0
	movlw	CCP1CON_VALUE
	movwf	CCP1CON
	
	; Initialisation de l'heure
	movlw	ZERO
	movwf	char1
	movwf	char2
	movlw	EIGHT
	movwf	char3
	movlw	FIVE
	movwf	char4
	movlw	THREE
	movwf	char5
	movlw	TWO
	movwf	char6
	
	; Activation du compteur 1
	movlw	T1CON_VALUE
	movwf	T1CON
	
	; Activation des interruptions
	clrf	PIR1		; Met  0 le flag des interruptions
				; priphriques 1
	movlw	INTCON_VALUE	; Active les interruptions gnrales
	movwf	INTCON
	
;	goto	start		; Passe au programme principal

; Programme principal
start:
	bcf	START		; Remet START  0
	
	; Vrifie que le compteur 1 ne vient pas de boucler pendant
	; l'interruption de capteur
	btfss	PIR1, TMR1IF	; Y a-t-il eu overflow du compteur ?
	goto	hour_update	; Non, continue
	incf	round2, f	; Oui, incrmente le compteur (bits 23:16)
	bcf	PIR1, TMR1IF	; Remet le flag d'overflow du compteur 1  0
	
	; Mise  jour de l'heure
hour_update:
	; Ajout de la dure du tour prcdent  la dure depuis la dernire
	; seconde
	movf	round0, w	; Bits 7:0
	addwf	time0, f
	btfss	STATUS, C	; Y a-t-il eu dbordement ?
	goto	continue1	; Non, continue
	incf	time1, f	; Oui, incrmente time1 (bits 15:8)
	btfsc	STATUS, Z	; Y a-t-il eu dbordement ?
	incf	time2, f	; Oui, incrmente time2 (bits 23:16)
continue1:
	movf	round1, w	; Bits 15:8
	addwf	time1, f
	btfsc	STATUS, C	; Y a-t-il eu dbordement ?
	incf	time2, f	; Oui, incrmente time2 (bits 23:16)
	movf	round2, w	; Bits 23:16
	addwf	time2, f

	; A-t-on entam une nouvelle seconde ?
	movf	time2, w	; Testons la partie haute (23:16)
	sublw	SECOND2
	btfss	STATUS, C	; time2 > SECOND2 ?
	goto	new_second	; Oui, on a dpass la dure d'une seconde
	movf	time2, w
	sublw	SECOND2
	btfss	STATUS, Z	; time2 = SECOND2 ?
	goto	done		; Non, on n'a pas dpass la seconde
	movf	time1, w	; Testons la partie intermdiaire (15:8)
	sublw	SECOND1
	btfss	STATUS, C	; time1 > SECOND1 ?
	goto	new_second	; Oui, on a dpass la dure d'une seconde
	movf	time1, w
	sublw	SECOND1
	btfss	STATUS, Z	; time1 = SECOND1 ?
	goto	done	; Non, on n'a pas dpass la seconde
	movf	time0, w	; Testons la partie basse (7:0)
	sublw	SECOND0
	btfsc	STATUS, C	; time0 > SECOND0 ?
	goto	done	; Non, on n'a pas dpass la seconde
;	goto	new_second	; Oui, on a dpass la dure d'une seconde

new_second:
	; Soustrait une seconde du compteur de temps
	movlw	SECOND0		; Partie basse (bit 7:0)
	subwf	time0, f
	btfsc	STATUS, C	; Y a-t-il eu dbordement ?
	goto	continue2	; Non, continue
	decf	time1, f	; Oui, dcrmente time1
	btfsc	STATUS, Z	; Y a-t-il eu dbordement ?
	decf	time2, f	; Oui, dcrmente time2
continue2:
	movlw	SECOND1		; Partie intermdiaire (15:8)
	subwf	time1, f
	btfss	STATUS, C	; Y a-t-il eu dbordement ?
	decf	time2, f	; Oui, dcrmente time2
	movlw	SECOND2		; Partie haute (23:16)
	subwf	time2, f

	; Incrmente l'affichage
	movf	char1, w	; Premier caractre
	sublw	NINE
	btfsc	STATUS, Z	; Le caractre est-il 9 ?
	goto	nine1		; Oui, mettre le premier caractre  0 et
				; incrmenter le second
	movlw	0x06		; Non, incrmente le premier caractre
	addwf	char1, f
	goto	done
nine1:
;	movlw	ZERO		; Met le premier caractre  0
;	movwf	char1
	clrf	char1
	movf	char2, w	; Deuxime caractre
	sublw	FIVE
	btfsc	STATUS, Z	; Le caractre est-il 5 ?
	goto	five1		; Oui, mettre le deuxime caractre  0 et
				; incrmenter le troisime
	movlw	0x06		; Non, incrmente le deuxime caractre
	addwf	char2, f
	goto	done
five1:
;	movlw	ZERO		; Met le deuxime caractre  0
;	movwf	char2
	clrf	char2
	movf	char3, w	; Troisime caractre
	sublw	NINE
	btfsc	STATUS, Z	; Le caractre est-il 9 ?
	goto	nine2		; Oui, mettre le troisime caractre  0 et
				; incrmenter le quatrime
	movlw	0x06		; Non, incrmente le troisime caractre
	addwf	char3, f
	goto	done
nine2:
;	movlw	ZERO		; Met le troisime caractre  0
;	movwf	char3
	clrf	char3
	movf	char4, w	; Quatrime caractre
	sublw	FIVE
	btfsc	STATUS, Z	; Le caractre est-il 5 ?
	goto	five2		; Oui, mettre le quatrime caractre  0 et
				; incrmenter le cinquime
	movlw	0x06		; Non, incrmente le quatrime caractre
	addwf	char4, f
	goto	done
five2:
;	movlw	ZERO		; Met le quatrime caractre  0
;	movwf	char4
	clrf	char4
	movf	char5, w	; Cinquime caractre
	sublw	NINE
	btfsc	STATUS, Z	; Le caractre est-il 9 ?
	goto	nine3		; Oui, mettre le cinquime caractre  0 et
				; incrmenter le sixime
	movf	char5, w
	sublw	THREE
	btfsc	STATUS, Z	; Le caractre est-il 3 ?
	goto	three		; Oui, vrifie qu'il n'y a pas de changement de
				; jour
inc_char5:
	movlw	0x06		; Non, incrmente le cinquime caractre
	addwf	char5, f
	goto	done
three:
	movf	char6, w
	sublw	TWO
	btfsc	STATUS, Z	; Le sixime caractre est-il 2 ?
	goto	two		; Oui, met les cinquime et sixime
				; caractres  zro
	goto	inc_char5	; Non, incrmente le cinquime caractre
two:
;	movlw	ZERO		; Met le cinquime caractre  0
;	movwf	char5
;	movwf	char6		; Met le sixime caractre  0
	clrf	char5
	clrf	char6
	goto	done
nine3:
;	movlw	ZERO		; Met le cinquime caractre  0
;	movwf	char5
	clrf	char5
	movf	char6, w	; Sixime caractre
	sublw	TWO
	btfsc	STATUS, Z	; Le caractre est-il 2 ?
	goto	two		; Oui, mettre le sixime caractre  0
	movlw	0x06		; Non, incrmente le sixime caractre
	addwf	char6, f
;	goto	done

done:
	; Prpare la routine d'affichage
	movf	char1, w
	movwf	char
	movlw	0x06		; Le premier caractre fera 6 colonnes
	movwf	columns
	clrf	chars		; Aucun caractre n'a t lu

	; Rglage du comparateur
	; La valeur dans round donne la dure du tour prcdent sur 24
	; bits. Comme nous voulons dclencher le comparateur au seizime du
	; cercle, nous devons diviser cette valeur par seize ce qui revient 
	; la dcaler de quatre bits vers la droite. Les bits 24:20 sont
	; toujours  zro pour les frquences > 5 Hz.

	; Chargement des bits 11:4 dans la partie basse du comparateur
	movf	round0, w	; Charge les bits 7:0 dans la partie basse du
				; comparateur 1
	movwf	CCPR1L
	bcf	STATUS, C	; Place le bit 8 dans le carry
	btfsc	round1, 0
	bsf	STATUS, C
	rrf	CCPR1L, f	; Les bits 8:1 sont dans CCPR1L
	bcf	STATUS, C	; Place le bit 9 dans le carry
	btfsc	round1, 1
	bsf	STATUS, C
	rrf	CCPR1L, f	; Les bits 9:2 sont dans CCPR1L
	bcf	STATUS, C	; Place le bit 10 dans le carry
	btfsc	round1, 2
	bsf	STATUS, C
	rrf	CCPR1L, f	; Les bits 10:3 sont dans CCPR1L
	bcf	STATUS, C	; Place le bit 11 dans le carry
	btfsc	round1, 3
	bsf	STATUS, C
	rrf	CCPR1L, f	; Les bits 11:4 sont dans CCPR1L

	; Chargement des bits 19:12 dans la partie haute du comparateur
	movf	round1, w	; Charge les bits 15:8 dans la partie haute du
				; comparateur 1
	movwf	CCPR1H
	bcf	STATUS, C	; Place le bit 16 dans le carry
	btfsc	round2, 0
	bsf	STATUS, C
	rrf	CCPR1H, f	; Les bits 16:9 sont dans CCPR1H
	bcf	STATUS, C	; Place le bit 17 dans le carry
	btfsc	round2, 1
	bsf	STATUS, C
	rrf	CCPR1H, f	; Les bits 17:10 sont dans CCPR1H
	bcf	STATUS, C	; Place le bit 18 dans le carry
	btfsc	round2, 2
	bsf	STATUS, C
	rrf	CCPR1H, f	; Les bits 18:11 sont dans CCPR1H
	bcf	STATUS, C	; Place le bit 19 dans le carry
	btfsc	round2, 3
	bsf	STATUS, C
	rrf	CCPR1H, f	; Les bits 19:12 sont dans CCPR1H

	; Comme nous ne voulons pas afficher au seizime de tour mais au
	; huitime, nous indiquons  la routine d'interruption de comparateur
	; de ne pas afficher
	bcf	DISPLAY

	; Calcul du temps inter-tranche
	; Le temps inter-tranche fix  1/128 tour est contenu dans round
	; 22:7 (le bit 23 vaut toujours 0  la frquence de travail)

	; Charge les bits 22:15 dans slice1
	movf	round2, w	; Charge les bits 23:16
	movwf	slice1
	bcf	STATUS, C	; Place le bit 15 dans le carry
	btfsc	round1, 7
	bsf	STATUS, C
	rlf	slice1, f	; Les bits 22:15 sont dans slice1

	; Charge les bits 14:7 dans slice0
	movf	round1, w	; Charge les bits 15:8
	movwf	slice0
	bcf	STATUS, C	; Place le bit 7 dans le carry
	btfsc	round0, 7
	bsf	STATUS, C
	rlf	slice0, f	; Les bits 14:7 sont dans slice0

	; Remet  zro le compteur de dure de tour. Seuls les bits 23:16
	; doivent tre effacs car les autres seront crass par l'interruption
	; de capteur
	clrf	round2
	
	; Mise en service du comparateur 1
	bcf	PIR1, CCP1IF 	; Efface le flag d'interruption CCP1
	bsf	STATUS, RP0	; Passage en banque 1
	bsf	PIE1 & 0x7F, CCP1IE ; Activation
	bcf	STATUS, RP0	; Retour en banque 0
	
	; Attend le passage devant le capteur en mesurant le temps
loop:
	btfsc	START
	goto	start		; START est pass  1, on recommence
	; Mesure du temps
	btfsc	PIR1, TMR1IF	; Y a-t-il eu overflow du compteur ?
	goto	increment	; Oui, incrmente round2
	goto	loop		; Non, boucle

	; Incrmente le compteur (bits 23:16)
increment:
	incf	round2, f
	bcf	PIR1, TMR1IF	; Remet le flag d'overflow du compteur 1  0
	goto	loop		; Continue  boucler

; Mmoire EEPROM
;==============================================================================

	org	0x2100

	de	b'11010011'	; 0
	de	b'00101000'
	de	b'00101000'
	de	b'11010011'
	de	b'00000000'
	de	b'00000000'

	de	b'11111011'	; 1
	de	b'00010000'
	de	b'01000000'
	de	b'10000000'
	de	b'00000000'
	de	b'00000000'

	de	b'01011000'	; 2
	de	b'10101000'
	de	b'00101010'
	de	b'01011001'
	de	b'00000000'
	de	b'00000000'

	de	b'01010011'	; 3
	de	b'10101000'
	de	b'10101000'
	de	b'00010001'
	de	b'00000000'
	de	b'00000000'

	de	b'11111011'	; 4
	de	b'10000000'
	de	b'10000000'
	de	b'11110000'
	de	b'00000000'
	de	b'00000000'

	de	b'00100011'	; 5
	de	b'10101000'
	de	b'10101000'
	de	b'11111000'
	de	b'00000000'
	de	b'00000000'

	de	b'00010011'	; 6
	de	b'10101000'
	de	b'10101000'
	de	b'11010011'
	de	b'00000000'
	de	b'00000000'

	de	b'01110000'	; 7
	de	b'10100000'
	de	b'00100010'
	de	b'00101001'
	de	b'00000000'
	de	b'00000000'

	de	b'01010011'	; 8
	de	b'10101000'
	de	b'10101000'
	de	b'01010011'
	de	b'00000000'
	de	b'00000000'

	de	b'11010011'	; 9
	de	b'10101000'
	de	b'10101000'
	de	b'01010001'
	de	b'00000000'
	de	b'00000000'

	de	b'00000000'	; :
	de	b'00010001'
	de	b'00000000'
	de	b'00000000'
	de	b'00000000'

	end
