/*
 * Decompiled with CFR 0.152.
 */
package bsim;

import bsim.Beta;
import bsim.Program;
import gui.EditBuffer;
import gui.GuiFrame;
import gui.POSTStream;
import gui.VramPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;

public class BSim
extends GuiFrame
implements ActionListener,
WindowListener {
    public static String version = "1.1.11 vr2";
    public static String copyright = "Copyright (C) Christopher J. Terman 2000-2006";
    public static final String ASSEMBLE = "Run UASM";
    public static final String A2FILE = "UASM to .bin file";
    public static final String STOP = "Stop";
    public static final String RUN = "Run";
    public static final String STEP = "Single Step";
    public static final String RESET = "Reset";
    public static final String CACHE = "Cache control";
    public static final String DISPLAY = "Toggle state display";
    GuiFrame plot;
    JFrame vramFrame;
    VramPanel vram;

    public BSim(String[] stringArray) {
        super(stringArray, "BSim " + version, true, false);
        this.setIconImage(this.GetImageResource("/icons/bsim.gif"));
        this.AddToolButton("/icons/exit.gif", "Exit", this);
        this.AddToolSeparator();
        this.AddToolButton("/icons/new.gif", "New File", this);
        this.AddToolButton("/icons/open.gif", "Open File", this);
        this.AddToolButton("/icons/close.gif", "Close file", this);
        this.AddToolButton("/icons/reload.gif", "Reload Files", this);
        this.AddToolButton("/icons/save.gif", "Save File", this);
        this.AddToolButton("/icons/saveas.gif", "Save As", this);
        this.AddToolButton("/icons/saveall.gif", "Save All Files", this);
        this.AddToolSeparator();
        this.AddToolButton("/icons/assemble.gif", ASSEMBLE, this);
        this.AddToolButton("/icons/a2file.gif", A2FILE, this);
        this.AddToolSeparator();
        this.AddToolButton("/icons/window.gif", "Switch to plot window", this);
        this.AddToolButton("/icons/submit.gif", "Complete checkoff", this);
        this.Message("BSim " + version + ", " + copyright);
        this.vram = new VramPanel();
        this.vramFrame = this.vram.frameit();
        this.plot = new GuiFrame(null, "Bsim Display Window", false, false);
        this.plot.setIconImage(this.GetImageResource("/icons/bsim.gif"));
        this.plot.AddToolButton("/icons/bstop.gif", STOP, this.plot);
        this.plot.AddToolButton("/icons/breset.gif", RESET, this.plot);
        this.plot.AddToolButton("/icons/brun.gif", RUN, this.plot);
        this.plot.AddToolButton("/icons/bstep.gif", STEP, this.plot);
        this.plot.AddToolSeparator();
        this.plot.AddToolButton("/icons/display.gif", DISPLAY, this.plot);
        this.plot.AddToolSeparator();
        this.plot.AddToolButton("/icons/cache.gif", CACHE, this.plot);
        this.plot.AddToolButton("/icons/window.gif", "Switch to edit window", this);
        this.plot.AddToolButton("/icons/submit.gif", "Complete checkoff", this);
        this.plot.setLocation(128, 64);
        this.SetTab(this.ReadFiles());
        this.plot.SetTab(this.IndexFor(this.Selectee()));
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        new BSim(stringArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            String string = actionEvent.getActionCommand();
            try {
                if (string.equals("Complete checkoff")) {
                    this.Checkoff();
                } else if (string.equals("Switch to edit window")) {
                    this.setVisible(true);
                    this.toFront();
                }
                if (string.equals("Switch to plot window")) {
                    this.plot.setVisible(true);
                    this.plot.toFront();
                } else {
                    super.actionPerformed(actionEvent);
                }
            }
            catch (Exception exception) {
                this.Message("Internal error: " + exception);
                String string2 = this.GetParameter("reporterrors");
                if (string2 == null) break block11;
                if (string2.equals("-reporterrors")) {
                    exception.printStackTrace(System.out);
                }
                try {
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2, true));
                    String string3 = DateFormat.getDateTimeInstance(2, 3).format(new Date());
                    String string4 = System.getProperty("user.name", "???");
                    String string5 = System.getProperty("hostname", "???");
                    printWriter.println("version=\"" + version + "\" time=\"" + string3 + "\" user=\"" + string4 + "@" + string5 + "\" action=\"" + string + "\"");
                    exception.printStackTrace(printWriter);
                    int n = this.tabPane.getTabCount();
                    for (int i = 0; i < n; ++i) {
                        EditBuffer editBuffer = (EditBuffer)this.tabPane.getComponentAt(i);
                        editBuffer.Capture(printWriter);
                    }
                    printWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void SetPlot(Component component) {
        this.plot.setVisible(true);
        this.vramFrame.setVisible(true);
        this.vramFrame.toFront();
        this.plot.toFront();
        this.plot.SetTab(component);
    }

    @Override
    public void RemoveTab(Component component) {
        int n = this.tabPane.indexOfComponent(component);
        this.RemoveTab(n);
        this.plot.RemoveTab(n);
    }

    @Override
    public EditBuffer ReadFiles() {
        EditBuffer editBuffer = super.ReadFiles();
        this.plot.SetTab(this.IndexFor(editBuffer));
        return editBuffer;
    }

    public Beta GetBeta(Component component) {
        return (Beta)this.plot.tabPane.getComponentAt(this.IndexFor(component));
    }

    @Override
    public Component OpenFile(File file, boolean bl) {
        if (this.lastDirectory == null && file != null) {
            this.lastDirectory = file.getParent();
        }
        Program program = new Program(this, file);
        this.AddTab(program.TabName(), program.ToolTip(), program, bl ? -1 : 0);
        Beta beta = new Beta(this, this.plot);
        this.plot.AddTab(program.TabName(), program.ToolTip(), beta, bl ? -1 : 0);
        if (file != null) {
            System.err.println(file.getName());
        }
        beta.memory.inspector = this.vram;
        return program;
    }

    public void Checkoff() {
        Program program = (Program)this.Selectee();
        String string = program.Checkoff();
        if (string != null) {
            this.ShowHTML("Checkoff failure...", string, 2);
            return;
        }
        this.DoCheckoff(program.checkoffServer);
    }

    @Override
    public void GeneratePostData(POSTStream pOSTStream) throws IOException {
        Program program = (Program)this.Selectee();
        pOSTStream.writeTag("pcheckoff");
        pOSTStream.write(program.assignment);
        pOSTStream.writeTag("checksum");
        pOSTStream.write(program.checkoffChecksum.toString());
        pOSTStream.writeTag("cycles");
        pOSTStream.write(String.valueOf(this.GetBeta((Component)program).cycles));
        pOSTStream.writeTag("size");
        pOSTStream.write(String.valueOf(program.Size()));
        pOSTStream.writeTag("version");
        pOSTStream.write("BSim" + version);
        Beta beta = program.beta;
        if (beta != null && beta.serverInfo.size() > 0) {
            ArrayList arrayList = beta.serverInfo;
            pOSTStream.writeTag("serverInfo");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i != 0) {
                    pOSTStream.write(",");
                }
                pOSTStream.write(arrayList.get(i).toString());
            }
        }
    }
}

