/*
 * Decompiled with CFR 0.152.
 */
package bsim;

import bsim.Macro;
import java.util.Hashtable;
import java.util.Vector;

public class Symbol {
    public static final int UNDEF = 0;
    public static final int ASSIGN = 1;
    public static final int LABEL = 2;
    public String name;
    public int value;
    public int type;
    public Vector mdefs;

    public Symbol(Hashtable hashtable, String string, int n, int n2) {
        this.name = string;
        this.value = n;
        this.type = n2;
        this.mdefs = new Vector();
        if (hashtable != null) {
            hashtable.put(string, this);
        }
    }

    public Symbol(Hashtable hashtable, String string) {
        this(hashtable, string, 0, 0);
    }

    public Symbol(Hashtable hashtable, String string, int n) {
        this(hashtable, string, n, 1);
    }

    public String toString() {
        return "<Symbol " + this.name + "=" + this.value + ">";
    }

    public Macro LookupMacro(int n) {
        for (int i = 0; i < this.mdefs.size(); ++i) {
            Macro macro = (Macro)this.mdefs.elementAt(i);
            if (macro.NParams() != n) continue;
            return macro;
        }
        return null;
    }

    public void ClearMacroDefinitions() {
        this.mdefs.setSize(0);
    }

    public void AddMacroDefinition(Macro macro) {
        this.mdefs.addElement(macro);
    }

    public static Symbol Lookup(Hashtable hashtable, String string, boolean bl) {
        Symbol symbol = (Symbol)hashtable.get(string);
        if (symbol == null && bl) {
            symbol = new Symbol(hashtable, string, 0, 0);
        }
        return symbol;
    }

    public static Symbol Lookup(Hashtable hashtable, String string) {
        return Symbol.Lookup(hashtable, string, true);
    }
}

