/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EditBuffer;
import gui.GuiDialog;
import gui.POSTStream;
import gui.ProgressTracker;
import gui.UI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GuiFrame
extends JFrame
implements ActionListener,
WindowListener,
ProgressTracker {
    public String[] cmdargs;
    public JToolBar bbar;
    public JTabbedPane tabPane;
    boolean mainWindow;
    Font displayFont;
    public JTextArea message;
    JScrollPane mscroll;
    String nextMessage;
    public String lastDirectory;
    JProgressBar progress;
    Object progressOwner;
    int progressValue;
    public Thread eventThread;
    Runnable UpdateProgress;
    Runnable UpdateMessage;
    HashMap imageResources;

    public GuiFrame(String[] stringArray, String string, boolean bl, boolean bl2) {
        super(string);
        this.setDefaultCloseOperation(0);
        this.imageResources = new HashMap();
        this.eventThread = null;
        this.mainWindow = bl;
        this.cmdargs = stringArray;
        this.setBackground(UI.BGCOLOR);
        this.displayFont = new Font("SansSerif", 0, 12);
        UIManager.put("ScrollBar.width", new Integer(10));
        this.UpdateProgress = new Runnable(){

            public void run() {
                if (GuiFrame.this.progress != null) {
                    GuiFrame.this.progress.setStringPainted(GuiFrame.this.progressValue != 0);
                    GuiFrame.this.progress.setValue(GuiFrame.this.progressValue);
                }
            }
        };
        this.UpdateMessage = new Runnable(){

            public void run() {
                if (GuiFrame.this.nextMessage != null) {
                    if (!GuiFrame.this.message.getText().equals(GuiFrame.this.nextMessage)) {
                        GuiFrame.this.message.setText(GuiFrame.this.nextMessage);
                    }
                } else {
                    GuiFrame.this.message.setText("");
                }
            }
        };
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.bbar = new JToolBar();
        this.bbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        container.add((Component)this.bbar, "North");
        this.tabPane = new JTabbedPane();
        container.add((Component)this.tabPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        container.add((Component)jPanel, "South");
        this.message = new JTextArea(1, 10);
        this.message.setEditable(false);
        this.message.setHighlighter(null);
        this.message.setBackground(Color.white);
        this.message.setFont(this.displayFont);
        this.mscroll = new JScrollPane(this.message, 21, 31);
        this.mscroll.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)this.mscroll, "Center");
        if (bl2) {
            this.progress = new JProgressBar();
            this.progress.setPreferredSize(new Dimension(75, 20));
            this.progress.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add((Component)this.progress, "East");
        } else {
            this.progress = null;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width = Math.min(815, dimension.width - 50);
        dimension.height = Math.min(630, dimension.height - 50);
        this.setSize(dimension.width, dimension.height);
        this.addWindowListener(this);
    }

    public JButton ImageButton(String string) {
        Image image = this.GetImageResource(string);
        return new JButton(new ImageIcon(image));
    }

    public JButton AddToolButton(String string, String string2, ActionListener actionListener) {
        return this.AddToolButton(this.bbar, string, string2, actionListener);
    }

    public JButton AddToolButton(JToolBar jToolBar, String string, String string2, ActionListener actionListener) {
        JButton jButton = this.ImageButton(string);
        jButton.setToolTipText(string2);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        jToolBar.add(jButton);
        return jButton;
    }

    public JToggleButton ImageToggleButton(String string) {
        Image image = this.GetImageResource(string);
        return new JToggleButton(new ImageIcon(image));
    }

    public JToggleButton AddToolToggleButton(String string, String string2, ActionListener actionListener) {
        return this.AddToolToggleButton(this.bbar, string, string2, actionListener);
    }

    public JToggleButton AddToolToggleButton(JToolBar jToolBar, String string, String string2, ActionListener actionListener) {
        JToggleButton jToggleButton = this.ImageToggleButton(string);
        jToggleButton.setToolTipText(string2);
        jToggleButton.setActionCommand(string2);
        jToggleButton.addActionListener(actionListener);
        jToolBar.add(jToggleButton);
        return jToggleButton;
    }

    public void AddToolSeparator() {
        this.AddToolSeparator(this.bbar);
    }

    public void AddToolSeparator(JToolBar jToolBar) {
        jToolBar.addSeparator();
    }

    public Component Selectee() {
        return this.tabPane.getSelectedComponent();
    }

    public void AddTab(String string, String string2, Component component, int n) {
        if (n == -1) {
            this.tabPane.addTab(string, null, component, string2);
        } else {
            this.tabPane.insertTab(string, null, component, string2, n);
        }
    }

    public void RemoveTab(Component component) {
        this.tabPane.remove(component);
    }

    public void RemoveTab(int n) {
        this.tabPane.remove(n);
    }

    public void RenameTab(Component component, String string, String string2) {
        int n = this.tabPane.indexOfComponent(component);
        if (n != -1) {
            this.tabPane.setTitleAt(n, string);
            this.tabPane.setToolTipTextAt(n, string2);
        }
    }

    public int IndexFor(Component component) {
        return this.tabPane.indexOfComponent(component);
    }

    public void SetChannels(int n) {
    }

    public void SetPlot(Component component) {
    }

    public void SetTab(Component component) {
        this.tabPane.setSelectedComponent(component);
    }

    public void SetTab(int n) {
        this.tabPane.setSelectedIndex(n);
    }

    public void ErrorDialog(String string) {
        GuiDialog guiDialog = new GuiDialog(this, "Error Message", true);
        guiDialog.ShowErrorMessage(string);
    }

    public void ErrorMessage(String string) {
        System.out.println(string);
        this.Message(string);
    }

    public void MessageSetup(int n, boolean bl) {
        this.message.setRows(n);
        this.mscroll.setHorizontalScrollBarPolicy(bl ? 30 : 31);
        this.mscroll.setVerticalScrollBarPolicy(bl ? 20 : 21);
    }

    public void Message(String string) {
        if (Thread.currentThread() == this.eventThread || this.eventThread == null) {
            if (string != null) {
                if (!this.message.getText().equals(string)) {
                    this.message.setText(string);
                }
            } else {
                this.message.setText("");
            }
            Toolkit.getDefaultToolkit().sync();
        } else {
            this.nextMessage = string;
            SwingUtilities.invokeLater(this.UpdateMessage);
        }
    }

    public void ClearMessage(String string) {
        if (string == null || this.message.getText().equals(string)) {
            this.Message("");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Point point = this.getLocationOnScreen();
        int n = point.x;
        int n2 = point.y;
        if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("New File")) {
            this.MakeUntitled();
        } else if (string.equals("Close file")) {
            EditBuffer editBuffer = (EditBuffer)this.Selectee();
            if (editBuffer != null) {
                if (!this.DiscardChanges(editBuffer)) {
                    return;
                }
                this.RemoveTab(editBuffer);
            }
            if (this.tabPane.getTabCount() == 0) {
                this.MakeUntitled();
            }
        } else if (string.equals("Open File")) {
            File file = this.GetFile(0);
            if (file != null) {
                int n3 = this.tabPane.getTabCount();
                for (int i = 0; i < n3; ++i) {
                    EditBuffer editBuffer = (EditBuffer)this.tabPane.getComponentAt(i);
                    if (!editBuffer.CompareFile(file)) continue;
                    if (this.DiscardChanges(editBuffer)) {
                        editBuffer.ReadSource(file);
                    }
                    this.SetTab(editBuffer);
                    return;
                }
                this.SetTab(this.OpenFile(file, false));
            }
        } else if (string.equals("Save File")) {
            EditBuffer editBuffer = (EditBuffer)this.Selectee();
            if (editBuffer != null) {
                editBuffer.Save(null);
            }
        } else if (string.equals("Save As")) {
            EditBuffer editBuffer = (EditBuffer)this.Selectee();
            if (editBuffer != null) {
                editBuffer.SaveAs();
            }
        } else if (string.equals("Reload Files")) {
            int n4 = this.tabPane.getTabCount();
            for (int i = 0; i < n4; ++i) {
                EditBuffer editBuffer = (EditBuffer)this.tabPane.getComponentAt(i);
                if (!this.DiscardChanges(editBuffer)) continue;
                editBuffer.Reload();
            }
            this.Message("File reloaded");
        } else if (string.equals("Save All Files")) {
            int n5 = this.tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                EditBuffer editBuffer = (EditBuffer)this.tabPane.getComponentAt(i);
                editBuffer.Save(null);
            }
        } else {
            ((ActionListener)((Object)this.Selectee())).actionPerformed(actionEvent);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.mainWindow) {
            if (!this.SaveAllFiles()) {
                this.setVisible(true);
                return;
            }
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public static void MemStat() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        System.out.println("used " + (l2 - l) + " free " + l + " total " + l2);
    }

    public String MergePathnames(File file, String string) {
        String string2;
        try {
            string2 = file.getCanonicalPath();
            int n = string2.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        }
        catch (Exception exception) {
            string2 = file.getParent();
        }
        return this.MergePathnames(string2, string);
    }

    public String MergePathnames(String string, String string2) {
        if (string2.startsWith(File.separator) || string2.length() > 2 && string2.charAt(1) == ':' || string == null) {
            return string2;
        }
        return string + File.separator + string2;
    }

    public File GetFile(int n) {
        int n2;
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
        int n3 = n2 = n == 0 ? jFileChooser.showOpenDialog(this) : jFileChooser.showSaveDialog(this);
        if (n2 == 1) {
            return null;
        }
        if (n2 == 0) {
            this.lastDirectory = jFileChooser.getCurrentDirectory().toString();
            return jFileChooser.getSelectedFile();
        }
        this.ErrorMessage("File open failed");
        return null;
    }

    public Image GetImage(String string, boolean bl) {
        Image image;
        try {
            image = this.getToolkit().getImage(string);
        }
        catch (Exception exception) {
            System.out.println("Exception from getImage " + string);
            return null;
        }
        if (image == null) {
            System.out.println("Can't find image " + string);
            return null;
        }
        return image;
    }

    public Image GetImageResource(String string) {
        Image image = (Image)this.imageResources.get(string);
        if (image == null) {
            try {
                URL uRL = this.getClass().getResource(string);
                if (uRL == null) {
                    System.out.println("using GetImage: " + string);
                    image = this.GetImage("icons/" + string, true);
                } else {
                    image = this.createImage((ImageProducer)uRL.getContent());
                }
                this.imageResources.put(string, image);
            }
            catch (Exception exception) {
                System.out.println("Exception in GetImageResource: " + exception);
                image = null;
            }
        }
        return image;
    }

    public static void waitForImage(Image image, Component component) {
        boolean bl = false;
        try {
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            bl = mediaTracker.isErrorID(0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            image = null;
        }
    }

    public boolean ProgressStart(Object object) {
        if (this.progress != null && this.progressOwner == null) {
            this.progressOwner = object;
            this.progressValue = 0;
            SwingUtilities.invokeLater(this.UpdateProgress);
            return true;
        }
        return false;
    }

    public boolean ProgressStart(Object object, Color color) {
        return this.ProgressStart(object);
    }

    public long ProgressStop(Object object) {
        if (this.progress != null && this.progressOwner == object) {
            this.progressOwner = null;
            this.progressValue = 0;
            SwingUtilities.invokeLater(this.UpdateProgress);
        }
        return 0L;
    }

    public void ProgressReport(Object object, double d) {
        if (this.progress != null && this.progressOwner == object) {
            this.progressValue = (int)(100.0 * d);
            SwingUtilities.invokeLater(this.UpdateProgress);
        }
    }

    public PrintJob StartPrinting(Dimension dimension, Dimension dimension2) {
        Properties properties = new Properties();
        PrintJob printJob = null;
        try {
            printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Plot", properties);
        }
        catch (Exception exception) {
            this.Message("can't get print job: " + exception);
            printJob = null;
        }
        if (printJob != null) {
            Font font = Font.decode("SansSerif-bold-14");
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int n = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            int n2 = 5;
            int n3 = n + 2 * n2;
            Dimension dimension3 = printJob.getPageDimension();
            int n4 = 40;
            int n5 = 35;
            dimension.height = dimension3.height - n4 - n3;
            dimension.width = dimension3.width - n5;
            dimension2.width = 20;
            dimension2.height = 20;
            return printJob;
        }
        this.Message("Can't get print job");
        return null;
    }

    public void PrintBanner(Graphics graphics, Dimension dimension, Dimension dimension2, String string) {
        Font font = Font.decode("SansSerif-bold-14");
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        int n2 = 5;
        int n3 = n + 2 * n2;
        String string2 = DateFormat.getDateTimeInstance(2, 3).format(new Date());
        int n4 = dimension2.height + dimension.height + n3 - fontMetrics.getMaxDescent() - n2;
        graphics.setColor(UI.BGCOLOR);
        graphics.fillRect(dimension2.width + 1, dimension2.height + dimension.height, dimension.width - 1, n3 - 1);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(string, dimension2.width + n2, n4);
        graphics.drawString(string2, dimension2.width + dimension.width - n2 - fontMetrics.stringWidth(string2), n4);
        graphics.drawRect(dimension2.width, dimension2.height + dimension.height - 1, dimension.width - 1, n3);
    }

    public EditBuffer FindBuffer(File file) {
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            EditBuffer editBuffer;
            Component component = this.tabPane.getComponentAt(i);
            if (!(component instanceof EditBuffer) || !(editBuffer = (EditBuffer)component).CompareFile(file)) continue;
            return editBuffer;
        }
        return (EditBuffer)this.OpenFile(file, true);
    }

    public EditBuffer FindTab(File file) {
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            EditBuffer editBuffer;
            Component component = this.tabPane.getComponentAt(i);
            if (!(component instanceof EditBuffer) || !(editBuffer = (EditBuffer)component).CompareFile(file)) continue;
            return editBuffer;
        }
        EditBuffer editBuffer = new EditBuffer(this, file, false);
        this.AddTab(editBuffer.TabName(), editBuffer.ToolTip(), editBuffer, -1);
        return editBuffer;
    }

    public Component OpenFile(File file, boolean bl) {
        return null;
    }

    public EditBuffer ReadFiles() {
        for (int i = 0; i < this.cmdargs.length; ++i) {
            File file;
            if (this.cmdargs[i].startsWith("--")) {
                ++i;
                continue;
            }
            if (this.cmdargs[i].startsWith("-") || (file = new File(this.cmdargs[i])) == null) continue;
            this.OpenFile(file, true);
        }
        if (this.tabPane.getTabCount() == 0) {
            this.OpenFile(null, true);
        }
        this.tabPane.setSelectedIndex(0);
        return (EditBuffer)this.tabPane.getComponentAt(0);
    }

    public void MakeUntitled() {
        this.SetTab(this.OpenFile(null, false));
    }

    public boolean DiscardChanges(EditBuffer editBuffer) {
        if (editBuffer != null && editBuffer.dirty) {
            GuiDialog guiDialog = new GuiDialog(this, "Discard changes?", true);
            return !guiDialog.ShowMessage("File has been changed since it was\nread from disk.  Discard changes?");
        }
        return true;
    }

    public boolean SaveAllFiles() {
        JComponent jComponent;
        Object object;
        JComponent jComponent2;
        Component component;
        int n;
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        ArrayList<EditBuffer> arrayList2 = new ArrayList<EditBuffer>();
        int n2 = this.tabPane.getTabCount();
        for (n = 0; n < n2; ++n) {
            component = this.tabPane.getComponentAt(n);
            if (!(component instanceof EditBuffer)) continue;
            jComponent2 = (EditBuffer)component;
            if (!jComponent2.dirty) continue;
            object = jComponent2.TabName();
            if (((String)object).endsWith("*")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            jComponent = new JCheckBox((String)object, null, true);
            arrayList.add((JCheckBox)jComponent);
            arrayList2.add((EditBuffer)jComponent2);
        }
        if (!arrayList.isEmpty()) {
            int n3;
            GuiDialog guiDialog = new GuiDialog(this, "Save Buffers", false);
            component = new JButton("Exit without saving");
            jComponent2 = new JButton("Exit");
            object = new JButton("Cancel");
            guiDialog.AddButton((JButton)jComponent2);
            guiDialog.AddButton((JButton)component);
            guiDialog.AddButton((JButton)object);
            jComponent = new JPanel();
            guiDialog.getContentPane().add("North", new JLabel("Select which buffers to save:"));
            guiDialog.getContentPane().add("Center", jComponent);
            jComponent.setLayout(new GridLayout(0, 1));
            int n4 = arrayList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                jComponent.add((JCheckBox)arrayList.get(n3));
            }
            guiDialog.pack();
            n3 = guiDialog.Show(0, 0) ? 1 : 0;
            if (n3 != 0 || guiDialog.exitButton == object) {
                return false;
            }
            if (guiDialog.exitButton == jComponent2) {
                for (int i = 0; i < n4; ++i) {
                    JCheckBox jCheckBox = (JCheckBox)arrayList.get(i);
                    if (!jCheckBox.isSelected()) continue;
                    ((EditBuffer)arrayList2.get(i)).Save(null);
                }
            }
        }
        this.Message("Cleaning up temporary files");
        for (n = 0; n < n2; ++n) {
            component = (EditBuffer)this.tabPane.getComponentAt(n);
            ((EditBuffer)component).CleanUp();
        }
        this.Message("");
        return true;
    }

    public String GetParameter(String string) {
        for (int i = 0; i < this.cmdargs.length; ++i) {
            if (this.cmdargs[i].startsWith("--") && this.cmdargs[i].endsWith(string)) {
                return this.cmdargs[i + 1];
            }
            if (!this.cmdargs[i].startsWith("-") || !this.cmdargs[i].endsWith(string)) continue;
            return this.cmdargs[i];
        }
        return null;
    }

    public void ShowHTML(String string, String string2, int n) {
        JEditorPane jEditorPane = new JEditorPane("text/html", "");
        jEditorPane.setEditable(false);
        JOptionPane jOptionPane = new JOptionPane(new JScrollPane(jEditorPane), n);
        JDialog jDialog = jOptionPane.createDialog(this, string);
        jDialog.setSize(500, 300);
        jEditorPane.setText(string2.toString());
        jDialog.show();
    }

    public void GeneratePostData(POSTStream pOSTStream) throws IOException {
    }

    public void DoCheckoff(String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel("Verification succeeded!");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel("Please enter your 6.004 user name and password:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        String string2 = System.getProperty("user.name", "???");
        gridBagConstraints.gridwidth = 1;
        jLabel = new JLabel("User name:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        JTextField jTextField = new JTextField(string2);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jPanel.add(jTextField);
        gridBagConstraints.gridwidth = 1;
        jLabel = new JLabel("Password:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        JPasswordField jPasswordField = new JPasswordField();
        gridBagLayout.setConstraints(jPasswordField, gridBagConstraints);
        jPanel.add(jPasswordField);
        gridBagConstraints.gridwidth = 1;
        jLabel = new JLabel("Collaboration:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        JTextArea jTextArea = new JTextArea(5, 30);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        int n = JOptionPane.showOptionDialog(this, jPanel, "Complete checkoff", 2, 3, null, null, null);
        if (n != 0) {
            return;
        }
        try {
            int n2;
            Object object;
            URL uRL = new URL("http://" + string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            POSTStream pOSTStream = new POSTStream(uRLConnection.getOutputStream());
            pOSTStream.writeTag("username");
            pOSTStream.write(jTextField.getText());
            pOSTStream.writeTag("userpassword");
            pOSTStream.write(jPasswordField.getPassword());
            pOSTStream.writeTag("sender");
            pOSTStream.write(string2);
            pOSTStream.writeTag("collaboration");
            pOSTStream.write(jTextArea.getText());
            this.GeneratePostData(pOSTStream);
            pOSTStream.writeTag("circuits");
            int n3 = this.tabPane.getTabCount();
            for (int i = 0; i < n3; ++i) {
                object = (EditBuffer)this.tabPane.getComponentAt(i);
                ((EditBuffer)object).Capture(pOSTStream);
            }
            pOSTStream.close();
            StringBuffer stringBuffer = new StringBuffer();
            object = uRLConnection.getInputStream();
            while ((n2 = ((InputStream)object).read()) != -1) {
                stringBuffer.append((char)n2);
            }
            ((InputStream)object).close();
            this.ShowHTML("Checkoff results", stringBuffer.toString(), 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Exception during checkoff: " + exception, "Checkoff failure...", 2);
        }
    }
}

