/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;

public class UI {
    public static final Color JADECOLOR = new Color(160, 208, 160);
    public static final Color BGCOLOR = Color.lightGray;
    public static final Color LIGHTBGCOLOR = new Color(230, 230, 230);
    public static final Color DARKBGCOLOR = Color.gray;
    public static final Color EDITBGCOLOR = Color.white;
    public static final Color GRIDCOLOR = new Color(160, 160, 160);
    public static final Color SELECTCOLOR = new Color(128, 192, 128);
    public static final Color PGRIDCOLOR1 = new Color(64, 64, 64);
    public static final Color PBGCOLOR1 = Color.black;
    public static final Color PSCALECOLOR1 = Color.yellow;
    public static final Color PSCALE2COLOR1 = Color.white;
    public static final Color PGRIDCOLOR2 = new Color(220, 220, 220);
    public static final Color PBGCOLOR2 = Color.white;
    public static final Color PSCALECOLOR2 = Color.black;
    public static final Color PSCALE2COLOR2 = Color.magenta;
    public static Color PGridColor = PGRIDCOLOR1;
    public static Color PBGColor = PBGCOLOR1;
    public static Color PScaleColor = PSCALECOLOR1;
    public static Color PScale2Color = PSCALE2COLOR1;
    public static final String CHAN1 = "Display 1 plot channel";
    public static final String CHAN2 = "Display 2 plot channels";
    public static final String CHAN4 = "Display 4 plot channels";
    public static final String CHAN8 = "Display 8 plot channels";
    public static final String CHAN16 = "Display 16 plot channels";
    public static final String CHECKOFF = "Complete checkoff";
    public static final String CLOSE = "Close file";
    public static final String EXIT = "Exit";
    public static final String FASTSIMULATE = "Fast Transient Analysis";
    public static final String GATESIMULATE = "Gate-level Simulation";
    public static final String NEW = "New File";
    public static final String OPEN = "Open File";
    public static final String PLOT = "Plot";
    public static final String PRINT = "Print";
    public static final String RELOAD = "Reload Files";
    public static final String SAVE = "Save File";
    public static final String SAVEALL = "Save All Files";
    public static final String SAVEBUFFERS = "Save Buffers";
    public static final String SAVEAS = "Save As";
    public static final String SIMULATE = "Device-level Simulation";
    public static final String STOP = "Stop Simulation";
    public static final String TIMINGANALYSIS = "Gate-level Timing Analysis";
    public static final String EDITWINDOW = "Switch to edit window";
    public static final String PLOTWINDOW = "Switch to plot window";

    private UI() {
    }

    public static int ReadLine(InputStream inputStream, ArrayList arrayList, StringBuffer stringBuffer) throws IOException {
        int n;
        int n2 = 0;
        arrayList.clear();
        int n3 = 0;
        stringBuffer.setLength(0);
        while (true) {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                System.out.println("IO exception reading library file: " + iOException);
                throw iOException;
            }
            if (n < 0) {
                if (n3 != 0) break;
                return -1;
            }
            if ((n == 13 || n == 10) && n3 > 0) break;
            stringBuffer.append((char)n);
            ++n3;
        }
        n2 = 0;
        n = 0;
        String string = stringBuffer.toString();
        while (true) {
            int n4;
            if (n < n3 && string.charAt(n) <= ' ') {
                ++n;
                continue;
            }
            if (n == n3 || string.charAt(n) == ';') break;
            if (string.charAt(n) == '\"') {
                n4 = ++n;
                int n5 = 0;
                while (n < n3 && string.charAt(n) != '\"') {
                    if (string.charAt(n) == '\\') {
                        ++n5;
                        if (string.charAt(++n) == 'u') {
                            n5 += 4;
                            n += 4;
                        }
                    }
                    ++n;
                }
                if (n5 > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer(n - n4 - n5);
                    while (n4 < n) {
                        if (string.charAt(n4) == '\\') {
                            if (string.charAt(++n4) == 'n') {
                                stringBuffer2.append('\n');
                            } else if (string.charAt(n4) == 'u') {
                                int n6 = 0;
                                for (int i = 0; i < 4 && ++n4 != n; ++i) {
                                    int n7 = Character.digit(string.charAt(n4), 16);
                                    if (n7 < 0) continue;
                                    n6 = n6 * 16 + n7;
                                }
                                stringBuffer2.append((char)n6);
                            } else {
                                stringBuffer2.append(string.charAt(n4));
                            }
                        } else {
                            stringBuffer2.append(string.charAt(n4));
                        }
                        ++n4;
                    }
                    arrayList.add(stringBuffer2.toString());
                } else {
                    arrayList.add(string.substring(n4, n));
                }
                if (n < n3) {
                    ++n;
                }
            } else {
                n4 = n;
                while (n < n3 && string.charAt(n) > ' ') {
                    ++n;
                }
                arrayList.add(string.substring(n4, n));
            }
            ++n2;
        }
        return n2;
    }

    public static int ReadInt(Object object) {
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static Dimension RowsColumns(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = string.indexOf(10, n3);
            if (n4 == -1) {
                n2 = Math.max(n2, string.length() - n3);
                break;
            }
            n2 = Math.max(n2, n4 - n3);
            ++n;
            n3 = n4 + 1;
        }
        return new Dimension(n2, n + 1);
    }

    public static String EngineeringNotation(double d, int n) {
        if (d == 0.0) {
            return "0";
        }
        double d2 = d < 0.0 ? -1.0 : 1.0;
        double d3 = Math.log(d2 * d) / Math.log(10.0);
        double d4 = Math.floor(d3 / 3.0);
        double d5 = d2 * Math.pow(10.0, d3 - 3.0 * d4);
        String string = Double.toString(d5 + 0.5 * Math.pow(10.0, -n));
        int n2 = string.length();
        int n3 = string.indexOf(46);
        if (n3 != -1) {
            if (n > 0) {
                if ((n3 += n + 1) > n2) {
                    n3 = n2;
                }
                while (string.charAt(n3 - 1) == '0') {
                    --n3;
                }
                if (string.charAt(n3 - 1) == '.') {
                    --n3;
                }
            }
            if (n3 < n2) {
                string = string.substring(0, n3);
            }
        }
        switch ((int)d4) {
            case -5: {
                return string + "f";
            }
            case -4: {
                return string + "p";
            }
            case -3: {
                return string + "n";
            }
            case -2: {
                return string + "u";
            }
            case -1: {
                return string + "m";
            }
            case 0: {
                return string;
            }
            case 1: {
                return string + "K";
            }
            case 2: {
                return string + "Meg";
            }
            case 3: {
                return string + "G";
            }
        }
        return Double.toString(d);
    }

    public static Color ParseColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static int ParseInteger(String var0) {
        block13: {
            var1_1 = var0.length();
            var3_3 = 1;
            var4_4 = 0;
            var5_5 = 10;
            for (var2_2 = 0; var2_2 < var1_1 && var0.charAt(var2_2) <= ' '; ++var2_2) {
            }
            if (var2_2 < var1_1) {
                var6_6 = var0.charAt(var2_2);
                if (var6_6 == 43) {
                    ++var2_2;
                } else if (var6_6 == 45) {
                    var3_3 = -1;
                    ++var2_2;
                }
            }
            if (var2_2 >= var1_1 || (var6_6 = var0.charAt(var2_2)) != 48) break block13;
            if (++var2_2 >= var1_1) ** GOTO lbl-1000
            v0 = var0.charAt(var2_2);
            var6_6 = v0;
            if (v0 == 'x' || var6_6 == 88) {
                ++var2_2;
                var5_5 = 16;
            } else lbl-1000:
            // 2 sources

            {
                var5_5 = 8;
            }
        }
        while (var2_2 < var1_1) {
            if ((var6_6 = var0.charAt(var2_2++)) >= 48 && var6_6 < 57) {
                if ((var6_6 -= 48) >= var5_5) {
                    break;
                }
            } else if (var6_6 >= 65 && var6_6 <= 70) {
                if (var5_5 != 16) break;
                var6_6 -= 75;
            } else {
                if (var6_6 < 97 || var6_6 > 102 || var5_5 != 16) break;
                var6_6 -= 107;
            }
            var4_4 = var5_5 * var4_4 + var6_6;
        }
        return var3_3 * var4_4;
    }

    public static double ParseEngineeringNotation(String string) {
        char c;
        int n;
        int n2 = string.length();
        double d = 1.0;
        double d2 = 0.0;
        for (n = 0; n < n2 && string.charAt(n) <= ' '; ++n) {
        }
        int n3 = n;
        if (n < n2) {
            c = string.charAt(n);
            if (c == '+') {
                ++n;
            } else if (c == '-') {
                d = -1.0;
                ++n;
            }
        }
        while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
            d2 = 10.0 * d2 + (double)(c - 48);
            ++n;
        }
        if (n < n2 && string.charAt(n) == '.') {
            ++n;
            while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
                d2 = 10.0 * d2 + (double)(c - 48);
                d /= 10.0;
                ++n;
            }
        }
        if (n == n3) {
            return Double.NaN;
        }
        d2 *= d;
        if (n < n2) {
            switch (Character.toLowerCase(string.charAt(n))) {
                case 'e': {
                    int n4 = 0;
                    boolean bl = false;
                    if (++n < n2) {
                        c = string.charAt(n);
                        if (c == '+') {
                            ++n;
                        } else if (c == '-') {
                            bl = true;
                            ++n;
                        }
                    }
                    while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
                        n4 = 10 * n4 + (c - 48);
                        ++n;
                    }
                    while (n4-- > 0) {
                        d2 *= bl ? 0.1 : 10.0;
                    }
                    break;
                }
                case 't': {
                    d2 *= 1.0E12;
                    break;
                }
                case 'g': {
                    d2 *= 1.0E9;
                    break;
                }
                case 'k': {
                    d2 *= 1000.0;
                    break;
                }
                case 'u': {
                    d2 *= 1.0E-6;
                    break;
                }
                case 'n': {
                    d2 *= 1.0E-9;
                    break;
                }
                case 'p': {
                    d2 *= 1.0E-12;
                    break;
                }
                case 'f': {
                    d2 *= 1.0E-15;
                    break;
                }
                case 'm': {
                    if (n + 2 < n2) {
                        if (Character.toLowerCase(string.charAt(n + 1)) == 'e' && Character.toLowerCase(string.charAt(n + 2)) == 'g') {
                            d2 *= 1000000.0;
                            break;
                        }
                        if (Character.toLowerCase(string.charAt(n + 1)) == 'i' && Character.toLowerCase(string.charAt(n + 2)) == 'l') {
                            d2 *= 2.54E-5;
                            break;
                        }
                    }
                    d2 *= 0.001;
                }
            }
        }
        return d2;
    }

    public static void PrintNumber(PrintWriter printWriter, int n) {
        printWriter.print(' ');
        printWriter.print(n);
    }

    public static void Print(PrintWriter printWriter, String string) {
        char c;
        int n;
        int n2 = string.length();
        boolean bl = n2 == 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c > ' ' && c <= '~') continue;
            bl = true;
            break;
        }
        if (bl) {
            printWriter.print('\"');
            for (n = 0; n < n2; ++n) {
                c = string.charAt(n);
                if (c == '\"' || c == '\\') {
                    printWriter.print('\\');
                    printWriter.print(c);
                    continue;
                }
                if (c >= ' ' && c <= '~') {
                    printWriter.print(c);
                    continue;
                }
                if (c == '\n') {
                    printWriter.print("\\n");
                    continue;
                }
                printWriter.print("\\u");
                String string2 = Integer.toHexString(c);
                int n3 = string2.length();
                for (int i = 4; i > 0; --i) {
                    if (n3 - i < 0) {
                        printWriter.print('0');
                        continue;
                    }
                    printWriter.print(string2.charAt(n3 - i));
                }
            }
            printWriter.print('\"');
        } else {
            printWriter.print(string);
        }
    }

    private static void ExpandIterators(ArrayList arrayList, String string, String string2) {
        if (string2 == null) {
            if (string != null && string.length() > 0) {
                arrayList.add(string);
            }
            return;
        }
        int n = string2.indexOf(91);
        int n2 = string2.indexOf(93);
        if (n == -1 || n2 - 1 <= n) {
            arrayList.add(string + string2);
            return;
        }
        if (n > 0) {
            string = string + string2.substring(0, n);
        }
        String string3 = n2 + 1 >= string2.length() ? null : string2.substring(n2 + 1);
        int n3 = string2.indexOf(58, n);
        if (n3 == -1 || n3 >= n2 - 1) {
            string = string + string2.substring(n + 1, n2);
            UI.ExpandIterators(arrayList, string, string3);
            return;
        }
        int n4 = string2.indexOf(58, n3 + 1);
        if (n4 == -1 || n4 >= n2 - 1) {
            n4 = n2;
        }
        try {
            int n5 = Integer.parseInt(string2.substring(n + 1, n3));
            int n6 = Integer.parseInt(string2.substring(n3 + 1, n4));
            int n7 = 1;
            if (n4 != n2) {
                n7 = Integer.parseInt(string2.substring(n4 + 1, n2));
            }
            int n8 = n5;
            do {
                String string4 = string + Integer.toString(n8);
                if (string3 == null) {
                    arrayList.add(string4);
                    continue;
                }
                UI.ExpandIterators(arrayList, string4, string3);
            } while (n8 != n6 && !(n8 > n6 ? (n8 -= n7) < n6 : (n8 += n7) > n6));
        }
        catch (NumberFormatException numberFormatException) {
            UI.ExpandIterators(arrayList, string + string2.substring(n, n2 + 1), string3);
        }
    }

    public static ArrayList ExpandNodeName(String string) {
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            int n3;
            int n4 = string.indexOf(44, n2);
            if (n4 == -1) {
                n4 = n;
            }
            if ((n3 = (string2 = n2 > 0 || n4 < n ? string.substring(n2, n4) : string).indexOf(35)) == -1) {
                UI.ExpandIterators(arrayList, "", string2);
            } else {
                try {
                    int n5 = Integer.parseInt(string2.substring(n3 + 1, n4));
                    if (n5 > 0) {
                        UI.ExpandIterators(arrayList, "", string2.substring(0, n3));
                        int n6 = arrayList.size();
                        while (n5-- > 1) {
                            for (int i = 0; i < n6; ++i) {
                                arrayList.add(arrayList.get(i));
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    UI.ExpandIterators(arrayList, "", string2);
                }
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    public static String CanonicalFileName(URL uRL) {
        String string = uRL.getFile();
        if (uRL.getProtocol().equals("file")) {
            string = string.replace(File.separatorChar, '/');
            string = string.replace('\\', '/');
        }
        if (string.length() >= 4 && string.charAt(0) == '/' && string.charAt(1) == '/' && string.charAt(3) == ':') {
            string = string.substring(2);
        }
        int n = 0;
        while ((n = string.indexOf(46, n) + 1) != 0 && n + 1 < string.length()) {
            int n2;
            if (n < 3 || string.charAt(n) != '.' || string.charAt(n + 1) != '/' || string.charAt(n - 2) != '/' || (n2 = string.lastIndexOf(47, n - 3)) == -1) continue;
            string = string.substring(0, n2) + string.substring(n + 1);
            n = n2;
        }
        return string;
    }
}

