/*
 * Decompiled with CFR 0.152.
 */
package gui;

import bsim.Beta;
import bsim.Memory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VramPanel
extends JPanel
implements MouseListener,
ActionListener {
    public static final int CANVAS_WIDTH = 256;
    public static final int CANVAS_HEIGHT = 128;
    public static final String TITLE = ".V.R.A.M.";
    Memory ram;
    public static final int VRAM_OFFSET = 0;
    boolean autorefresh = false;

    public void Link(Beta beta) {
        this.ram = beta.memory;
        System.err.println("vram " + this + " linked to M" + beta.memory.uid);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        System.err.println("CLICK" + this.autorefresh);
        this.repaint();
        this.autorefresh = !this.autorefresh;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        System.err.println("ENTER");
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        System.err.println("LEAVE");
    }

    public VramPanel() {
        this.setPreferredSize(new Dimension(256, 128));
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.ram == null) {
            System.err.println("no ram linked to " + this);
            this.setBackground(Color.BLUE);
            return;
        }
        this.setBackground(Color.WHITE);
        graphics.setColor(Color.BLACK);
        int[] nArray = new int[8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4096) {
            int n4 = this.ram.ReadLine(nArray, n3);
            for (int i = 0; i < 8; ++i) {
                for (int j = 1; j != 0; j <<= 1) {
                    if ((nArray[i] & j) != 0) {
                        graphics.drawLine(n, n2, n, n2);
                    }
                    ++n;
                }
            }
            n = 0;
            ++n2;
            n3 = n4;
        }
        this.ram.anyDirty = false;
    }

    public JFrame frameit() {
        JFrame jFrame = new JFrame(TITLE);
        jFrame.setContentPane(this);
        jFrame.setDefaultCloseOperation(0);
        jFrame.pack();
        jFrame.setVisible(false);
        return jFrame;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame(VramPanel.TITLE);
                jFrame.setContentPane(new VramPanel());
                jFrame.setDefaultCloseOperation(3);
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        });
    }
}

