/*
 * Decompiled with CFR 0.152.
 */
package bsim;

import bsim.Memory;
import gui.GuiFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Beta
extends JPanel
implements ActionListener,
Runnable,
KeyListener,
MouseListener,
AdjustmentListener {
    public static final int MSIZE = 4096;
    public static final String zeros = "00000000";
    public static final int N = 1;
    public static final int NNE = 2;
    public static final int NE = 3;
    public static final int ENE = 4;
    public static final int E = 5;
    public static final int ESE = 6;
    public static final int SE = 7;
    public static final int SSE = 8;
    public static final int S = 9;
    public static final int SSW = 10;
    public static final int SW = 11;
    public static final int WSW = 12;
    public static final int W = 13;
    public static final int WNW = 14;
    public static final int NW = 15;
    public static final int NNW = 16;
    public static final int ILLOP = 4;
    public static final int INTERRUPT = 8;
    public static final int CLOCK_INTERRUPT = 1;
    public static final int KBD_INTERRUPT = 2;
    public static final int MOUSE_INTERRUPT = 4;
    public static final int CYCLES_PER_TICK = 10000;
    public static final Color HIDE = new Color(170, 170, 170);
    public static final Color SHOW = Color.black;
    public static final int DATAPATH = 0;
    public static final int PROGRAMMERS_PANEL = 1;
    public static final int NLOCS = 26;
    public Thread simulation;
    Runnable UpdateDisplay;
    GuiFrame message;
    int display;
    JTextArea usertty;
    int mouseCoords;
    JScrollPane userscroll;
    StringBuffer ttyInput;
    JScrollBar maddrScroll;
    JScrollBar iaddrScroll;
    public Memory memory;
    public int[] initialContents;
    public String[] instructions;
    public boolean[] breakpoints;
    public boolean[] writeable;
    public String[] labels;
    public long cycles;
    public int interrupts;
    public Random random;
    public ArrayList serverInfo;
    public boolean mul;
    public boolean div;
    public boolean clock;
    public boolean tty;
    public boolean kalways;
    public boolean annotate;
    public boolean trace;
    public int[] regs;
    public int pc;
    public int pcmsb;
    public int wdata;
    public int inst;
    public int ra;
    public int rb;
    public int rc;
    public int rd1;
    public int rd2;
    public int literal;
    public boolean werf;
    public int ma;
    public int mdata;
    public boolean wr;
    public int npc;
    public int npcmsb;
    public boolean irq;
    public int iaddr;
    public int maddr;
    public int pcsel;
    public int ra2sel;
    public int asel;
    public int bsel;
    public int wasel;
    public int z;
    public boolean needZ;
    public String alufn;
    public int wdsel;
    public int pcinc;
    public int offset;
    public int pcoffset;
    public int alua;
    public int alub;
    public int alu;
    public int mrd;
    Font tFont;
    int tH;
    int tW;
    int gridx;
    int gridy;
    int hx;
    int hy;
    int baseline;

    public Beta(GuiFrame guiFrame, GuiFrame guiFrame2) {
        this.message = guiFrame2;
        this.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.usertty = new JTextArea(5, 10);
        this.usertty.setEditable(false);
        this.usertty.setHighlighter(null);
        this.usertty.setBackground(Color.white);
        this.usertty.setFont(new Font("monospaced", 0, 12));
        this.usertty.addKeyListener(this);
        this.usertty.addMouseListener(this);
        this.userscroll = new JScrollPane(this.usertty, 20, 30);
        this.userscroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.maddrScroll = new JScrollBar(1, 0, 7, 0, 1024);
        this.maddrScroll.addAdjustmentListener(this);
        this.add((Component)this.maddrScroll, "East");
        this.iaddrScroll = new JScrollBar(1, 0, 3, 0, 1024);
        this.iaddrScroll.addAdjustmentListener(this);
        this.add((Component)this.iaddrScroll, "West");
        this.ttyInput = new StringBuffer();
        this.random = new Random();
        this.serverInfo = new ArrayList();
        this.display = 1;
        this.tFont = null;
        this.tW = -1;
        this.tH = -1;
        this.memory = new Memory(this);
        this.memory.setIconImage(guiFrame.GetImageResource("/icons/bsim.gif"));
        this.memory.AddToolButton(guiFrame.ImageButton("/icons/bstop.gif"), "Stop", this);
        this.memory.AddToolButton(guiFrame.ImageButton("/icons/breset.gif"), "Reset", this);
        this.memory.AddToolButton(guiFrame.ImageButton("/icons/brun.gif"), "Run", this);
        this.memory.AddToolButton(guiFrame.ImageButton("/icons/bstep.gif"), "Single Step", this);
        this.regs = new int[32];
        this.simulation = null;
        this.UpdateDisplay = new Runnable(){

            @Override
            public void run() {
                Beta.this.Update();
            }
        };
        this.SetMemorySize(65536);
        this.Reset();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.SetupScrollbars();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (this.maddrScroll == adjustmentEvent.getSource()) {
            this.maddr = n << 2;
        } else if (this.iaddrScroll == adjustmentEvent.getSource()) {
            this.iaddr = n << 2;
        }
        this.repaint();
    }

    public void SetMemorySize(int n) {
        this.initialContents = null;
        n = this.memory.SetMemorySize(n);
        this.instructions = new String[n];
        this.breakpoints = new boolean[n];
        this.writeable = new boolean[n];
        this.labels = new String[n];
        this.maddrScroll.setMaximum(n + this.maddrScroll.getVisibleAmount() - 4);
        this.iaddrScroll.setMaximum(n + this.iaddrScroll.getVisibleAmount() - 2);
        this.Reset();
    }

    public void Update() {
        this.repaint();
        this.memory.Repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.tty) {
            Beta beta = this;
            synchronized (beta) {
                this.ttyInput.append(c);
                this.interrupts |= 2;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.tty) {
            Point point = this.userscroll.getViewport().getViewPosition();
            this.mouseCoords = (mouseEvent.getX() - point.x << 16) + (mouseEvent.getY() - point.y & 0xFFFF);
            this.interrupts |= 4;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void AssemblyStart() {
        this.memory.Reset(null);
        this.mul = true;
        this.div = true;
        this.clock = false;
        this.tty = false;
        this.kalways = false;
        this.annotate = false;
        this.trace = false;
        int n = this.memory.Size();
        for (int i = 0; i < n; ++i) {
            this.breakpoints[i] = false;
            this.writeable[i] = true;
        }
    }

    public void AssemblyFinish() {
        this.initialContents = this.memory.Copy();
        this.Reset();
    }

    public void Option(String string) {
        if (string.equals("mul")) {
            this.mul = true;
        } else if (string.equals("nomul")) {
            this.mul = false;
        } else if (string.equals("div")) {
            this.div = true;
        } else if (string.equals("nodiv")) {
            this.div = false;
        } else if (string.equals("clock")) {
            this.clock = true;
        } else if (string.equals("noclock")) {
            this.clock = false;
        } else if (string.equals("kalways")) {
            this.kalways = true;
        } else if (string.equals("nokalways")) {
            this.kalways = false;
        } else if (string.equals("annotate")) {
            this.annotate = true;
        } else if (string.equals("noannotate")) {
            this.annotate = false;
        } else if (string.equals("trace")) {
            this.trace = true;
        } else if (string.equals("notrace")) {
            this.trace = false;
        } else if (string.equals("tty")) {
            this.tty = true;
            this.add((Component)this.userscroll, "South");
            this.invalidate();
        } else if (string.equals("notty")) {
            this.tty = false;
            this.remove(this.userscroll);
            this.invalidate();
        } else {
            System.out.println("unrecognized option = " + string);
        }
    }

    public int ttyChecksum() {
        return this.usertty.getText().hashCode() + 36038;
    }

    public void WriteMemory(int n, int n2, boolean bl) {
        int n3 = this.memory.WriteWord(n, n2);
        if (n3 >= 0) {
            this.instructions[n3] = null;
            this.writeable[n3] = bl;
        }
    }

    public void WriteMemoryByte(int n, int n2, boolean bl) {
        int n3 = this.memory.WriteByte(n, n2);
        if (n3 >= 0) {
            this.instructions[n3] = null;
            this.writeable[n3] = bl;
        }
    }

    public int ReadMemory(int n) {
        return this.memory.ReadWord(n);
    }

    public int ReadMemoryByte(int n) {
        return this.memory.ReadByte(n);
    }

    public int ReadRegister(int n) {
        return this.regs[n];
    }

    public void SetBreakpoint(int n) {
        this.breakpoints[n >> 2] = true;
    }

    public void DefineLabel(int n, String string) {
        int n2 = n >> 2;
        if (this.labels[n2] == null) {
            this.labels[n2] = string;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Single Step")) {
            this.SingleStep();
            this.memory.inspector.repaint();
        } else if (string.equals("Run")) {
            this.Run();
            this.memory.inspector.repaint();
        } else if (string.equals("Stop")) {
            this.Stop();
            this.memory.inspector.repaint();
        } else if (string.equals("Reset")) {
            this.Reset();
        } else if (string.equals("Cache control")) {
            this.memory.setVisible(true);
        } else if (string.equals("Toggle state display")) {
            this.display = this.display == 0 ? 1 : 0;
            this.tFont = null;
        }
        this.Update();
    }

    public void Reset() {
        if (this.simulation == null) {
            this.cycles = 0L;
            this.interrupts = 0;
            for (int i = 0; i < 32; ++i) {
                this.regs[i] = 0;
            }
            this.memory.Reset(this.initialContents);
            this.ttyInput.setLength(0);
            this.mouseCoords = -1;
            this.usertty.setText("");
            this.message.Message("");
            this.serverInfo.clear();
            this.npc = 0;
            this.npcmsb = 1;
            this.werf = false;
            this.wr = false;
            this.ma = 0;
            this.maddr = 0;
            this.maddrScroll.setValue(this.maddr);
            this.iaddr = 0;
            this.iaddrScroll.setValue(this.iaddr);
            this.SingleStep();
        }
    }

    public void SingleStep() {
        if (this.simulation == null) {
            if (this.tty) {
                this.requestFocus();
            }
            this.message.Message("");
            this.memory.Message("");
            this.Execute();
        }
    }

    public void StopReset() {
        this.Stop();
        while (this.simulation != null) {
            Thread.yield();
        }
        this.Reset();
    }

    public synchronized void Stop() {
        if (this.simulation != null) {
            this.simulation.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        this.maddrScroll.setVisible(false);
        this.iaddrScroll.setVisible(false);
        while (!Thread.interrupted() && !this.Execute()) {
            int n = this.pc >> 2;
            if (!this.memory.ValidAddress(this.pc) || !this.breakpoints[this.pc >> 2]) continue;
            this.message.Message("Stopped at breakpoint");
            this.memory.inspector.repaint();
            break;
        }
        this.maddrScroll.setVisible(true);
        this.iaddrScroll.setVisible(true);
        Beta beta = this;
        synchronized (beta) {
            this.simulation = null;
            SwingUtilities.invokeLater(this.UpdateDisplay);
        }
    }

    public void Run() {
        if (this.simulation == null) {
            if (this.tty) {
                this.requestFocus();
            }
            this.message.Message("");
            this.memory.Message("");
            this.simulation = new Thread((Runnable)this, "simulation");
            this.simulation.start();
        }
    }

    private void Trap(int n) {
        this.rc = 30;
        this.wdata = this.pcmsb << 31 | this.npc;
        this.npc = n;
        this.npcmsb = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean Execute() {
        ++this.cycles;
        if (this.clock && this.cycles % 10000L == 9999L) {
            this.interrupts |= 1;
        }
        this.pc = this.npc;
        this.pcmsb = this.npcmsb;
        if (this.werf) {
            this.regs[this.rc] = this.wdata;
        }
        this.regs[31] = 0;
        if (this.wr) {
            int n = this.memory.CachedWriteWord(this.ma, this.mdata);
            this.maddr = this.ma;
            if (n >= 0) {
                this.instructions[n] = null;
            }
        }
        this.iaddr = this.pc;
        this.inst = this.memory.CachedReadWord(this.pc);
        this.rc = this.inst >> 21 & 0x1F;
        this.werf = true;
        this.wr = false;
        this.ra = this.inst >> 16 & 0x1F;
        this.rb = this.inst >> 11 & 0x1F;
        this.rd1 = this.regs[this.ra];
        this.rd2 = this.regs[this.rb];
        this.literal = this.inst << 16 >> 16;
        this.irq = false;
        this.npc = this.pc + 4 & Integer.MAX_VALUE;
        if (this.pcmsb == 0 && this.interrupts != 0) {
            Beta beta = this;
            synchronized (beta) {
                int n = 8;
                int n2 = 1;
                while (n2 != 0) {
                    if ((this.interrupts & n2) != 0) {
                        this.irq = true;
                        this.Trap(n);
                        this.interrupts &= ~n2;
                        break;
                    }
                    n2 <<= 1;
                    n += 4;
                }
            }
        }
        switch (this.inst >> 26 & 0x3F) {
            case 0: {
                if (this.pcmsb == 1) {
                    switch (this.inst & 0xFFFF) {
                        case 0: {
                            this.rc = 31;
                            this.npc = this.pc;
                            this.wdata = this.pcmsb << 31 | this.npc;
                            this.werf = false;
                            return true;
                        }
                        case 1: {
                            if (this.tty) {
                                if (this.ttyInput.length() > 0) {
                                    this.rc = 0;
                                    this.wdata = this.ttyInput.charAt(0);
                                    this.ttyInput.deleteCharAt(0);
                                    if (this.ttyInput.length() <= 0) break;
                                    this.interrupts |= 2;
                                    break;
                                }
                                this.npc = this.pc;
                                break;
                            }
                            this.Trap(4);
                            break;
                        }
                        case 2: {
                            if (this.tty) {
                                this.usertty.append(String.valueOf((char)this.regs[0]));
                                try {
                                    this.usertty.setCaretPosition(this.usertty.getText().length() - 1);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Thread.yield();
                                break;
                            }
                            this.Trap(4);
                            break;
                        }
                        case 3: {
                            this.rc = 0;
                            this.wdata = (int)this.cycles;
                            break;
                        }
                        case 4: {
                            this.rc = 0;
                            this.wdata = (int)System.currentTimeMillis();
                            break;
                        }
                        case 5: {
                            if (this.tty) {
                                this.rc = 0;
                                this.wdata = this.mouseCoords;
                                this.mouseCoords = -1;
                                break;
                            }
                            this.Trap(4);
                            break;
                        }
                        case 6: {
                            this.rc = 0;
                            this.wdata = this.random.nextInt();
                            break;
                        }
                        case 7: {
                            this.random.setSeed(this.regs[0]);
                            break;
                        }
                        case 8: {
                            this.serverInfo.add(new Integer(this.regs[0]));
                            break;
                        }
                        default: {
                            this.Trap(4);
                            break;
                        }
                    }
                    break;
                }
                this.Trap(4);
                break;
            }
            default: {
                this.Trap(4);
                break;
            }
            case 24: {
                this.ma = this.rd1 + this.literal & Integer.MAX_VALUE;
                if (!this.memory.ValidAddress(this.ma)) {
                    this.wdata = 0;
                    this.message.Message("LD from invalid memory location");
                    return true;
                }
                this.wdata = this.memory.CachedReadWord(this.ma);
                break;
            }
            case 25: {
                this.mdata = this.regs[this.rc];
                this.ma = this.rd1 + this.literal & Integer.MAX_VALUE;
                this.wr = true;
                this.werf = false;
                if (!this.memory.ValidAddress(this.ma)) {
                    this.wr = false;
                    this.message.Message("ST to invalid memory location");
                    return true;
                }
                if (this.writeable[this.memory.Index(this.ma)]) break;
                this.wr = false;
                this.message.Message("ST to read-only memory location");
                return true;
            }
            case 27: {
                this.wdata = this.pcmsb << 31 | this.npc;
                this.npc = this.rd1 & 0x7FFFFFFC;
                if (this.kalways || (this.rd1 & Integer.MIN_VALUE) != 0) break;
                this.npcmsb = 0;
                break;
            }
            case 29: {
                this.wdata = this.pcmsb << 31 | this.npc;
                if (this.rd1 != 0) break;
                this.npc = this.npc + 4 * this.literal & 0x7FFFFFFC;
                break;
            }
            case 30: {
                this.wdata = this.pcmsb << 31 | this.npc;
                if (this.rd1 == 0) break;
                this.npc = this.npc + 4 * this.literal & 0x7FFFFFFC;
                break;
            }
            case 31: {
                this.ma = this.npc + 4 * this.literal & Integer.MAX_VALUE;
                this.wdata = this.memory.CachedReadWord(this.ma);
                break;
            }
            case 32: {
                this.wdata = this.rd1 + this.rd2;
                break;
            }
            case 33: {
                this.wdata = this.rd1 - this.rd2;
                break;
            }
            case 34: {
                if (this.mul) {
                    this.wdata = this.rd1 * this.rd2;
                    break;
                }
                this.Trap(4);
                break;
            }
            case 35: {
                if (this.div) {
                    this.wdata = this.rd1 / this.rd2;
                    break;
                }
                this.Trap(4);
                break;
            }
            case 36: {
                this.wdata = this.rd1 == this.rd2 ? 1 : 0;
                break;
            }
            case 37: {
                this.wdata = this.rd1 < this.rd2 ? 1 : 0;
                break;
            }
            case 38: {
                this.wdata = this.rd1 <= this.rd2 ? 1 : 0;
                break;
            }
            case 40: {
                this.wdata = this.rd1 & this.rd2;
                break;
            }
            case 41: {
                this.wdata = this.rd1 | this.rd2;
                break;
            }
            case 42: {
                this.wdata = this.rd1 ^ this.rd2;
                break;
            }
            case 44: {
                this.wdata = this.rd1 << this.rd2;
                break;
            }
            case 45: {
                this.wdata = this.rd1 >>> this.rd2;
                break;
            }
            case 46: {
                this.wdata = this.rd1 >> this.rd2;
                break;
            }
            case 48: {
                this.wdata = this.rd1 + this.literal;
                break;
            }
            case 49: {
                this.wdata = this.rd1 - this.literal;
                break;
            }
            case 50: {
                if (this.mul) {
                    this.wdata = this.rd1 * this.literal;
                    break;
                }
                this.Trap(4);
                break;
            }
            case 51: {
                if (this.div) {
                    this.wdata = this.rd1 / this.literal;
                    break;
                }
                this.Trap(4);
                break;
            }
            case 52: {
                this.wdata = this.rd1 == this.literal ? 1 : 0;
                break;
            }
            case 53: {
                this.wdata = this.rd1 < this.literal ? 1 : 0;
                break;
            }
            case 54: {
                this.wdata = this.rd1 <= this.literal ? 1 : 0;
                break;
            }
            case 56: {
                this.wdata = this.rd1 & this.literal;
                break;
            }
            case 57: {
                this.wdata = this.rd1 | this.literal;
                break;
            }
            case 58: {
                this.wdata = this.rd1 ^ this.literal;
                break;
            }
            case 60: {
                this.wdata = this.rd1 << this.literal;
                break;
            }
            case 61: {
                this.wdata = this.rd1 >>> this.literal;
                break;
            }
            case 62: {
                this.wdata = this.rd1 >> this.literal;
            }
        }
        return false;
    }

    private String Reg(int n) {
        if (n == 30) {
            return "XP";
        }
        if (n == 29) {
            return "SP";
        }
        if (n == 28) {
            return "LP";
        }
        if (n == 27) {
            return "BP";
        }
        return "R" + n;
    }

    private String Betaop(String string, int n, int n2, int n3) {
        return string + "(" + this.Reg(n) + "," + this.Reg(n2) + "," + this.Reg(n3) + ")";
    }

    private String Betaopc(String string, int n, int n2, int n3) {
        return string + "(" + this.Reg(n) + "," + n2 + "," + this.Reg(n3) + ")";
    }

    private String Offset(int n, int n2) {
        if ((n += 4 + 4 * n2) >= 0 && n >> 2 < this.labels.length && this.labels[n >> 2] != null) {
            return this.labels[n >> 2];
        }
        return "0x" + Integer.toHexString(n).toUpperCase();
    }

    private String Disassemble(int n) {
        int n2 = this.memory.Index(n);
        String string = this.instructions[n2];
        if (string == null) {
            if (this.labels[n2] != null) {
                string = this.labels[n2] + ": ";
                while (string.length() < 8) {
                    string = string + " ";
                }
            }
            string = "        ";
            int n3 = this.memory.ReadWord(n);
            int n4 = n3 >> 21 & 0x1F;
            int n5 = n3 >> 16 & 0x1F;
            int n6 = n3 >> 11 & 0x1F;
            int n7 = n3 << 16 >> 16;
            block0 : switch (n3 >> 26 & 0x3F) {
                case 0: {
                    switch (n3 & 0xFFFF) {
                        case 0: {
                            string = string + "HALT()";
                            break block0;
                        }
                        case 1: {
                            if (this.tty) {
                                string = string + "RDCHAR()";
                                break block0;
                            }
                            string = string + "illop";
                            break block0;
                        }
                        case 2: {
                            if (this.tty) {
                                string = string + "WRCHAR()";
                                break block0;
                            }
                            string = string + "illop";
                            break block0;
                        }
                        case 3: {
                            string = string + "CYCLE()";
                            break block0;
                        }
                        case 4: {
                            string = string + "TIME()";
                            break block0;
                        }
                        case 5: {
                            if (this.tty) {
                                string = string + "CLICK()";
                                break block0;
                            }
                            string = string + "illop";
                            break block0;
                        }
                        case 6: {
                            string = string + "RANDOM()";
                            break block0;
                        }
                        case 7: {
                            string = string + "SEED()";
                            break block0;
                        }
                        case 8: {
                            string = string + "SERVER()";
                            break block0;
                        }
                    }
                    string = string + "illop";
                    break;
                }
                default: {
                    string = string + "illop";
                    break;
                }
                case 24: {
                    string = string + this.Betaopc("LD", n5, n7, n4);
                    break;
                }
                case 25: {
                    string = string + this.Betaopc("ST", n4, n7, n5);
                    break;
                }
                case 27: {
                    if (n4 == 31) {
                        string = string + "JMP(" + this.Reg(n5) + ")";
                        break;
                    }
                    string = string + "JMP(" + this.Reg(n5) + "," + this.Reg(n4) + ")";
                    break;
                }
                case 29: {
                    if (n5 == 31) {
                        if (n4 == 31) {
                            string = string + "BR(" + this.Offset(n, n7) + ")";
                            break;
                        }
                        string = string + "BR(" + this.Offset(n, n7) + "," + this.Reg(n4) + ")";
                        break;
                    }
                    if (n4 == 31) {
                        string = string + "BEQ(" + this.Reg(n5) + "," + this.Offset(n, n7) + ")";
                        break;
                    }
                    string = string + "BEQ(" + this.Reg(n5) + "," + this.Offset(n, n7) + "," + this.Reg(n4) + ")";
                    break;
                }
                case 30: {
                    if (n4 == 31) {
                        string = string + "BNE(" + this.Reg(n5) + "," + this.Offset(n, n7) + ")";
                        break;
                    }
                    string = string + "BNE(" + this.Reg(n5) + "," + this.Offset(n, n7) + "," + this.Reg(n4) + ")";
                    break;
                }
                case 31: {
                    string = string + "LDR(" + this.Offset(n, n7) + "," + this.Reg(n4) + ")";
                    break;
                }
                case 32: {
                    string = string + this.Betaop("ADD", n5, n6, n4);
                    break;
                }
                case 33: {
                    string = string + this.Betaop("SUB", n5, n6, n4);
                    break;
                }
                case 34: {
                    string = string + this.Betaop("MUL", n5, n6, n4);
                    break;
                }
                case 35: {
                    string = string + this.Betaop("DIV", n5, n6, n4);
                    break;
                }
                case 36: {
                    string = string + this.Betaop("CMPEQ", n5, n6, n4);
                    break;
                }
                case 37: {
                    string = string + this.Betaop("CMPLT", n5, n6, n4);
                    break;
                }
                case 38: {
                    string = string + this.Betaop("CMPLE", n5, n6, n4);
                    break;
                }
                case 40: {
                    string = string + this.Betaop("AND", n5, n6, n4);
                    break;
                }
                case 41: {
                    string = string + this.Betaop("OR", n5, n6, n4);
                    break;
                }
                case 42: {
                    string = string + this.Betaop("XOR", n5, n6, n4);
                    break;
                }
                case 44: {
                    string = string + this.Betaop("SHL", n5, n6, n4);
                    break;
                }
                case 45: {
                    string = string + this.Betaop("SHR", n5, n6, n4);
                    break;
                }
                case 46: {
                    string = string + this.Betaop("SRA", n5, n6, n4);
                    break;
                }
                case 48: {
                    string = string + this.Betaopc("ADDC", n5, n7, n4);
                    break;
                }
                case 49: {
                    string = string + this.Betaopc("SUBC", n5, n7, n4);
                    break;
                }
                case 50: {
                    string = string + this.Betaopc("MULC", n5, n7, n4);
                    break;
                }
                case 51: {
                    string = string + this.Betaopc("DIVC", n5, n7, n4);
                    break;
                }
                case 52: {
                    string = string + this.Betaopc("CMPEQC", n5, n7, n4);
                    break;
                }
                case 53: {
                    string = string + this.Betaopc("CMPLTC", n5, n7, n4);
                    break;
                }
                case 54: {
                    string = string + this.Betaopc("CMPLEC", n5, n7, n4);
                    break;
                }
                case 56: {
                    string = string + this.Betaopc("ANDC", n5, n7, n4);
                    break;
                }
                case 57: {
                    string = string + this.Betaopc("ORC", n5, n7, n4);
                    break;
                }
                case 58: {
                    string = string + this.Betaopc("XORC", n5, n7, n4);
                    break;
                }
                case 60: {
                    string = string + this.Betaopc("SHLC", n5, n7, n4);
                    break;
                }
                case 61: {
                    string = string + this.Betaopc("SHRC", n5, n7, n4);
                    break;
                }
                case 62: {
                    string = string + this.Betaopc("SRAC", n5, n7, n4);
                }
            }
            this.instructions[n2] = string;
        }
        return string;
    }

    private void Signals() {
        int n = this.inst >> 26 & 0x3F;
        this.pcsel = 0;
        this.asel = n == 31 ? 1 : 0;
        this.bsel = (n & 0x30) == 48 || n == 24 || n == 25 ? 1 : 0;
        this.ra2sel = this.bsel == 1 ? -1 : 0;
        this.wasel = 0;
        this.needZ = false;
        this.z = this.rd1 == 0 ? 1 : 0;
        this.alufn = "+";
        this.wdsel = 1;
        this.pcinc = this.pc + 4;
        this.offset = this.literal << 2;
        this.pcoffset = this.pcinc + this.offset;
        this.alua = this.asel == 1 ? this.pcoffset : this.rd1;
        this.alub = this.bsel == 1 ? this.literal : this.rd2;
        this.alu = this.wdata;
        if (this.irq) {
            this.alu = this.alua + this.alub;
            this.wasel = 1;
            this.pcsel = 4;
            this.wdsel = 0;
            this.asel = -1;
            this.bsel = -1;
            this.ra2sel = -1;
            this.alufn = null;
        } else {
            switch (n) {
                default: {
                    this.alu = this.alua + this.alub;
                    this.wasel = 1;
                    this.pcsel = 3;
                    this.wdsel = 0;
                    this.asel = -1;
                    this.bsel = -1;
                    this.ra2sel = -1;
                    this.alufn = null;
                    break;
                }
                case 24: {
                    this.alu = this.alua + this.alub;
                    this.wdsel = 2;
                    break;
                }
                case 25: {
                    this.alu = this.alua + this.alub;
                    this.ra2sel = 1;
                    this.rb = this.rc;
                    this.rd2 = this.mdata;
                    this.wasel = -1;
                    this.wdsel = -1;
                    break;
                }
                case 27: {
                    this.alu = this.alua + this.alub;
                    this.pcsel = 2;
                    this.wdsel = 0;
                    this.asel = -1;
                    this.bsel = -1;
                    this.ra2sel = -1;
                    this.alufn = null;
                    break;
                }
                case 29: {
                    this.alu = this.alua + this.alub;
                    this.wdsel = 0;
                    this.asel = -1;
                    this.bsel = -1;
                    this.ra2sel = -1;
                    this.alufn = null;
                    this.pcsel = this.z == 1 ? 1 : 0;
                    this.needZ = true;
                    break;
                }
                case 30: {
                    this.alu = this.alua + this.alub;
                    this.wdsel = 0;
                    this.asel = -1;
                    this.bsel = -1;
                    this.ra2sel = -1;
                    this.alufn = null;
                    this.pcsel = this.z == 1 ? 0 : 1;
                    this.needZ = true;
                    break;
                }
                case 31: {
                    this.alu = this.alua;
                    this.alufn = "A";
                    this.bsel = -1;
                    this.ra2sel = -1;
                    this.wdsel = 2;
                    break;
                }
                case 32: 
                case 48: {
                    break;
                }
                case 33: 
                case 49: {
                    this.alufn = "-";
                    break;
                }
                case 34: 
                case 50: {
                    this.alufn = "*";
                    break;
                }
                case 35: 
                case 51: {
                    this.alufn = "/";
                    break;
                }
                case 36: 
                case 52: {
                    this.alufn = "==";
                    break;
                }
                case 37: 
                case 53: {
                    this.alufn = "<";
                    break;
                }
                case 38: 
                case 54: {
                    this.alufn = "<=";
                    break;
                }
                case 40: 
                case 56: {
                    this.alufn = "&";
                    break;
                }
                case 41: 
                case 57: {
                    this.alufn = "|";
                    break;
                }
                case 42: 
                case 58: {
                    this.alufn = "^";
                    break;
                }
                case 44: 
                case 60: {
                    this.alufn = "<<";
                    break;
                }
                case 45: 
                case 61: {
                    this.alufn = ">>";
                    break;
                }
                case 46: 
                case 62: {
                    this.alufn = "sxt(>>)";
                }
            }
        }
        this.mrd = this.ReadMemory(this.alu);
    }

    private String Hexify(int n, int n2) {
        String string = Integer.toHexString(n);
        if (string.length() < n2) {
            string = zeros.substring(0, n2 - string.length()) + string;
        }
        return string.toUpperCase();
    }

    private void DrawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.DrawArrow(graphics, n, n2, n3, n4, n5, n6, Color.black);
    }

    private void DrawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        int n7 = this.gridx * n;
        int n8 = this.gridy * n2;
        graphics.setColor(color);
        switch (n4) {
            case 1: {
                graphics.drawLine(n7 + this.hx, n8 + n6, n7 + this.hx, n8 + n3 * this.gridy - n5);
                graphics.drawLine(n7 + this.hx, n8 + n6, n7, n8 + this.gridx);
                graphics.drawLine(n7 + this.hx, n8 + n6, n7 + this.hx + this.hx, n8 + this.gridx);
                break;
            }
            case 5: {
                int n9 = n7 + n3 * this.gridx - n6;
                graphics.drawLine(n7 + n5, n8 + this.hy, n9, n8 + this.hy);
                graphics.drawLine(n9, n8 + this.hy, n9 - this.gridx, n8 + this.hy + this.hx);
                graphics.drawLine(n9, n8 + this.hy, n9 - this.gridx, n8 + this.hy - this.hx);
                break;
            }
            case 9: {
                int n10 = n8 + n3 * this.gridy - n6;
                graphics.drawLine(n7 + this.hx, n8 + n5, n7 + this.hx, n10);
                graphics.drawLine(n7 + this.hx, n10, n7, n10 - this.gridx);
                graphics.drawLine(n7 + this.hx, n10, n7 + this.hx + this.hx, n10 - this.gridx);
                break;
            }
            case 13: {
                graphics.drawLine(n7 + n6, n8 + this.hy, n7 + n3 * this.gridx + n5, n8 + this.hy);
                graphics.drawLine(n7 + n6, n8 + this.hy, n7 + n6 + this.gridx, n8 + this.hy + this.hx);
                graphics.drawLine(n7 + n6, n8 + this.hy, n7 + n6 + this.gridx, n8 + this.hy - this.hx);
            }
        }
    }

    private void DrawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.gridx * n;
        int n6 = this.gridy * n2;
        int n7 = this.gridx * n3;
        int n8 = this.gridy * n4;
        graphics.setColor(Color.white);
        graphics.fillRect(n5, n6, n7, n8);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n8);
        graphics.drawLine(n5 - 1, n6 - 1, n5 + n7, n6 - 1);
        graphics.drawLine(n5 - 2, n6 - 2, n5 - 2, n6 + n8 + 1);
        graphics.drawLine(n5 - 2, n6 - 2, n5 + n7 + 1, n6 - 2);
        graphics.setColor(new Color(220, 220, 220));
        graphics.drawLine(n5 + n7, n6 + n8, n5 - 1, n6 + n8);
        graphics.drawLine(n5 + n7, n6 + n8, n5 + n7, n6 - 1);
        graphics.drawLine(n5 + n7 + 1, n6 + n8 + 1, n5 - 2, n6 + n8 + 1);
        graphics.drawLine(n5 + n7 + 1, n6 + n8 + 1, n5 + n7 + 1, n6 - 2);
    }

    private void DrawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        this.DrawLine(graphics, n, n2, n3, n4, Color.black);
    }

    private void DrawLine(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(color);
        graphics.drawLine(n, n2, n + n3, n2 + n4);
    }

    private void DrawString(Graphics graphics, String string, int n, int n2) {
        this.DrawString(graphics, string, n, n2, 0, 0, Color.black);
    }

    private void DrawString(Graphics graphics, String string, int n, int n2, Color color) {
        this.DrawString(graphics, string, n, n2, 0, 0, color);
    }

    private void DrawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        this.DrawString(graphics, string, n, n2, n3, n4, Color.black);
    }

    private void DrawString(Graphics graphics, String string, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(color);
        graphics.drawString(string, n * this.gridx + n3, n2 * this.gridy + this.baseline + n4);
    }

    private int AddrSize() {
        int n = 1;
        int n2 = this.memory.Size();
        while (1 << 4 * n < 4 * n2) {
            ++n;
        }
        return n;
    }

    private void DrawMemory(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.AddrSize();
        this.DrawFrame(graphics, n, n2, n5 + 9 + (bl ? 32 : 0), n4);
        int n6 = (n3 &= 0xFFFFFFFC) - 4 * (n4 >> 1);
        for (int i = 0; i < n4; ++i) {
            if (this.memory.ValidAddress(n6)) {
                int n7 = this.memory.Index(n6);
                String string = this.Hexify(n7 << 2, n5);
                String string2 = this.Hexify(this.memory.ReadWord(n6), 8);
                this.DrawString(graphics, string, n, n2, bl & this.breakpoints[n7] ? Color.red : HIDE);
                this.DrawString(graphics, ":", n + n5, n2, HIDE);
                this.DrawString(graphics, string2, n + n5 + 1, n2, !bl ? SHOW : HIDE);
                if (bl) {
                    this.DrawString(graphics, this.Disassemble(n6), n + n5 + 10, n2, n6 == n3 ? SHOW : HIDE);
                }
            }
            n6 += 4;
            ++n2;
        }
    }

    private void DrawRegFile(Graphics graphics, int n, int n2) {
        int n3 = 13;
        int n4 = 8;
        this.DrawFrame(graphics, n, n2, 4 * n3, n4);
        graphics.setFont(this.tFont);
        int n5 = n;
        int n6 = n2;
        for (int i = 0; i < 32; ++i) {
            String string = this.Hexify(this.regs[i], 8);
            String string2 = i == 30 ? " XP:" : (i == 29 ? " SP:" : (i == 28 ? " LP:" : (i == 27 ? " BP:" : (i < 10 ? " R" + i + ":" : "R" + i + ":"))));
            this.DrawString(graphics, string2, n5, n6, Color.gray);
            this.DrawString(graphics, string, n5 + 4, n6);
            ++n6;
            if (i % 8 != 7) continue;
            n5 += 13;
            n6 = n2;
        }
    }

    private void DrawRegister(Graphics graphics, int n, int n2, String string, int n3) {
        this.DrawFrame(graphics, n, n2, string.length() + 9, 1);
        this.DrawString(graphics, string + ":", n, n2, Color.gray);
        this.DrawString(graphics, this.Hexify(n3, 8), n + 3, n2);
    }

    private void DrawHorizontalMux(Graphics graphics, int n, int n2, int n3, String string, int n4, boolean bl, boolean bl2, int n5) {
        this.DrawHorizontalMux(graphics, n, n2, n3, string, n4, bl, bl2, n5, Color.black);
    }

    private void DrawHorizontalMux(Graphics graphics, int n, int n2, int n3, String string, int n4, boolean bl, boolean bl2, int n5, Color color) {
        int n6 = 4;
        int n7 = n6 * n3 - (n6 - 1);
        int n8 = this.gridx * n;
        int n9 = this.gridy * n2;
        int n10 = this.gridx * n7;
        graphics.setColor(color);
        graphics.drawLine(n8 - 4, n9, n8 + n10 + 4, n9);
        graphics.drawLine(n8, n9 + this.gridy, n8 + n10, n9 + this.gridy);
        graphics.drawLine(n8 - 4, n9, n8, n9 + this.gridy);
        graphics.drawLine(n8 + n10 + 4, n9, n8 + n10, n9 + this.gridy);
        for (int i = 0; i < n3; ++i) {
            int n11 = bl ? n + n6 * i : n + n7 - n6 * i - 1;
            this.DrawString(graphics, Integer.toString(i), n11, n2, i == n4 ? color : HIDE);
            this.DrawArrow(graphics, n11, n2 - 1, 1, 9, n5, 0, i == n4 ? color : HIDE);
        }
        String string2 = string + "=" + (n4 >= 0 ? Integer.toString(n4) : "-");
        if (bl2) {
            this.DrawArrow(graphics, n - 2, n2, 2, 5, 0, 2, color);
            this.DrawString(graphics, string2, n - string2.length() - 2, n2, -this.hx, 0, Color.red);
        } else {
            this.DrawArrow(graphics, n + n7, n2, 2, 13, 0, 2, color);
            this.DrawString(graphics, string2, n + n7 + 2, n2, this.hx, 0, Color.red);
        }
    }

    private void DrawVerticalMux(Graphics graphics, int n, int n2, int n3, String string, int n4, boolean bl, boolean bl2, int n5) {
        this.DrawVerticalMux(graphics, n, n2, n3, string, n4, bl, bl2, n5, Color.black);
    }

    private void DrawVerticalMux(Graphics graphics, int n, int n2, int n3, String string, int n4, boolean bl, boolean bl2, int n5, Color color) {
        int n6 = 2;
        int n7 = n6 * n3 - (n6 - 1);
        int n8 = this.gridx * n;
        int n9 = this.gridy * n2;
        int n10 = this.gridy * n7;
        graphics.setColor(color);
        graphics.drawLine(n8, n9 - 4, n8, n9 + n10 + 4);
        graphics.drawLine(n8 + 3 * this.gridx, n9 + 4, n8 + 3 * this.gridx, n9 + n10 - 4);
        graphics.drawLine(n8, n9 - 4, n8 + 3 * this.gridx, n9 + 4);
        graphics.drawLine(n8, n9 + n10 + 4, n8 + 3 * this.gridx, n9 + n10 - 4);
        for (int i = 0; i < n3; ++i) {
            int n11 = bl ? n2 + n6 * i : n2 + n7 - n6 * i - 1;
            this.DrawString(graphics, Integer.toString(i), n, n11, this.hx, 0, i == n4 ? color : HIDE);
            this.DrawArrow(graphics, n - 2, n11, 2, 5, n5, 0, i == n4 ? color : HIDE);
        }
        String string2 = string + "=" + (n4 >= 0 ? Integer.toString(n4) : "-");
        if (bl2) {
            this.DrawArrow(graphics, n + 1, n2 + n7, 1, 1, 0, 0, color);
            this.DrawString(graphics, string2, n + 1 - (string2.length() >> 1), n2 + n7 + 1, this.gridx * (1 - string2.length() % 2), 0, Color.red);
        } else {
            this.DrawArrow(graphics, n + 1, n2 - 1, 1, 9, 0, 0, color);
            this.DrawString(graphics, string2, n + 1 - (string2.length() >> 1), n2 - 2, this.gridx * (1 - string2.length() % 2), 0, Color.red);
        }
    }

    private void DrawVerticalRipper(Graphics graphics, int n, int n2, String string, boolean bl, Color color) {
        int n3 = this.gridx * n;
        int n4 = this.gridy * n2;
        int n5 = string.length();
        graphics.setColor(color);
        graphics.drawLine(n3 - this.hx, n4, n3 + this.hx, n4 + this.gridx);
        graphics.drawLine(n3 + this.hx, n4 + this.gridx, n3 + this.hx, n4 + this.gridy);
        if (bl) {
            this.DrawString(graphics, string, n - n5 - 1, n2, this.hx, 0, color);
        } else {
            this.DrawString(graphics, string, n + 1, n2, this.hx, 0, color);
        }
    }

    private void DrawHorizontalRipper(Graphics graphics, int n, int n2, String string, boolean bl, Color color) {
        int n3 = this.gridx * n;
        int n4 = this.gridy * n2;
        graphics.setColor(color);
        graphics.drawLine(n3 + this.hx, n4 + this.hy - this.gridx, n3 + this.hx + this.gridx, n4 + this.hy);
        graphics.drawLine(n3 + this.hx + this.gridx, n4 + this.hy, n3 + this.gridx + this.gridx, n4 + this.hy);
        if (bl) {
            this.DrawString(graphics, string, n + 1, n2, this.hx, -this.hy, color);
        } else {
            this.DrawString(graphics, string, n + 1, n2 + 1, this.hx, -this.hy, color);
        }
    }

    private void DrawALU(Graphics graphics, int n, int n2, String string, Color color) {
        int n3 = 5;
        int n4 = 2;
        int n5 = 12;
        int n6 = this.gridx * n;
        int n7 = this.gridy * n2;
        int n8 = this.gridy * (n2 + n4);
        int n9 = this.gridx * (n3 + n3 + 1);
        this.DrawLine(graphics, n6, n7, n9 - this.hx, 0, color);
        this.DrawLine(graphics, n6 + n9 - this.hx, n7, 2 * this.hx, 2 * this.hx, color);
        this.DrawLine(graphics, n6 + n9 + this.gridx + this.hx, n7, -2 * this.hx, 2 * this.hx, color);
        this.DrawLine(graphics, n6 + n9 + this.gridx + this.hx, n7, n9 - this.hx, 0, color);
        this.DrawLine(graphics, n6 + n5, n8, 2 * n9 + this.gridx - 2 * n5, 0, color);
        this.DrawLine(graphics, n6, n7, n5, n4 * this.gridy, color);
        this.DrawLine(graphics, n6 + 2 * n9 + this.gridx, n7, -n5, n4 * this.gridy, color);
        this.DrawArrow(graphics, n + n3, n2 - 1, 1, 9, 0, 0, color);
        this.DrawString(graphics, "A", n + n3, n2, color);
        this.DrawArrow(graphics, n + n3 + 1 + n3 + 1 + n3, n2 - 1, 1, 9, 0, 0, color);
        this.DrawString(graphics, "B", n + n3 + 1 + n3 + 1 + n3, n2, color);
        this.DrawString(graphics, "ALU", n + n3 + n3, n2 + 1, 0, 0, color);
        this.DrawArrow(graphics, n - 2, n2 + 1, 2, 5, 0, -(3 * n5 >> 2), color);
        String string2 = "ALUFN=";
        string2 = string == null ? string2 + "-" : string2 + "\"" + string + "\"";
        this.DrawString(graphics, string2, n - 2 - string2.length(), n2 + 1, -this.hx, 0, Color.red);
    }

    private void SelectFont(Graphics graphics) {
        FontMetrics fontMetrics;
        int n;
        int n2;
        int n3 = 10;
        int n4 = -1;
        if (this.display == 0) {
            n2 = 133;
            n = 34;
        } else if (this.display == 1) {
            n2 = 91;
            n = 29;
        } else {
            n2 = 100;
            n = 30;
        }
        while (n3 > 5 && n3 < 20) {
            this.tFont = new Font("Monospaced", 0, n3);
            fontMetrics = graphics.getFontMetrics(this.tFont);
            this.gridx = fontMetrics.charWidth(' ');
            this.gridy = fontMetrics.getHeight();
            if (this.tW >= n2 * this.gridx && this.tH >= n * this.gridy) {
                n4 = n3++;
                continue;
            }
            if (n4 > 0) {
                n3 = n4;
                break;
            }
            --n3;
        }
        this.tFont = new Font("Monospaced", 0, n3);
        fontMetrics = graphics.getFontMetrics(this.tFont);
        this.gridx = fontMetrics.charWidth(' ');
        this.gridy = fontMetrics.getHeight();
        this.hx = this.gridx >> 1;
        this.hy = this.gridy >> 1;
        this.baseline = fontMetrics.getAscent();
    }

    public void SetupScrollbars() {
        Dimension dimension = this.maddrScroll.getPreferredSize();
        if (this.display == 0) {
            this.maddrScroll.setBounds(this.gridx * (120 + this.AddrSize()) + 2, this.gridy * 26 - 2, dimension.width, this.gridy * 7 + 4);
            this.maddrScroll.setVisible(true);
            this.iaddrScroll.setBounds(this.gridx * (76 + this.AddrSize()) + 2, this.gridy * 5 - 2, dimension.width, this.gridy * 3 + 4);
            this.iaddrScroll.setVisible(true);
        } else if (this.display == 1) {
            this.maddrScroll.setBounds(this.gridx * (87 + this.AddrSize()) + 2, this.gridy * 2 - 2, dimension.width, this.gridy * 26 + 4);
            this.maddrScroll.setVisible(true);
            this.iaddrScroll.setBounds(this.gridx * (48 + this.AddrSize()) + 2, this.gridy * 12 - 2, dimension.width, this.gridy * 16 + 4);
            this.iaddrScroll.setVisible(true);
        } else {
            this.maddrScroll.setVisible(false);
            this.iaddrScroll.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getHeight();
        if (this.tty) {
            n -= this.userscroll.getHeight();
        }
        if (this.tFont == null || this.tW != this.getWidth() || this.tH != n) {
            this.tW = this.getWidth();
            this.tH = n;
            this.SelectFont(graphics);
            this.SetupScrollbars();
        }
        this.iaddrScroll.setValue(this.iaddr >> 2);
        this.maddrScroll.setValue(this.maddr >> 2);
        if (this.simulation != null) {
            graphics.setColor(Color.red);
            graphics.setFont(new Font("Serif", 1, 32));
            graphics.drawString("Running simulation... press stop to view state", 20, 50);
            return;
        }
        if (this.display == 0) {
            this.DrawDatapath(graphics);
        } else if (this.display == 1) {
            this.DrawProgrammersPanel(graphics);
        }
    }

    void DrawDatapath(Graphics graphics) {
        Color color;
        graphics.setFont(this.tFont);
        this.Signals();
        int n = 10;
        int n2 = 3;
        int n3 = n + 25;
        int n4 = n3 + 14;
        int n5 = n2 + 9;
        int n6 = n3 + 30;
        int n7 = n2 + 9;
        int n8 = n6 + 9;
        int n9 = n6 + 35;
        int n10 = n7 + 12;
        this.DrawString(graphics, "8", n, n2 - 2, this.pcsel == 4 ? SHOW : HIDE);
        this.DrawString(graphics, "4", n + 4, n2 - 2, this.pcsel == 3 ? SHOW : HIDE);
        this.DrawString(graphics, "JT", n + 7, n2 - 2, this.pcsel == 2 ? SHOW : HIDE);
        this.DrawHorizontalMux(graphics, n, n2, 5, "PCSEL", this.pcsel, false, true, 0);
        this.DrawArrow(graphics, n + 8, n2 + 1, 1, 9, 0, 2);
        this.DrawString(graphics, this.Hexify(this.npcmsb << 31 | this.npc, 8), n + 9, n2 + 1, this.hx, 0, Color.blue);
        this.DrawRegister(graphics, n + 3, n2 + 2, "PC", this.pcmsb << 31 | this.pc);
        this.DrawMemory(graphics, n3, n2 + 2, this.iaddr, 3, true);
        this.DrawArrow(graphics, n + 8, n2 + 3, 2, 9, 2, 0);
        this.DrawArrow(graphics, n + 9, n2 + 3, n3 - (n + 9), 5, -this.hx, 2);
        if (this.wdsel == 0 || this.pcsel == 0 || this.pcsel == 1) {
            color = SHOW;
            this.DrawString(graphics, this.Hexify(this.pcinc, 8), n + 9, n2 + 7, this.hx, 0, Color.blue);
        } else {
            color = HIDE;
        }
        graphics.setColor(color);
        graphics.drawRect(this.gridx * (n + 6), this.gridy * (n2 + 5), 5 * this.gridx, 2 * this.gridy);
        this.DrawString(graphics, "+4", n + 7, n2 + 5, this.hx, this.hy, color);
        this.DrawLine(graphics, this.gridx * (n + 8) + this.hx, this.gridy * (n2 + 7), 0, this.gridy, color);
        this.DrawLine(graphics, this.gridx * (n + 8) + this.hx, this.gridy * (n2 + 8), 11 * this.gridx, 0, this.pcsel == 0 || this.pcsel == 1 ? SHOW : HIDE);
        color = this.pcsel == 0 ? SHOW : HIDE;
        this.DrawLine(graphics, this.gridx * (n + 16) + this.hx, this.gridy * (n2 - 1), 3 * this.gridx, 0, color);
        this.DrawLine(graphics, this.gridx * (n + 19) + this.hx, this.gridy * (n2 - 1), 0, 4 * this.gridy + this.hy - 3, color);
        this.DrawLine(graphics, this.gridx * (n + 19) + this.hx, this.gridy * (n2 + 8), 0, -4 * this.gridy - this.hy + 3, color);
        color = this.pcsel == 1 ? SHOW : HIDE;
        this.DrawLine(graphics, this.gridx * (n + 12) + this.hx, this.gridy * (n2 - 2), 9 * this.gridx, 0, color);
        this.DrawLine(graphics, this.gridx * (n + 12) + this.hx, this.gridy * (n2 - 2), 0, this.gridy, color);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n2 - 2), 0, 5 * this.gridy + this.hy - 3, color);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n2 + 8) - 3, 0, -4 * this.gridy - this.hy + 6, color);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n2 + 8) + 3, 0, 2 * this.gridy - 3, color);
        color = this.pcsel == 1 || this.asel == 1 ? SHOW : HIDE;
        this.DrawLine(graphics, this.gridx * (n + 19) + this.hx, this.gridy * (n2 + 8), 12 * this.gridx - this.hx, 0, color);
        graphics.drawRect(this.gridx * (n + 24), this.gridy * n5, 5 * this.gridx, 2 * this.gridy);
        this.DrawString(graphics, "+", n + 26, n5, 0, this.hy, color);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n5 + 1), 3 * this.gridx - this.hx, 0, color);
        this.DrawArrow(graphics, n + 29, n5, 2, 13, 0, 0, color);
        this.DrawLine(graphics, this.gridx * (n + 31), this.gridy * n5 + this.hy, 0, -this.gridy * (n5 - (n2 + 8)) - this.hy, color);
        this.DrawArrow(graphics, n + 29, n5 + 1, n4 - (n + 29), 13, -this.hx, 0, color);
        this.DrawString(graphics, "[15:0]*4", n + 30, n5, this.hx, this.hy, color);
        this.DrawLine(graphics, this.gridx * n4 - this.hx, this.gridy * (n5 + 1) + this.hy, this.gridx, -this.gridx, color);
        if (this.pcsel == 1 || this.asel == 1) {
            this.DrawString(graphics, this.Hexify(this.offset, 8), n + 30, n5 + 1, this.hx, this.hy, Color.blue);
            this.DrawString(graphics, this.Hexify(this.pcoffset, 8), n + 12, n5, this.hx, this.hy, Color.blue);
        }
        this.DrawLine(graphics, this.gridx * n4 + this.hx, this.gridy * (n2 + 5), 0, this.gridy * (n7 + 2 - (n2 + 5)));
        this.DrawString(graphics, this.Hexify(this.inst, 8), n4 + 1, n2 + 5, 0, 0, Color.blue);
        if (this.wasel >= 0) {
            color = SHOW;
            this.DrawString(graphics, this.Hexify(this.rc, 2), n6 - 4, n7 + 2, this.hx, this.hy, Color.blue);
        } else {
            color = HIDE;
        }
        this.DrawVerticalMux(graphics, n6 - 7, n7 + 2, 2, "WASEL", this.wasel, true, true, 0, color);
        this.DrawArrow(graphics, n6 - 4, n7 + 3, 4, 5, 0, 2, color);
        this.DrawString(graphics, "XP", n6 - 11, n7 + 4, this.wasel == 1 ? SHOW : HIDE);
        this.DrawHorizontalRipper(graphics, n4, n7 + 2, "[25:21]", true, this.wasel == 0 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n4 + 2), this.gridy * (n7 + 2) + this.hy, this.gridx * (n6 - 9 - (n4 + 2)), 0, this.wasel == 0 ? SHOW : HIDE);
        int n11 = this.ra2sel == 1 ? this.rc : this.rb;
        this.DrawLine(graphics, this.gridx * n4 + this.hx, this.gridy * (n7 - 3), this.gridx * (n6 + 12 - n4) + this.hx, 0);
        this.DrawVerticalRipper(graphics, n6 + 13, n7 - 3, "RA:[20:16]", true, SHOW);
        this.DrawArrow(graphics, n6 + 13, n7 - 2, 2, 9, 0, 2, SHOW);
        this.DrawVerticalRipper(graphics, n6 + 37, n7 - 3, "RB:[15:11]", true, this.ra2sel == 0 ? SHOW : HIDE);
        this.DrawVerticalRipper(graphics, n6 + 41, n7 - 3, "RC:[25:21]", false, this.ra2sel == 1 ? SHOW : HIDE);
        this.DrawString(graphics, this.Hexify(this.ra, 2), n6 + 14, n7 - 1, this.hx, 0, Color.blue);
        if (this.ra2sel >= 0) {
            color = SHOW;
            this.DrawString(graphics, this.Hexify(this.rb, 2), n6 + 40, n7 - 1, this.hx, 0, Color.blue);
        } else {
            color = HIDE;
        }
        this.DrawLine(graphics, this.gridx * (n6 + 12) + this.hx, this.gridy * (n7 - 3), this.gridx * 24, 0, color);
        this.DrawLine(graphics, this.gridx * (n6 + 36) + this.hx, this.gridy * (n7 - 3), this.gridx * 4, 0, this.ra2sel == 1 ? SHOW : HIDE);
        this.DrawHorizontalMux(graphics, n6 + 37, n7 - 2, 2, "RA2SEL", this.ra2sel, true, false, this.hy, color);
        this.DrawArrow(graphics, n6 + 39, n7 - 1, 1, 9, 0, 2, color);
        this.DrawRegFile(graphics, n6, n7);
        this.DrawLine(graphics, this.gridx * (n6 + 13) + this.hx, this.gridy * (n7 + 8) + 2, 0, this.gridy * 2 - this.hy - 2, SHOW);
        this.DrawString(graphics, this.Hexify(this.rd1, 8), n6 + 14, n7 + 8, this.hx, 0, Color.blue);
        this.DrawLine(graphics, this.gridx * (n6 + 39) + this.hx, this.gridy * (n7 + 8) + 2, 0, this.gridy * 2 + this.hy - 2, this.ra2sel >= 0 ? SHOW : HIDE);
        if (this.ra2sel >= 0) {
            this.DrawString(graphics, this.Hexify(this.rd2, 8), n6 + 40, n7 + 8, this.hx, 0, Color.blue);
        }
        this.DrawArrow(graphics, n6 + 52, n7 + 4, 2, 13, 0, 2);
        this.DrawString(graphics, "WERF=" + (this.werf ? "1" : "0"), n6 + 54, n7 + 4, this.hx, 0, Color.red);
        this.DrawArrow(graphics, n6 + 52, n7 + 3, 14, 13, 0, 2, this.werf ? SHOW : HIDE);
        if (this.wdsel >= 0) {
            this.DrawString(graphics, this.Hexify(this.wdata, 8), n6 + 54, n7 + 3, this.hx, -this.hy, Color.blue);
        }
        color = this.pcsel == 2 ? SHOW : HIDE;
        this.DrawArrow(graphics, n6 + 7, n7 + 8, 6, 13, this.hx, 0, color);
        this.DrawString(graphics, "JT", n6 + 5, n7 + 8, color);
        color = this.needZ ? SHOW : HIDE;
        this.DrawArrow(graphics, n6 + 11, n7 + 9, 2, 13, this.hx, 2, color);
        graphics.setColor(color);
        graphics.drawRect(this.gridx * (n6 + 9) - 2, this.gridy * (n7 + 9), 2 * this.gridx + 4, this.gridy);
        this.DrawString(graphics, "0?", n6 + 9, n7 + 9, color);
        this.DrawArrow(graphics, n6 + 7, n7 + 9, 2, 13, -2, 0, color);
        this.DrawString(graphics, "Z=" + this.z, n6 + 4, n7 + 9, Color.red);
        this.DrawHorizontalMux(graphics, n8, n10, 2, "ASEL", this.asel, false, false, this.hy, this.asel == -1 ? HIDE : SHOW);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n5 + 1), 0, 10 * this.gridy + this.hy, this.asel == 1 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n + 21) + this.hx, this.gridy * (n2 + 20) + this.hy, this.gridx * (n8 - (n + 21)), 0, this.asel == 1 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n6 + 13) + this.hx, this.gridy * (n10 - 3) + this.hy, 0, this.gridy * 2 + this.hy, this.asel == 0 ? SHOW : HIDE);
        this.DrawHorizontalMux(graphics, n9, n10, 2, "BSEL", this.bsel, false, false, 0, this.bsel == -1 ? HIDE : SHOW);
        if (this.bsel == 1) {
            color = SHOW;
            this.DrawString(graphics, this.Hexify(this.literal, 8), n9 - 8, n10 - 2, 0, -this.hy, Color.blue);
        } else {
            color = HIDE;
        }
        this.DrawHorizontalRipper(graphics, n4, n10 - 2, "C:[15:0]", true, color);
        this.DrawLine(graphics, this.gridx * (n4 + 2), this.gridy * (n10 - 2) + this.hy, this.gridx * (n6 + 13 - (n4 + 2)), 0, color);
        this.DrawLine(graphics, this.gridx * (n6 + 14), this.gridy * (n10 - 2) + this.hy, this.gridx * (n9 - (n6 + 14)) + this.hx, 0, color);
        this.DrawLine(graphics, this.gridx * n9 + this.hx, this.gridy * (n10 - 2) + this.hy, 0, this.gridy, color);
        this.DrawLine(graphics, this.gridx * n4 + this.hx, this.gridy * (n7 + 2), 0, this.gridy * (n10 - 2 - (n7 + 2)), color);
        this.DrawLine(graphics, this.gridx * (n6 + 39) + this.hx, this.gridy * (n10 - 1), 0, -this.hy, this.bsel == 0 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n8 + 2) + this.hx, this.gridy * (n10 + 1), 0, this.gridy, this.asel >= 0 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n8 + 2) + this.hx, this.gridy * (n10 + 2), 7 * this.gridx, 0, this.asel >= 0 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n9 + 2) + this.hx, this.gridy * (n10 + 1), 0, this.gridy, this.bsel >= 0 ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n9 + 2) + this.hx, this.gridy * (n10 + 2), -7 * this.gridx, 0, this.bsel >= 0 ? SHOW : HIDE);
        this.DrawALU(graphics, n8 + 4, n10 + 3, this.alufn, this.alufn != null ? SHOW : HIDE);
        if (this.asel >= 0) {
            this.DrawString(graphics, this.Hexify(this.alua, 8), n8 + 1, n10 + 2, -this.hx, 0, Color.blue);
        }
        if (this.bsel >= 0) {
            this.DrawString(graphics, this.Hexify(this.alub, 8), n8 + 22, n10 + 2, this.hx, 0, Color.blue);
        }
        this.DrawLine(graphics, this.gridx * (n8 + 15) + this.hx, this.gridy * (n10 + 5), 0, this.hy, this.wdsel >= 1 || this.wr ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n8 + 15) + this.hx, this.gridy * (n10 + 5) + this.hy, 0, 2 * this.gridy, this.wdsel == 1 ? SHOW : HIDE);
        if (this.wdsel > 0 || this.wr) {
            this.DrawString(graphics, this.Hexify(this.alu, 8), n8 + 7, n10 + 5, 0, 0, Color.blue);
        }
        this.DrawMemory(graphics, n8 + 37, n10 + 2, this.maddr, 7, false);
        this.DrawLine(graphics, this.gridx * (n8 + 42) + this.hx, this.gridy * (n10 - 1) - this.hy, -12 * this.gridx, 0, this.wr ? SHOW : HIDE);
        this.DrawArrow(graphics, n8 + 42, n10 - 1, 3, 9, -this.hy, 2, this.wr ? SHOW : HIDE);
        this.DrawString(graphics, "MWD", n8 + 39, n10 + 1, -this.hx, 0, this.wr ? SHOW : HIDE);
        this.DrawArrow(graphics, n8 + 47, n10 + 1, 1, 9, 0, 2);
        this.DrawString(graphics, "WR=" + (this.wr ? 1 : 0), n8 + 45, n10, this.hx, 0, Color.red);
        this.DrawArrow(graphics, n8 + 15, n10 + 5, 22, 5, this.hx, 2, this.wdsel == 2 || this.wr ? SHOW : HIDE);
        this.DrawString(graphics, "MA", n8 + 35, n10 + 4, -this.hx, this.hy, this.wdsel == 2 || this.wr ? SHOW : HIDE);
        this.DrawLine(graphics, this.gridx * (n8 + 11 + 8) + this.hx, this.gridy * (n10 + 7), this.gridx * 17, 0, this.wdsel == 2 ? SHOW : HIDE);
        if (this.wdsel == 2) {
            this.DrawString(graphics, this.Hexify(this.mrd, 8), n8 + 11 + 9, n10 + 6, 0, 0, Color.blue);
        }
        this.DrawString(graphics, "MRD", n8 + 34, n10 + 7, -this.hx, 0, this.wdsel == 2 ? SHOW : HIDE);
        color = this.wdsel == 0 ? SHOW : HIDE;
        this.DrawLine(graphics, this.gridx * (n + 8) + this.hx, this.gridy * (n2 + 8), 0, 20 * this.gridy, color);
        this.DrawLine(graphics, this.gridx * (n + 8) + this.hx, this.gridy * (n10 + 7), this.gridx * (n8 + 11 - (n + 8)), 0, color);
        if (this.wdsel == 0) {
            this.DrawString(graphics, this.Hexify(this.pcmsb << 31 | this.pcinc, 8), n8 + 11 - 8, n10 + 6, 0, 0, Color.blue);
        }
        color = this.wdsel >= 0 ? SHOW : HIDE;
        this.DrawHorizontalMux(graphics, n8 + 11, n10 + 8, 3, "WDSEL", this.wdsel, true, true, 0, color);
        this.DrawArrow(graphics, n8 + 15, n10 + 9, 1, 9, 0, 0, color);
        this.DrawLine(graphics, this.gridx * (n8 + 15) + this.hx, this.gridy * (n10 + 10), this.gridx * (n6 + 66 - (n8 + 15)) - this.hx, 0, color);
        this.DrawLine(graphics, this.gridx * (n6 + 66), this.gridy * (n7 + 3) + this.hy, 0, 19 * this.gridy - this.hy, color);
        this.DrawString(graphics, "cycle = " + this.cycles, 0, 33, 0, 0, SHOW);
    }

    void AnnotateStack(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.regs[29];
        int n6 = n5 - 4 * n4 + 4;
        if (n != 0 && n >= n6 && n <= n5) {
            int n7 = n - 4 - n6 >> 2;
            if (bl) {
                this.DrawString(graphics, "BP", n2 - 6, n3 + n7 + 1, Color.BLACK);
                this.DrawArrow(graphics, n2 - 4, n3 + n7 + 1, 4, 5, this.hx, 2);
            }
            if (n7 < 0) {
                return;
            }
            this.DrawString(graphics, "oldBP", n2 - 5, n3 + n7, -2, 0, Color.WHITE);
            if (--n7 < 0) {
                return;
            }
            this.DrawString(graphics, "oldLP", n2 - 5, n3 + n7, -2, 0, Color.WHITE);
            int n8 = this.ReadMemory(this.ReadMemory(n - 8));
            if ((n8 & 0xFFFF0000) == -943915008) {
                int n9 = (n8 & 0xFFFF) >> 2;
                for (int i = 1; i <= n9; ++i) {
                    if (--n7 < 0) {
                        return;
                    }
                    this.DrawString(graphics, "arg" + Integer.toString(i), n2 - 5, n3 + n7, -2, 0, Color.WHITE);
                }
            }
            this.AnnotateStack(graphics, this.ReadMemory(n - 4), n2, n3, n4, false);
        }
    }

    void DrawProgrammersPanel(Graphics graphics) {
        graphics.setFont(this.tFont);
        this.DrawString(graphics, "REGISTERS", 1, 1, Color.BLACK);
        this.DrawRegFile(graphics, 1, 2);
        int n = 16;
        int n2 = 12 + (n >> 1);
        this.DrawString(graphics, "INSTRUCTIONS", 7, 11, Color.BLACK);
        this.DrawMemory(graphics, 7, 12, this.iaddr, n, true);
        this.DrawString(graphics, this.pcmsb == 1 ? "(SUPERVISOR MODE)" : "(USER MODE)", 20, 11, Color.BLACK);
        this.DrawString(graphics, "PC", 1, n2, Color.BLACK);
        this.DrawArrow(graphics, 3, n2, 4, 5, this.hx, 2);
        this.DrawString(graphics, "STACK", 61, 1, Color.BLACK);
        this.DrawMemory(graphics, 61, 2, this.regs[29] - 48, 26, false);
        this.DrawString(graphics, "SP", 55, 27, Color.BLACK);
        this.DrawArrow(graphics, 57, 27, 4, 5, this.hx, 2);
        if (this.annotate) {
            this.AnnotateStack(graphics, this.regs[27], 61, 2, 26, true);
        }
        this.DrawString(graphics, "MEM[0x" + Integer.toHexString(this.maddr) + "]", 78, 1, Color.BLACK);
        this.DrawMemory(graphics, 78, 2, this.maddr, 26, false);
    }
}

