/*
 * Decompiled with CFR 0.152.
 */
package bsim;

import bsim.BSim;
import bsim.Beta;
import bsim.Macro;
import bsim.Symbol;
import gui.EditBuffer;
import gui.GuiFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Program
extends EditBuffer
implements ActionListener {
    public static final int SPC = 1;
    public static final int EOL = 2;
    public static final int D = 4;
    public static final int S = 8;
    public static final int T = 16;
    public static final int[] cinfo = new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 24, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 2, 0, 0, 0};
    Beta beta;
    Hashtable symbols;
    Symbol dot;
    int maxDot;
    boolean usesDot;
    int pass;
    String sText;
    int sLength;
    int sOffset;
    int sStart;
    EditBuffer sBuffer;
    String sPrefix;
    boolean errors;
    boolean writeable;
    public String checkoffServer;
    public String assignment;
    public Integer checkoffChecksum;
    public String checkoffType;
    boolean outputChecksum;
    boolean dumpMemory;
    public Vector verifications;

    public Program(GuiFrame guiFrame, File file) {
        super(guiFrame, file);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Run UASM")) {
            Beta beta = ((BSim)this.parent).GetBeta(this);
            beta.StopReset();
            this.Assemble(beta);
            if (!this.errors) {
                this.Message("assembly complete, " + this.maxDot + " bytes output");
                ((BSim)this.parent).SetPlot(beta);
            }
        } else if (string.equals("UASM to .bin file")) {
            Beta beta = ((BSim)this.parent).GetBeta(this);
            if (this.dot == null) {
                this.Assemble(beta);
            }
            if (!this.errors) {
                String string2 = this.source.getName();
                if (string2.endsWith(".uasm")) {
                    string2 = string2.substring(0, string2.length() - 5);
                }
                try {
                    File file = new File(this.source.getParentFile(), string2 + ".bin");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    for (int i = 0; i < this.maxDot; ++i) {
                        fileOutputStream.write(beta.ReadMemoryByte(i));
                    }
                    fileOutputStream.close();
                    File file2 = new File(this.source.getParentFile(), string2 + ".contents");
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
                    for (int i = 0; i < this.maxDot; i += 4) {
                        if (i % 32 == 0) {
                            printWriter.print("\n+");
                        }
                        printWriter.print(" 0x" + Integer.toHexString(beta.ReadMemory(i)));
                    }
                    printWriter.print("\n");
                    printWriter.close();
                    File file3 = new File(this.source.getParentFile(), string2 + ".coe");
                    PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file3));
                    printWriter2.print("memory_initialization_radix=16;\n");
                    printWriter2.print("memory_initialization_vector=\n");
                    for (int i = 0; i < this.maxDot; i += 4) {
                        String string3 = Integer.toHexString(beta.ReadMemory(i));
                        if (string3.length() < 8) {
                            string3 = "00000000".substring(0, 8 - string3.length()) + string3;
                        }
                        printWriter2.print(string3);
                        printWriter2.print(",\n");
                    }
                    printWriter2.print("0;\n");
                    printWriter2.close();
                    this.Message(this.maxDot + " bytes output to " + string2 + ".bin and " + string2 + ".contents and " + string2 + ".coe");
                }
                catch (Exception exception) {
                    this.Message("exception while writing .bin or .contents file: " + exception);
                }
            }
        }
    }

    private void InitializeMacros() {
        Enumeration enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            Symbol symbol = (Symbol)enumeration.nextElement();
            symbol.ClearMacroDefinitions();
        }
        this.sPrefix = "";
    }

    private void SkipBlanks() {
        while (this.sOffset < this.sLength && cinfo[this.sText.charAt(this.sOffset)] == 1) {
            ++this.sOffset;
        }
    }

    private void SkipToken() {
        while (this.sOffset < this.sLength && (cinfo[this.sText.charAt(this.sOffset)] & 0x10) != 0) {
            ++this.sOffset;
        }
    }

    private boolean CheckForChar(int n) {
        this.SkipBlanks();
        if (this.sOffset < this.sLength && this.sText.charAt(this.sOffset) == n) {
            ++this.sOffset;
            return true;
        }
        return false;
    }

    private void AssembleByte(int n) {
        if (this.pass == 2 && this.beta != null) {
            this.beta.WriteMemoryByte(this.dot.value, n, this.writeable);
        }
        ++this.dot.value;
        if (this.dot.value > this.maxDot) {
            this.maxDot = this.dot.value;
        }
    }

    private int AssembleOctalDigits(int n) {
        int n2 = n - 48;
        if (this.sOffset < this.sLength && (n = (int)this.sText.charAt(this.sOffset)) >= 48 && n <= 55) {
            ++this.sOffset;
            n2 = n2 * 8 + n - 48;
            if (this.sOffset < this.sLength && (n = (int)this.sText.charAt(this.sOffset)) >= 48 && n <= 55) {
                ++this.sOffset;
                n2 = n2 * 8 + n - 48;
            }
        }
        return n2;
    }

    private void AssembleString() {
        if (this.CheckForChar(34)) {
            while (this.sOffset < this.sLength) {
                int n = this.sText.charAt(this.sOffset++);
                block0 : switch (n) {
                    case 34: {
                        return;
                    }
                    case 10: {
                        break;
                    }
                    case 92: {
                        if (this.sOffset < this.sLength) {
                            n = this.sText.charAt(this.sOffset++);
                        }
                        switch (n) {
                            case 98: {
                                n = 8;
                                break block0;
                            }
                            case 102: {
                                n = 12;
                                break block0;
                            }
                            case 110: {
                                n = 10;
                                break block0;
                            }
                            case 114: {
                                n = 13;
                                break block0;
                            }
                            case 116: {
                                n = 9;
                                break block0;
                            }
                            case 92: {
                                n = 92;
                                break block0;
                            }
                        }
                        if (n < 48 || n > 55) break;
                        n = this.AssembleOctalDigits(n);
                    }
                }
                this.AssembleByte(n);
            }
            this.ReportError("unterminated string constant");
        }
    }

    private void ReportError(String string) {
        if (!this.errors) {
            int n = this.sText.indexOf(10, this.sStart);
            if (n == -1) {
                n = this.sLength;
            }
            if (this.sPrefix.length() > 0) {
                string = "[" + this.sPrefix + "] " + string;
            }
            this.Message(this.sBuffer, this.sStart, n, string);
            this.errors = true;
        }
    }

    private String ReadString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.SkipBlanks();
        if (!this.CheckForChar(34)) {
            this.ReportError("expected double-quote as start of string");
        }
        while (this.sOffset < this.sLength) {
            int n = this.sText.charAt(this.sOffset++);
            block0 : switch (n) {
                case 34: {
                    return stringBuffer.toString();
                }
                case 10: {
                    break;
                }
                case 92: {
                    if (this.sOffset < this.sLength) {
                        n = this.sText.charAt(this.sOffset++);
                    }
                    switch (n) {
                        case 98: {
                            n = 8;
                            break block0;
                        }
                        case 102: {
                            n = 12;
                            break block0;
                        }
                        case 110: {
                            n = 10;
                            break block0;
                        }
                        case 114: {
                            n = 13;
                            break block0;
                        }
                        case 116: {
                            n = 9;
                        }
                    }
                }
            }
            stringBuffer.append((char)n);
        }
        this.ReportError("unterminated string constant");
        return stringBuffer.toString();
    }

    private Integer ReadTerm() {
        Integer n = null;
        this.SkipBlanks();
        if (this.sOffset >= this.sLength) {
            return null;
        }
        int n2 = this.sText.charAt(this.sOffset);
        int n3 = cinfo[n2];
        if ((n3 & 4) != 0) {
            int n4 = 10;
            int n5 = this.sOffset;
            this.SkipToken();
            String string = this.sText.substring(n5, this.sOffset);
            if (string.startsWith("0x") || string.startsWith("0X")) {
                n4 = 16;
                string = string.substring(2);
            } else if (string.startsWith("0b") || string.startsWith("0B")) {
                n4 = 2;
                string = string.substring(2);
            } else if (string.startsWith("0") && string.length() > 1) {
                n4 = 8;
                string = string.substring(1);
            }
            try {
                long l = Long.parseLong(string, n4);
                n = new Integer((int)l);
            }
            catch (NumberFormatException numberFormatException) {
                this.ReportError("bad number format: " + string);
            }
        } else if ((n3 & 8) != 0) {
            int n6 = this.sOffset;
            this.SkipToken();
            String string = this.sText.substring(n6, this.sOffset);
            Symbol symbol = Symbol.Lookup(this.symbols, string, true);
            if (this.pass == 2 && symbol.type == 0) {
                this.ReportError("undefined symbol " + string);
            } else {
                n = new Integer(symbol.value);
            }
            if (symbol == this.dot) {
                this.usesDot = true;
            }
        } else if (n2 == 39) {
            this.sOffset += 3;
            if (this.sOffset < this.sLength) {
                if (this.sText.charAt(this.sOffset - 2) == '\\') {
                    ++this.sOffset;
                    n2 = this.sText.charAt(this.sOffset - 2);
                    switch (n2) {
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                        }
                    }
                } else {
                    n2 = this.sText.charAt(this.sOffset - 2);
                }
                if (this.sOffset < this.sLength & this.sText.charAt(this.sOffset - 1) == '\'') {
                    return new Integer(n2);
                }
            }
            this.ReportError("bad character constant");
        } else if (n2 == 45) {
            ++this.sOffset;
            Integer n7 = this.ReadTerm();
            if (n7 != null) {
                n = new Integer(-n7.intValue());
            }
        } else if (n2 == 126) {
            ++this.sOffset;
            Integer n8 = this.ReadTerm();
            if (n8 != null) {
                n = new Integer(~n8.intValue());
            }
        } else if (n2 == 40) {
            ++this.sOffset;
            Integer n9 = this.ReadExpression();
            if (n9 != null) {
                this.SkipBlanks();
                if (this.sOffset >= this.sLength || this.sText.charAt(this.sOffset) != ')') {
                    this.ReportError("unbalanced parenthesis in expression");
                } else {
                    ++this.sOffset;
                    n = n9;
                }
            }
        } else {
            this.ReportError("Illegal term in expression: " + this.sText.substring(this.sOffset, Math.min(this.sLength, this.sOffset + 10)));
        }
        return n;
    }

    private Integer ReadExpression() {
        Integer n = this.ReadTerm();
        block9: while (n != null) {
            this.SkipBlanks();
            if (this.sOffset >= this.sLength) break;
            switch (this.sText.charAt(this.sOffset++)) {
                case '+': {
                    Integer n2 = this.ReadTerm();
                    if (n2 == null) {
                        n = null;
                        continue block9;
                    }
                    n = new Integer(n + n2);
                    continue block9;
                }
                case '-': {
                    Integer n2 = this.ReadTerm();
                    if (n2 == null) {
                        n = null;
                        continue block9;
                    }
                    n = new Integer(n - n2);
                    continue block9;
                }
                case '*': {
                    Integer n2 = this.ReadTerm();
                    if (n2 == null) {
                        n = null;
                        continue block9;
                    }
                    n = new Integer(n * n2);
                    continue block9;
                }
                case '/': {
                    Integer n2 = this.ReadTerm();
                    if (n2 == null) {
                        n = null;
                        continue block9;
                    }
                    n = new Integer(n / n2);
                    continue block9;
                }
                case '%': {
                    Integer n2 = this.ReadTerm();
                    if (n2 == null) {
                        n = null;
                        continue block9;
                    }
                    int n3 = n % n2;
                    if (n3 < 0) {
                        n3 += n2.intValue();
                    }
                    n = new Integer(n3);
                    continue block9;
                }
                case '>': {
                    Integer n2;
                    if (this.CheckForChar(62)) {
                        n2 = this.ReadTerm();
                        if (n2 == null) {
                            n = null;
                            continue block9;
                        }
                        n = new Integer(n >> n2);
                        continue block9;
                    }
                    --this.sOffset;
                    continue block9;
                }
                case '<': {
                    Integer n2;
                    if (this.CheckForChar(60)) {
                        n2 = this.ReadTerm();
                        if (n2 == null) {
                            n = null;
                            continue block9;
                        }
                        n = new Integer(n << n2);
                        continue block9;
                    }
                    --this.sOffset;
                    continue block9;
                }
            }
            --this.sOffset;
            return n;
        }
        return n;
    }

    private void ReadOperand() {
        Integer n;
        this.SkipBlanks();
        if ((cinfo[this.sText.charAt(this.sOffset)] & 8) != 0) {
            int n2 = this.sOffset;
            this.SkipToken();
            int n3 = this.sOffset;
            if (this.CheckForChar(40)) {
                int n4;
                Object object;
                String string = this.sText.substring(n2, n3);
                Vector<Object> vector = new Vector<Object>();
                while (!this.CheckForChar(41)) {
                    this.CheckForChar(44);
                    object = this.ReadExpression();
                    if (object != null) {
                        vector.addElement(object);
                        continue;
                    }
                    this.ReportError("expression or close paren expected");
                    return;
                }
                object = Symbol.Lookup(this.symbols, string);
                Macro macro = ((Symbol)object).LookupMacro(n4 = vector.size());
                if (macro == null) {
                    this.ReportError("can't find macro definition for " + string + " with " + vector.size() + " arguments");
                    return;
                }
                if (macro.called) {
                    this.ReportError("recursive call to macro " + string);
                    return;
                }
                macro.called = true;
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    Symbol symbol = (Symbol)macro.params.elementAt(i);
                    nArray[i] = symbol.value;
                    nArray2[i] = symbol.type;
                    symbol.value = (Integer)vector.elementAt(i);
                    symbol.type = 1;
                }
                String string2 = this.sPrefix;
                this.sPrefix = this.sPrefix.length() > 0 ? this.sPrefix + "," + string : string;
                this.Scan(null, macro.body);
                this.sPrefix = string2;
                macro.called = false;
                for (int i = 0; i < n4; ++i) {
                    Symbol symbol = (Symbol)macro.params.elementAt(i);
                    symbol.value = nArray[i];
                    symbol.type = nArray2[i];
                }
                return;
            }
            this.sOffset = n2;
        }
        if ((n = this.ReadExpression()) != null) {
            this.AssembleByte(n);
        } else {
            this.ReportError("illegal operand");
        }
    }

    private void ReadMacro() {
        Object object;
        int n;
        int n2 = this.sOffset;
        this.SkipToken();
        if (this.sOffset == n2) {
            this.ReportError("expected name following .macro");
            return;
        }
        Symbol symbol = Symbol.Lookup(this.symbols, this.sText.substring(n2, this.sOffset), true);
        Vector<Object> vector = new Vector<Object>();
        if (this.CheckForChar(40)) {
            while (!this.CheckForChar(41)) {
                if (this.sOffset >= this.sLength) {
                    this.ReportError("expected ')' in macro definition");
                    return;
                }
                n = this.sText.charAt(this.sOffset);
                if ((cinfo[this.sText.charAt(this.sOffset)] & 8) == 0) {
                    this.ReportError("symbol expected in macro parameter list");
                    return;
                }
                n2 = this.sOffset;
                this.SkipToken();
                object = Symbol.Lookup(this.symbols, this.sText.substring(n2, this.sOffset), true);
                vector.addElement(object);
                this.SkipBlanks();
                if (this.sOffset >= this.sLength || this.sText.charAt(this.sOffset) != ',') continue;
                ++this.sOffset;
            }
        }
        if ((n = this.CheckForChar(123) ? this.sText.indexOf(125, this.sOffset) : this.sText.indexOf(10, this.sOffset)) == -1) {
            n = this.sLength;
        }
        object = this.sText.substring(this.sOffset, n);
        this.sOffset = n + 1;
        if (symbol.LookupMacro(vector.size()) != null) {
            this.ReportError("redefinition of macro " + symbol.name);
        } else {
            new Macro(symbol, (String)object, vector);
        }
    }

    private void Scan(EditBuffer editBuffer, String string) {
        EditBuffer editBuffer2 = this.sBuffer;
        String string2 = this.sText;
        int n = this.sLength;
        int n2 = this.sOffset;
        boolean bl = false;
        this.sText = string;
        this.sLength = string.length();
        this.sOffset = 0;
        if (editBuffer != null) {
            this.sBuffer = editBuffer;
            this.sStart = 0;
            bl = true;
        }
        while (this.sOffset < this.sLength & !this.errors) {
            this.SkipBlanks();
            if (this.sOffset < this.sLength && (cinfo[this.sText.charAt(this.sOffset)] & 2) == 0) {
                Object object;
                int n3;
                this.SkipBlanks();
                int n4 = this.sOffset;
                this.SkipToken();
                String string3 = this.sText.substring(n4, this.sOffset);
                this.SkipBlanks();
                char c = this.sOffset < this.sLength ? this.sText.charAt(this.sOffset) : (char)'\u0000';
                if (string3.equals(".macro")) {
                    this.ReadMacro();
                    continue;
                }
                if (string3.equals(".include")) {
                    char c2;
                    n3 = this.sOffset;
                    while (this.sOffset < this.sLength && ((c2 = this.sText.charAt(this.sOffset)) == '.' || cinfo[c2] != 1 && cinfo[c2] != 2)) {
                        ++this.sOffset;
                    }
                    object = this.sText.substring(n3, this.sOffset);
                    if (((String)object).length() == 0) {
                        this.ReportError("expected filename following .include");
                        continue;
                    }
                    if (this.source != null) {
                        object = this.parent.MergePathnames(this.source, (String)object);
                    }
                    File file = new File((String)object);
                    try {
                        if (file.exists()) {
                            EditBuffer editBuffer3 = this.parent.FindBuffer(file);
                            this.Scan(editBuffer3, editBuffer3.getText());
                            continue;
                        }
                        this.ReportError("Can't read included file: " + file.getCanonicalPath() + " not found");
                    }
                    catch (Exception exception) {
                        this.ReportError("Can't read included file: " + exception);
                    }
                    continue;
                }
                if (string3.equals(".align")) {
                    n3 = 4;
                    if (cinfo[c] != 2 && (object = this.ReadExpression()) != null) {
                        n3 = (Integer)object;
                    }
                    while (this.dot.value % n3 != 0) {
                        this.AssembleByte(0);
                    }
                    continue;
                }
                if (string3.equals(".text")) {
                    this.AssembleString();
                    this.AssembleByte(0);
                    while (this.dot.value % 4 != 0) {
                        this.AssembleByte(0);
                    }
                    continue;
                }
                if (string3.equals(".ascii")) {
                    this.AssembleString();
                    continue;
                }
                if (string3.equals(".breakpoint")) {
                    if (this.pass != 2 || this.beta == null) continue;
                    this.beta.SetBreakpoint(this.dot.value);
                    continue;
                }
                if (string3.equals(".protect")) {
                    this.writeable = false;
                    continue;
                }
                if (string3.equals(".unprotect")) {
                    this.writeable = true;
                    continue;
                }
                if (string3.equals(".options")) {
                    while (true) {
                        this.SkipBlanks();
                        if ((cinfo[this.sText.charAt(this.sOffset)] & 2) != 0) break;
                        n4 = this.sOffset;
                        this.SkipToken();
                        String string4 = this.sText.substring(n4, this.sOffset);
                        if (string4.equals("plugh2536038")) {
                            this.outputChecksum = true;
                            continue;
                        }
                        if (string4.equals("dumpmemory")) {
                            this.dumpMemory = true;
                            continue;
                        }
                        if (this.pass != 2 || this.beta == null) continue;
                        this.beta.Option(string4);
                    }
                }
                if (string3.equals(".pcheckoff") || string3.equals(".tcheckoff")) {
                    this.checkoffServer = this.ReadString();
                    this.assignment = this.ReadString();
                    this.checkoffChecksum = this.ReadTerm();
                    this.checkoffType = string3;
                    continue;
                }
                if (string3.equals(".verify")) {
                    Vector<Integer> vector = new Vector<Integer>();
                    if (this.verifications != null) {
                        this.verifications.add(vector);
                    }
                    vector.add(this.ReadTerm());
                    object = this.ReadTerm();
                    for (int i = ((Integer)object).intValue(); i > 0; --i) {
                        vector.add(this.ReadTerm());
                    }
                    continue;
                }
                if (c == ':') {
                    ++this.sOffset;
                    Symbol symbol = Symbol.Lookup(this.symbols, string3, true);
                    if (this.pass == 1) {
                        if (symbol.type != 0) {
                            this.ReportError("multiply defined symbol: " + string3);
                            continue;
                        }
                        symbol.type = 2;
                        symbol.value = this.dot.value;
                        continue;
                    }
                    if (symbol.value != this.dot.value) {
                        this.ReportError("phase error in symbol definition: " + string3);
                    }
                    this.beta.DefineLabel(this.dot.value, symbol.name);
                    continue;
                }
                if (c == '=') {
                    ++this.sOffset;
                    Symbol symbol = Symbol.Lookup(this.symbols, string3, true);
                    this.usesDot = false;
                    object = this.ReadExpression();
                    if (object != null) {
                        if (symbol.type == 2) {
                            this.ReportError("illegal redefinition of symbol: " + string3);
                            continue;
                        }
                        symbol.type = 1;
                        symbol.value = (Integer)object;
                        if (symbol != this.dot || this.dot.value <= this.maxDot) continue;
                        this.maxDot = this.dot.value;
                        continue;
                    }
                }
                this.sOffset = n4;
                while (!this.errors && this.sOffset < this.sLength && (cinfo[this.sText.charAt(this.sOffset)] & 2) == 0) {
                    this.ReadOperand();
                    this.SkipBlanks();
                    if (this.sOffset >= this.sLength || this.sText.charAt(this.sOffset) != ',') continue;
                    ++this.sOffset;
                }
            }
            while (this.sOffset < this.sLength && this.sText.charAt(this.sOffset) != '\n') {
                ++this.sOffset;
            }
            ++this.sOffset;
            if (!bl) continue;
            this.sStart = this.sOffset;
        }
        this.sBuffer = editBuffer2;
        this.sText = string2;
        this.sLength = n;
        this.sOffset = n2;
    }

    public void Assemble(Beta beta) {
        this.beta = beta;
        this.symbols = new Hashtable();
        this.dot = new Symbol(this.symbols, ".", 0);
        this.errors = false;
        this.checkoffServer = null;
        this.outputChecksum = false;
        this.dumpMemory = false;
        this.pass = 1;
        this.InitializeMacros();
        this.dot.value = 0;
        this.maxDot = 0;
        this.verifications = null;
        this.Message("starting pass 1");
        this.Scan(this, this.getText());
        if (!this.errors) {
            if (beta != null) {
                beta.SetMemorySize(65536);
                beta.AssemblyStart();
            }
            this.pass = 2;
            this.InitializeMacros();
            this.dot.value = 0;
            this.maxDot = 0;
            this.writeable = true;
            this.verifications = new Vector();
            this.Message("starting pass 2");
            this.Scan(this, this.getText());
            if (beta != null) {
                beta.AssemblyFinish();
            }
        }
    }

    public int Size() {
        return this.dot != null ? this.dot.value : 0;
    }

    public String Checkoff() {
        if (this.beta == null || this.beta.cycles == 0L) {
            return "<font size=5>Oops...</font><p>Can't find any simulation results to verify... did you run assemble and run the program?";
        }
        if (this.dumpMemory) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream("checkoff_data"));
                int n = 0;
                int n2 = this.Size() >> 2;
                while (n2 > 0) {
                    printWriter.print(".verify 0x" + Integer.toHexString(n) + " 8");
                    int n3 = 1;
                    while (n3 <= 8) {
                        int n4 = this.beta.ReadMemory(n);
                        printWriter.print(" 0x" + Integer.toHexString(n4));
                        if (--n2 == 0) break;
                        ++n3;
                        n += 4;
                    }
                    printWriter.print("\n");
                }
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Memory data written to file checkoff_data";
        }
        if (this.checkoffServer == null) {
            return "<font size=5>Oops...</font><p>Can't find checkoff information... did you include the appropriate \"XXXcheckoff.uasm\" file which supplies the information needed to complete the checkoff?";
        }
        int n = this.checkoffChecksum;
        if (this.checkoffType.equals(".pcheckoff")) {
            int n5 = 36038;
            for (int i = this.verifications.size() - 1; i >= 0; --i) {
                Vector vector = (Vector)this.verifications.elementAt(i);
                int n6 = vector.size();
                int n7 = (Integer)vector.elementAt(0);
                int n8 = 1;
                while (n8 < n6) {
                    int n9;
                    int n10 = (Integer)vector.elementAt(n8);
                    if (n10 != (n9 = this.beta.ReadMemory(n7))) {
                        return "<font size=5>Verification error...</font><tt><ul><li>memory location: 0x" + Integer.toHexString(n7) + "<li>expected: 0x" + Integer.toHexString(n10) + "<li>actual: 0x" + Integer.toHexString(n9) + "</tt></ul>";
                    }
                    n5 += n8 * (n7 + n9);
                    ++n8;
                    n7 += 4;
                }
            }
            if (this.outputChecksum) {
                return "vChecksum=" + n5 + "\n";
            }
            if (n != 0 && n5 != n) {
                return "<font size=5>Verification error...</font><p>It appears that the checkoff information has been modified in some way.  Please verify that you are using the official checkoff file; contact 6004-labs@6004.lcs.mit.edu if you can't resolve the problem.";
            }
        } else if (this.checkoffType.equals(".tcheckoff")) {
            int n11 = this.beta.ttyChecksum();
            if (this.outputChecksum) {
                return "vChecksum=" + n11 + "\n";
            }
            if (n != 0 && n11 != n) {
                return "<font size=5>Verification error...</font><p>The test program did not type out the expected results.  Please check the lab writeup to see what type out is expected.";
            }
        }
        return null;
    }

    public void DumpSymbols() {
        if (this.symbols != null) {
            Enumeration enumeration = this.symbols.elements();
            while (enumeration.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration.nextElement();
                System.out.println(symbol);
                Enumeration enumeration2 = symbol.mdefs.elements();
                while (enumeration2.hasMoreElements()) {
                    Macro macro = (Macro)enumeration2.nextElement();
                    System.out.println(macro);
                }
            }
        }
    }
}

