/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EditPanel;
import gui.GuiFrame;
import gui.POSTStream;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditBuffer
extends EditPanel
implements ActionListener,
DocumentListener {
    public File source;
    public String original;
    public String tempdir;
    public String title;
    public boolean dirty;
    public boolean errors;
    public JTextArea text;
    public JScrollPane scroll;

    public EditBuffer(GuiFrame guiFrame, File file, boolean bl) {
        super(guiFrame);
        this.Init(file, bl);
    }

    public EditBuffer(GuiFrame guiFrame, File file) {
        super(guiFrame);
        this.Init(file, true);
    }

    void Init(File file, boolean bl) {
        this.text = new JTextArea();
        String string = this.parent.GetParameter("font");
        Font font = string != null ? Font.decode(string) : new Font("Courier", 0, 12);
        this.text.setFont(font);
        this.scroll = new JScrollPane(this.text);
        this.add((Component)this.scroll, "Center");
        if (bl) {
            this.ReadSource(file);
        } else {
            this.source = file;
            this.setText("");
        }
        this.text.getDocument().addDocumentListener(this);
    }

    public String Source() {
        return this.source == null ? "untitled" : this.source.toString();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String string) {
        this.original = string;
        this.text.setText(this.original);
        this.MakeClean();
    }

    public String toString() {
        return "EditBuffer@" + this.source;
    }

    public void addObserver(Observer observer) {
        this.observers.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observers.deleteObserver(observer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void CleanUp() {
    }

    public void ReadSource(File file) {
        InputStream inputStream;
        this.original = "";
        this.text.setText(this.original);
        if (file == null) {
            return;
        }
        this.source = file;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            this.parent.ErrorMessage("Cannot open " + file);
            return;
        }
        inputStream = new BufferedInputStream(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                this.parent.ErrorMessage("IO exception reading file: " + iOException);
                break;
            }
            if (n == 13) continue;
            if (n < 0) break;
            stringBuffer.append((char)n);
        }
        this.setText(stringBuffer.toString());
    }

    public boolean CompareFile(File file) {
        if (this.source == null) {
            return false;
        }
        try {
            String string = this.source.getCanonicalPath();
            String string2 = file.getCanonicalPath();
            return string.equals(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void Reload() {
        this.ReadSource(this.source);
    }

    public void Capture(PrintWriter printWriter) {
        printWriter.println("============== source: " + this.ToolTip());
        printWriter.print(this.text.getText());
        printWriter.println("==============");
    }

    public void Capture(POSTStream pOSTStream) {
        try {
            pOSTStream.write("============== source: ");
            pOSTStream.write(this.ToolTip());
            pOSTStream.write(10);
            pOSTStream.write(this.text.getText());
            pOSTStream.write("==============\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean SaveBuffer() {
        Object object;
        boolean bl = false;
        File file = new File(this.source.getParent(), "jsimtemp");
        try {
            object = new FileOutputStream(file);
            object = new BufferedOutputStream((OutputStream)object, 1024);
            PrintWriter printWriter = new PrintWriter((OutputStream)object);
            this.original = this.text.getText();
            printWriter.print(this.original);
            printWriter.close();
        }
        catch (IOException iOException) {
            bl = true;
            System.out.println("Exception during save: " + iOException);
            this.parent.ErrorDialog("Could not save " + this.source + ".\nFile may not be writeable. You might try saving with a different filename.");
        }
        catch (Exception exception) {
            bl = true;
            this.parent.ErrorMessage("Could not save library " + this.source + ": " + exception);
            Thread.dumpStack();
        }
        if (!bl) {
            try {
                if (this.source.exists()) {
                    object = new File(this.source.getAbsolutePath() + ".bak");
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    this.source.renameTo((File)object);
                }
                file.renameTo(this.source);
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl) {
            this.parent.ErrorDialog("Internal error while saving " + this.source);
            file.delete();
        } else {
            this.MakeClean();
        }
        return !bl;
    }

    public void Rename() {
        this.parent.RenameTab(this, this.TabName(), null);
    }

    public void Save(File file) {
        if (this.dirty) {
            File file2 = this.source;
            if (file != null) {
                this.source = file;
            } else if (this.source == null) {
                this.source = this.parent.GetFile(1);
                if (this.source == null) {
                    return;
                }
            }
            if (this.SaveBuffer()) {
                this.Rename();
            } else {
                this.source = file2;
            }
        }
    }

    public void SaveAs() {
        File file = this.source;
        this.source = this.parent.GetFile(1);
        if (this.source == null) {
            return;
        }
        if (this.SaveBuffer()) {
            this.Rename();
        } else {
            this.source = file;
        }
    }

    protected void MakeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.Rename();
        }
    }

    protected void Changed() {
    }

    void MakeClean() {
        if (this.dirty) {
            this.dirty = false;
            this.Rename();
        }
    }

    public String TabName() {
        String string;
        String string2 = string = this.source != null ? this.source.getName() : "untitled";
        if (this.dirty) {
            string = string + "*";
        }
        return string;
    }

    public String ToolTip() {
        return this.source != null ? this.source.getAbsolutePath() : "untitled";
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.Changed();
        if (!this.dirty && !this.original.equals(this.text.getText())) {
            this.MakeDirty();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.Changed();
        if (!this.dirty && !this.original.equals(this.text.getText())) {
            this.MakeDirty();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.Changed();
        if (!this.dirty && !this.original.equals(this.text.getText())) {
            this.MakeDirty();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.requestFocus();
        }
    }

    public void Message(EditBuffer editBuffer, int n, int n2, String string) {
        this.parent.toFront();
        this.parent.SetTab(editBuffer);
        this.parent.Message(string);
        try {
            editBuffer.text.select(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        editBuffer.text.requestFocus();
    }

    public void Error(EditBuffer editBuffer, int n, String string) {
        this.errors = true;
        this.Message(editBuffer, n, n, string);
    }
}

