/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EditCanvas;
import gui.EditPanel;
import gui.GuiFrame;
import gui.Transform;
import gui.UI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;

public class EditFrame
extends EditPanel
implements ActionListener,
AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public EditCanvas canvas;
    public JToolBar bbar = new JToolBar();
    JScrollBar vbar;
    JScrollBar hbar;
    JButton b1;
    JButton b2;
    JButton b3;
    public int mx = 0;
    public int my = 0;
    public static final double ZOOM_FACTOR = 1.5;

    public EditFrame(GuiFrame guiFrame) {
        super(guiFrame);
        this.bbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.add("North", this.bbar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add("Center", jPanel);
        this.canvas = new EditCanvas(this);
        this.canvas.setBorder(BorderFactory.createLoweredBevelBorder());
        this.vbar = new JScrollBar(1);
        this.vbar.setBackground(UI.BGCOLOR);
        this.vbar.addAdjustmentListener(this);
        this.hbar = new JScrollBar(0);
        this.hbar.addAdjustmentListener(this);
        this.hbar.setBackground(UI.BGCOLOR);
        Dimension dimension = new Dimension(16, 16);
        this.b1 = guiFrame.ImageButton("/icons/zoomin.gif");
        this.b1.setToolTipText("Zoom in");
        this.b1.addActionListener(this);
        this.b1.setPreferredSize(dimension);
        this.b2 = guiFrame.ImageButton("/icons/zoomout.gif");
        this.b2.setToolTipText("Zoom out");
        this.b2.addActionListener(this);
        this.b2.setPreferredSize(dimension);
        this.b3 = guiFrame.ImageButton("/icons/zoom.gif");
        this.b3.setToolTipText("Surround");
        this.b3.addActionListener(this);
        this.b3.setPreferredSize(dimension);
        jPanel.add("East", this.vbar);
        jPanel.add("Center", this.canvas);
        JPanel jPanel2 = new JPanel();
        jPanel.add("South", jPanel2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.b1, gridBagConstraints);
        jPanel2.add(this.b1);
        gridBagLayout.setConstraints(this.b2, gridBagConstraints);
        jPanel2.add(this.b2);
        gridBagLayout.setConstraints(this.b3, gridBagConstraints);
        jPanel2.add(this.b3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.hbar, gridBagConstraints);
        jPanel2.add(this.hbar);
    }

    public void DrawContents(Graphics graphics, Transform transform, Rectangle rectangle) {
    }

    public void MarkModified() {
        this.observers.notifyObservers(this);
    }

    public void Activate(boolean bl) {
        this.canvas.Activate(bl);
        this.hbar.setEnabled(bl);
        this.vbar.setEnabled(bl);
        this.b1.setEnabled(bl);
        this.b2.setEnabled(bl);
        this.b3.setEnabled(bl);
    }

    public void Surround() {
        this.canvas.Surround(0, 0, 0, 0);
    }

    public void SetupScrollbars() {
        this.SetupScrollbars(0, 0, 0, 0);
    }

    public void SetupScrollbars(int n, int n2, int n3, int n4) {
        Dimension dimension = this.canvas.getSize();
        Transform transform = this.canvas.viewTransform;
        int n5 = n3 >> 1;
        int n6 = (int)((double)dimension.width / transform.scale);
        int n7 = n + n3 + n5;
        this.hbar.setValues((int)(-transform.orgx / transform.scale), n6, n - n5, n7);
        this.hbar.setBlockIncrement(n6);
        int n8 = this.canvas.grid < n6 ? this.canvas.grid : n6;
        this.hbar.setUnitIncrement(n8);
        n5 = n4 >> 1;
        n6 = (int)((double)dimension.height / transform.scale);
        n7 = n2 + n4 + n5;
        this.vbar.setValues((int)(-transform.orgy / transform.scale), n6, n2 - n5, n7);
        this.vbar.setBlockIncrement(n6);
        this.vbar.setUnitIncrement(n8);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
        int n = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
        int n2 = (int)(-this.canvas.GetScale() * (double)Math.min(n, adjustmentEvent.getValue()));
        if (jScrollBar == this.hbar) {
            this.canvas.SetOriginX(n2);
        } else {
            this.canvas.SetOriginY(n2);
        }
        this.canvas.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (this.b1 == object) {
            this.canvas.SetScale(this.canvas.GetScale() * 1.5);
        } else if (this.b2 == object) {
            this.canvas.SetScale(this.canvas.GetScale() / 1.5);
        } else if (this.b3 == object) {
            this.Surround();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.canvas.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.canvas.X(this.mx);
        int n2 = this.canvas.Y(this.my);
        switch (keyEvent.getKeyChar()) {
            case 'Z': {
                this.canvas.Zoom(this.mx, this.my, n, n2, this.canvas.GetScale() * 1.5);
                break;
            }
            case 'z': {
                this.canvas.Zoom(this.mx, this.my, n, n2, this.canvas.GetScale() / 1.5);
                break;
            }
            case 'c': {
                this.canvas.Recenter(n, n2, this.canvas.GetScale());
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

