/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.UI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;
import javax.swing.JComboBox;

public class Transform {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int RNORTH = 4;
    public static final int REAST = 5;
    public static final int RSOUTH = 6;
    public static final int RWEST = 7;
    public static final int ROTATE = 0;
    public static final int MIRRORX = 1;
    public static final int MIRRORY = 2;
    public static final int RECTANGLE = 0;
    public static final int ROUND_RECT = 1;
    public static final int OVAL = 2;
    public static final int FILLED_RECTANGLE = 3;
    public static final int FILLED_ROUND_RECT = 4;
    public static final int FILLED_OVAL = 5;
    public static final int BOLD_RECTANGLE = 6;
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER_LEFT = 3;
    public static final int CENTER = 4;
    public static final int CENTER_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final String S_TOP_LEFT = "top-left";
    public static final String S_TOP_CENTER = "top-center";
    public static final String S_TOP_RIGHT = "top-right";
    public static final String S_CENTER_LEFT = "center-left";
    public static final String S_CENTER = "center-center";
    public static final String S_CENTER_RIGHT = "center-right";
    public static final String S_BOTTOM_LEFT = "bottom-left";
    public static final String S_BOTTOM_CENTER = "bottom-center";
    public static final String S_BOTTOM_RIGHT = "bottom-right";
    public static int[] aOrient = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 2, 5, 8, 1, 4, 7, 0, 3, 6, 8, 7, 6, 5, 4, 3, 2, 1, 0, 6, 3, 0, 7, 4, 1, 8, 5, 3, 2, 1, 0, 5, 4, 3, 8, 7, 6, 8, 5, 2, 7, 4, 2, 6, 3, 0, 6, 7, 8, 3, 4, 5, 0, 1, 2, 0, 3, 6, 1, 4, 7, 2, 5, 8};
    private static int[] orient = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 0, 7, 4, 5, 6, 2, 3, 0, 1, 6, 7, 4, 5, 3, 0, 1, 2, 5, 6, 7, 4, 4, 5, 6, 7, 0, 1, 2, 3, 5, 6, 7, 4, 3, 0, 1, 2, 6, 7, 4, 5, 2, 3, 0, 1, 7, 4, 5, 6, 1, 2, 3, 0};
    private static int[] qOrient = new int[]{0, 1, 2, 3, 3, 0, 1, 2, 2, 3, 0, 1, 1, 2, 3, 0, 1, 0, 3, 2, 0, 3, 2, 1, 3, 2, 1, 0, 2, 1, 0, 3};
    public double orgx;
    public double orgy;
    public int rot;
    public double scale;

    public Transform() {
        this.orgx = 0.0;
        this.orgy = 0.0;
        this.rot = 0;
        this.scale = 1.0;
    }

    public Transform(int n, int n2, int n3, double d) {
        this.orgx = n;
        this.orgy = n2;
        this.rot = n3;
        this.scale = d;
    }

    public Transform(Transform transform) {
        this.SetParams(transform);
    }

    public void SetParams(Transform transform) {
        this.orgx = transform.orgx;
        this.orgy = transform.orgy;
        this.rot = transform.rot;
        this.scale = transform.scale;
    }

    public void SetParams(int n, int n2, int n3, double d) {
        this.orgx = n;
        this.orgy = n2;
        this.rot = n3;
        this.scale = d;
    }

    double RealTransformX(double d, double d2) {
        double d3;
        switch (this.rot) {
            default: {
                d3 = d;
                break;
            }
            case 1: {
                d3 = -d2;
                break;
            }
            case 2: {
                d3 = -d;
                break;
            }
            case 3: {
                d3 = d2;
                break;
            }
            case 4: {
                d3 = -d;
                break;
            }
            case 5: {
                d3 = -d2;
                break;
            }
            case 6: {
                d3 = d;
                break;
            }
            case 7: {
                d3 = d2;
            }
        }
        return d3 * this.scale + this.orgx;
    }

    double RealTransformY(double d, double d2) {
        double d3;
        switch (this.rot) {
            default: {
                d3 = d2;
                break;
            }
            case 1: {
                d3 = d;
                break;
            }
            case 2: {
                d3 = -d2;
                break;
            }
            case 3: {
                d3 = -d;
                break;
            }
            case 4: {
                d3 = d2;
                break;
            }
            case 5: {
                d3 = -d;
                break;
            }
            case 6: {
                d3 = -d2;
                break;
            }
            case 7: {
                d3 = d;
            }
        }
        return d3 * this.scale + this.orgy;
    }

    public int TransformX(int n, int n2) {
        return (int)Math.round(this.RealTransformX(n, n2));
    }

    public int TransformY(int n, int n2) {
        return (int)Math.round(this.RealTransformY(n, n2));
    }

    public int TransformRot(int n) {
        return orient[n * 8 + this.rot];
    }

    public int TransformAlignment(int n) {
        return aOrient[this.rot * 9 + n];
    }

    public int TransformQuadrant(int n) {
        return qOrient[this.rot * 4 + n];
    }

    public double RealInverseTransformX(int n, int n2) {
        double d = ((double)n - this.orgx) / this.scale;
        double d2 = ((double)n2 - this.orgy) / this.scale;
        switch (this.rot) {
            default: {
                break;
            }
            case 1: {
                d = d2;
                break;
            }
            case 2: {
                d = -d;
                break;
            }
            case 3: {
                d = -d2;
                break;
            }
            case 4: {
                d = -d;
                break;
            }
            case 5: {
                d = -d2;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                d = d2;
            }
        }
        return d;
    }

    public double RealInverseTransformY(int n, int n2) {
        double d = ((double)n - this.orgx) / this.scale;
        double d2 = ((double)n2 - this.orgy) / this.scale;
        switch (this.rot) {
            default: {
                break;
            }
            case 1: {
                d2 = -d;
                break;
            }
            case 2: {
                d2 = -d2;
                break;
            }
            case 3: {
                d2 = d;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                d2 = -d;
                break;
            }
            case 6: {
                d2 = -d2;
                break;
            }
            case 7: {
                d2 = d;
            }
        }
        return d2;
    }

    public int InverseTransformX(int n, int n2) {
        return (int)Math.round(this.RealInverseTransformX(n, n2));
    }

    public int InverseTransformY(int n, int n2) {
        return (int)Math.round(this.RealInverseTransformY(n, n2));
    }

    public Rectangle TransformRectangle(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        this.TransformRectangle(rectangle, rectangle2);
        return rectangle2;
    }

    public void TransformRectangle(Rectangle rectangle, Rectangle rectangle2) {
        int n = this.TransformX(rectangle.x, rectangle.y);
        int n2 = this.TransformY(rectangle.x, rectangle.y);
        int n3 = this.TransformX(rectangle.x + rectangle.width, rectangle.y + rectangle.height) - n;
        int n4 = this.TransformY(rectangle.x + rectangle.width, rectangle.y + rectangle.height) - n2;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= n4;
        }
        rectangle2.x = n;
        rectangle2.y = n2;
        rectangle2.width = n3;
        rectangle2.height = n4;
    }

    public Rectangle InverseTransformRectangle(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        this.InverseTransformRectangle(rectangle, rectangle2);
        return rectangle2;
    }

    public void InverseTransformRectangle(Rectangle rectangle, Rectangle rectangle2) {
        int n = this.InverseTransformX(rectangle.x, rectangle.y);
        int n2 = this.InverseTransformY(rectangle.x, rectangle.y);
        int n3 = this.InverseTransformX(rectangle.x + rectangle.width, rectangle.y + rectangle.height) - n;
        int n4 = this.InverseTransformY(rectangle.x + rectangle.width, rectangle.y + rectangle.height) - n2;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= n4;
        }
        rectangle2.x = n;
        rectangle2.y = n2;
        rectangle2.width = n3;
        rectangle2.height = n4;
    }

    public void Compose(Transform transform) {
        if (transform != null) {
            double d = transform.RealTransformX(this.orgx, this.orgy);
            double d2 = transform.RealTransformY(this.orgx, this.orgy);
            this.orgx = d;
            this.orgy = d2;
            this.rot = transform.TransformRot(this.rot);
            this.scale *= transform.scale;
        }
    }

    public void Debug() {
        System.out.println("orgx=" + this.orgx + " orgyy=" + this.orgy + " rot=" + this.rot + " scale=" + this.scale);
    }

    public void DrawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.TransformX(n, n2);
        int n6 = this.TransformY(n, n2);
        int n7 = this.TransformX(n3, n4);
        int n8 = this.TransformY(n3, n4);
        graphics.drawLine(n5, n6, n7, n8);
    }

    public void DrawGridPoint(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = this.TransformX(n, n2);
        int n5 = this.TransformY(n, n2);
        int n6 = (int)Math.floor((double)n3 * this.scale / 32.0);
        if (bl) {
            n6 = Math.max(2, n6);
            graphics.drawOval(n4 - n6, n5 - n6, 2 * n6, 2 * n6);
        } else {
            graphics.drawLine(n4 - n6, n5, n4 + n6, n5);
            if (n6 > 0) {
                graphics.drawLine(n4, n5 - n6, n4, n5 + n6);
            }
        }
    }

    public void DebugLine(int n, int n2, int n3, int n4) {
        int n5 = this.TransformX(n, n2);
        int n6 = this.TransformY(n, n2);
        int n7 = this.TransformX(n3, n4);
        int n8 = this.TransformY(n3, n4);
        System.out.println("(" + n5 + "," + n6 + ") to (" + n7 + "," + n8 + ")");
    }

    public void DrawRectShape(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.TransformX(n2, n3);
        int n7 = this.TransformY(n2, n3);
        int n8 = this.TransformX(n2 + n4, n3 + n5) - n6;
        int n9 = this.TransformY(n2 + n4, n3 + n5) - n7;
        if (n8 < 0) {
            n8 = -n8;
            n6 -= n8;
        }
        if (n9 < 0) {
            n9 = -n9;
            n7 -= n9;
        }
        if (n4 == n5) {
            n9 = n8;
        }
        switch (n) {
            case 3: {
                graphics.fillRect(n6, n7, n8 + 1, n9 + 1);
                break;
            }
            case 0: {
                graphics.drawRect(n6, n7, n8, n9);
                break;
            }
            case 6: {
                graphics.drawRect(n6, n7, n8, n9);
                graphics.drawRect(n6 + 1, n7 + 1, n8 - 2, n9 - 2);
                break;
            }
            case 4: {
                graphics.fillRoundRect(n6, n7, n8 + 1, n9 + 1, 20, 20);
                break;
            }
            case 1: {
                graphics.drawRoundRect(n6, n7, n8, n9, 20, 20);
                break;
            }
            case 5: {
                graphics.fillOval(n6, n7, n8 + 1, n9 + 1);
                break;
            }
            case 2: {
                graphics.drawOval(n6, n7, n8, n9);
            }
        }
    }

    public void DebugRectShape(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.TransformX(n2, n3);
        int n7 = this.TransformY(n2, n3);
        int n8 = this.TransformX(n2 + n4, n3 + n5) - n6;
        int n9 = this.TransformY(n2 + n4, n3 + n5) - n7;
        if (n8 < 0) {
            n8 = -n8;
            n6 -= n8;
        }
        if (n9 < 0) {
            n9 = -n9;
            n7 -= n9;
        }
        System.out.println("(" + n6 + "," + n7 + ") w=" + n8 + ", h=" + n7);
    }

    public void DrawQuadrant(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.TransformX(n2, n3);
        int n7 = this.TransformY(n2, n3);
        int n8 = this.TransformX(n2 + n4, n3 + n5) - n6;
        int n9 = this.TransformY(n2 + n4, n3 + n5) - n7;
        if (n8 < 0) {
            n8 = -n8;
            n6 -= n8;
        }
        if (n9 < 0) {
            n9 = -n9;
            n7 -= n9;
        }
        int n10 = n8 + n8;
        int n11 = n9 + n9;
        switch (qOrient[this.rot * 4 + n]) {
            case 0: {
                graphics.drawArc(n6 - n8, n7, n10, n11, 0, 90);
                break;
            }
            case 1: {
                graphics.drawArc(n6, n7, n10, n11, 90, 90);
                break;
            }
            case 2: {
                graphics.drawArc(n6, n7 - n9, n10, n11, 180, 90);
                break;
            }
            case 3: {
                graphics.drawArc(n6 - n8, n7 - n9, n10, n11, 270, 90);
            }
        }
    }

    public static Dimension TextSize(FontMetrics fontMetrics, String string) {
        if (string == null) {
            return new Dimension(0, 0);
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Transform.TextSize(fontMetrics, cArray);
    }

    public static Dimension TextSize(FontMetrics fontMetrics, char[] cArray) {
        Dimension dimension = new Dimension(0, 0);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (cArray != null) {
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                while (i < n2 && cArray[i] != '\n') {
                    ++i;
                }
                dimension.width = Math.max(dimension.width, fontMetrics.charsWidth(cArray, n3, i - n3));
                dimension.height += n;
            }
        }
        return dimension;
    }

    public void DrawText(Graphics graphics, int n, int n2, String string, String string2, int n3, int n4) {
        if (string == null) {
            return;
        }
        if ((n3 = (int)(this.scale * (double)n3)) < 1) {
            n3 = 1;
        }
        Font font = Font.decode(string2 + n3);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n5 = string.length();
        char[] cArray = new char[n5];
        string.getChars(0, n5, cArray, 0);
        Dimension dimension = Transform.TextSize(fontMetrics, cArray);
        int n6 = dimension.width;
        int n7 = dimension.height;
        int n8 = this.TransformX(n, n2);
        int n9 = this.TransformY(n, n2);
        int n10 = this.TransformAlignment(n4);
        int n11 = n6 >> 1;
        int n12 = n7 >> 1;
        switch (n10) {
            case 1: {
                n8 -= n11;
                break;
            }
            case 2: {
                n8 -= n6;
                break;
            }
            case 3: {
                n9 -= n12;
                break;
            }
            case 4: {
                n8 -= n11;
                n9 -= n12;
                break;
            }
            case 5: {
                n8 -= n6;
                n9 -= n12;
                break;
            }
            case 6: {
                n9 -= n7;
                break;
            }
            case 7: {
                n8 -= n11;
                n9 -= n7;
                break;
            }
            case 8: {
                n8 -= n6;
                n9 -= n7;
            }
        }
        graphics.setFont(font);
        int n13 = fontMetrics.getAscent() + fontMetrics.getDescent();
        n9 += fontMetrics.getAscent();
        for (int i = 0; i < n5; ++i) {
            int n14 = i;
            while (i < n5 && cArray[i] != '\n') {
                ++i;
            }
            graphics.drawChars(cArray, n14, i - n14, n8, n9);
            n9 += n13;
        }
    }

    public String toString() {
        return "<" + this.orgx + "," + this.orgy + "," + this.rot + "," + this.scale + ">";
    }

    public void Print(PrintWriter printWriter) {
        UI.PrintNumber(printWriter, (int)this.orgx);
        UI.PrintNumber(printWriter, (int)this.orgy);
        UI.PrintNumber(printWriter, this.rot);
    }

    public static JComboBox ChooseAlignment(int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(S_TOP_LEFT);
        jComboBox.addItem(S_TOP_CENTER);
        jComboBox.addItem(S_TOP_RIGHT);
        jComboBox.addItem(S_CENTER_LEFT);
        jComboBox.addItem(S_CENTER);
        jComboBox.addItem(S_CENTER_RIGHT);
        jComboBox.addItem(S_BOTTOM_LEFT);
        jComboBox.addItem(S_BOTTOM_CENTER);
        jComboBox.addItem(S_BOTTOM_RIGHT);
        jComboBox.setSelectedIndex(n);
        return jComboBox;
    }
}

