/*
 * Decompiled with CFR 0.152.
 */
package bsim;

import bsim.Beta;
import gui.VramPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class Memory
extends JFrame
implements ActionListener {
    public static final int MAX_MEMORY_SIZE = 0x400000;
    public static final int LRU = 0;
    public static final int FIFO = 1;
    public static final int RANDOM = 2;
    public static final int CYCLE = 3;
    public static final int readCycleCount = 4;
    public static final int writeCycleCount = 4;
    public static final String[] cache_labels = new String[]{"off", "on"};
    public static final String[] lineSize_labels = new String[]{"1", "2", "4", "8", "16", "32"};
    public static final String[] totalLines_labels = new String[]{"1", "2", "4", "8", "16", "32", "64", "128", "256", "512", "1024", "2048", "4096"};
    public static final String[] nWays_labels = new String[]{"direct mapped", "2-way", "4-way", "8-way", "fully associative"};
    public static final String[] replacementStrategy_labels = new String[]{"LRU", "FIFO", "Random", "Cycle"};
    public static final String[] writeBack_labels = new String[]{"write-through", "write-back"};
    int[] memory;
    int memMask;
    boolean cache;
    public boolean anyDirty;
    int lineSize;
    int totalLines;
    int nWays;
    int replacementStrategy;
    boolean writeBack;
    int rWay;
    int nLines;
    int lineShift;
    int lineMask;
    int tagShift;
    int tagMask;
    boolean[] dirty;
    boolean[] valid;
    int[] tag;
    long[] age;
    Random random;
    long cycles;
    long readHits;
    long readMisses;
    long writeHits;
    long writeMisses;
    long dirtyReplacements;
    long validReplacements;
    long totalReplacements;
    Beta parent;
    JToolBar bbar;
    JComboBox ctl_cache;
    JComboBox ctl_lineSize;
    JComboBox ctl_totalLines;
    JComboBox ctl_nWays;
    JComboBox ctl_replacementStrategy;
    JComboBox ctl_writeBack;
    int toffset;
    JTable stat_address;
    JTable stat_perf;
    JTable stat_cost;
    JTextArea message;
    public int uid;
    public boolean hascontent = false;
    static int uuid = 1;
    public VramPanel inspector;

    public Memory(Beta beta) {
        super("Cache information");
        this.parent = beta;
        this.uid = uuid++;
        this.SetMemorySize(2);
        this.cache = false;
        this.lineSize = 1;
        this.totalLines = 1;
        this.nWays = 1;
        this.replacementStrategy = 0;
        this.writeBack = false;
        this.random = new Random();
        this.Reset(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder("Cache parameters"));
        this.ctl_cache = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Cache", cache_labels);
        this.ctl_lineSize = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Words/line", lineSize_labels);
        this.ctl_totalLines = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Total lines", totalLines_labels);
        this.ctl_nWays = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Associativity", nWays_labels);
        this.ctl_replacementStrategy = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Replacement strategy", replacementStrategy_labels);
        this.ctl_writeBack = this.SetupControl(jPanel, gridBagLayout, gridBagConstraints, "Write strategy", writeBack_labels);
        gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Cache statistics"));
        this.toffset = 1;
        Object[] objectArray = new String[]{"field", "# of bits"};
        Object[][] objectArray2 = new Object[][]{{"field", "# of bits"}, {"tag", ""}, {"cache index", ""}, {"data select", ""}};
        this.stat_address = new JTable(objectArray2, objectArray);
        this.SetupReadout(jPanel2, gridBagLayout, gridBagConstraints, "Address", this.stat_address);
        Object[] objectArray3 = new String[]{"item", "#", "cost"};
        Object[][] objectArray4 = new Object[][]{{"item", "#", "cost"}, {"SRAM", "", ""}, {"comparator bits", "", ""}, {"2-to-1 mux bits", "", ""}, {"TOTAL COST", "", ""}};
        this.stat_cost = new JTable(objectArray4, objectArray3);
        this.stat_cost.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.SetupReadout(jPanel2, gridBagLayout, gridBagConstraints, "Cost", this.stat_cost);
        Object[] objectArray5 = new String[]{"event", "read", "write", "total"};
        Object[][] objectArray6 = new Object[][]{{"event", "read", "write", "total"}, {"hits", "", "", ""}, {"misses", "", "", ""}, {"total", "", "", ""}, {"hit %", "", "", ""}, {"cycles", "", "", ""}};
        this.stat_perf = new JTable(objectArray6, objectArray5);
        this.SetupReadout(jPanel2, gridBagLayout, gridBagConstraints, "Performance", this.stat_perf);
        this.ProcessCacheParameters();
        Container container = this.getContentPane();
        this.message = new JTextArea(2, 10);
        this.message.setEditable(false);
        this.message.setHighlighter(null);
        this.message.setBackground(Color.white);
        this.message.setBorder(BorderFactory.createLoweredBevelBorder());
        container.setLayout(new BorderLayout());
        this.bbar = new JToolBar();
        this.bbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        container.add((Component)this.bbar, "North");
        container.add((Component)jPanel, "West");
        container.add((Component)jPanel2, "Center");
        container.add((Component)this.message, "South");
        this.pack();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width, dimension.height + 10);
    }

    private JComboBox SetupControl(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, String[] stringArray) {
        JLabel jLabel = new JLabel(string + ":");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        jPanel.add(jComboBox);
        return jComboBox;
    }

    private void SetupReadout(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(string + ":");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jComponent.setBorder(BorderFactory.createEtchedBorder(1, Color.white, Color.black));
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
    }

    public JButton AddToolButton(JButton jButton, String string, ActionListener actionListener) {
        jButton.setToolTipText(string);
        jButton.setActionCommand(string);
        jButton.addActionListener(actionListener);
        this.bbar.add(jButton);
        return jButton;
    }

    public void AddToolSeparator() {
        this.bbar.addSeparator();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ctl_cache) {
            this.cache = this.ctl_cache.getSelectedIndex() == 1;
        } else if (object == this.ctl_lineSize) {
            try {
                this.lineSize = Integer.parseInt((String)this.ctl_lineSize.getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.ctl_totalLines) {
            try {
                this.totalLines = Integer.parseInt((String)this.ctl_totalLines.getSelectedItem());
                if (this.ctl_nWays.getSelectedIndex() == 4) {
                    this.nWays = this.totalLines;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.ctl_nWays) {
            switch (this.ctl_nWays.getSelectedIndex()) {
                case 0: {
                    this.nWays = 1;
                    break;
                }
                case 1: {
                    this.nWays = 2;
                    break;
                }
                case 2: {
                    this.nWays = 4;
                    break;
                }
                case 3: {
                    this.nWays = 8;
                    break;
                }
                case 4: {
                    this.nWays = this.totalLines;
                }
            }
        } else if (object == this.ctl_replacementStrategy) {
            this.replacementStrategy = this.ctl_replacementStrategy.getSelectedIndex();
        } else if (object == this.ctl_writeBack) {
            this.writeBack = this.ctl_writeBack.getSelectedIndex() == 1;
        } else {
            return;
        }
        this.ProcessCacheParameters();
    }

    public static int Log2(int n) {
        int n2 = 0;
        for (int i = 1; n2 < 32 && i < n; i <<= 1, ++n2) {
        }
        return n2;
    }

    public static int Mask(int n) {
        int n2 = Memory.Log2(n);
        if (n2 == 32) {
            return -1;
        }
        return (1 << n2) - 1;
    }

    public int SetMemorySize(int n) {
        int n2;
        for (n2 = 2; n2 < 0x400000 && n2 < n; n2 *= 2) {
        }
        this.memory = new int[n2];
        System.err.println("memory size set to " + n2);
        this.memMask = Memory.Mask(n2 - 1);
        return n2;
    }

    public int Size() {
        return this.memory.length;
    }

    public boolean ValidAddress(int n) {
        return n < this.memory.length << 2;
    }

    public int Index(int n) {
        return n >>> 2 & this.memMask;
    }

    public int[] Copy() {
        int[] nArray = new int[this.memory.length];
        for (int i = 0; i < this.memory.length; ++i) {
            nArray[i] = this.memory[i];
        }
        return nArray;
    }

    public void Reset(int[] nArray) {
        int n;
        for (n = 0; n < this.memory.length; ++n) {
            this.memory[n] = 0;
        }
        if (nArray != null) {
            n = Math.max(nArray.length, this.memory.length);
            for (int i = 0; i < n; ++i) {
                this.memory[i] = nArray[i];
            }
            this.hascontent = true;
            this.inspector.Link(this.parent);
        }
        System.err.println("M" + this.uid + " reset with " + (nArray != null ? Integer.valueOf(nArray.length) : "no") + " words");
        this.CacheReset();
        this.anyDirty = true;
    }

    public int WriteWord(int n, int n2) {
        this.anyDirty = true;
        int n3 = this.Index(n);
        if (n3 < this.memory.length) {
            this.memory[n3] = n2;
            return n3;
        }
        return -1;
    }

    public int WriteByte(int n, int n2) {
        this.anyDirty = true;
        int n3 = this.Index(n);
        if (n3 < this.memory.length) {
            n2 &= 0xFF;
            switch (n & 3) {
                case 0: {
                    this.memory[n3] = this.memory[n3] & 0xFFFFFF00 | n2;
                    break;
                }
                case 1: {
                    this.memory[n3] = this.memory[n3] & 0xFFFF00FF | n2 << 8;
                    break;
                }
                case 2: {
                    this.memory[n3] = this.memory[n3] & 0xFF00FFFF | n2 << 16;
                    break;
                }
                case 3: {
                    this.memory[n3] = this.memory[n3] & 0xFFFFFF | n2 << 24;
                }
            }
            return n3;
        }
        return -1;
    }

    public int ReadLine(int[] nArray, int n) {
        if ((n /= 4) == 0) {
            System.err.println("reading out of M" + this.uid);
        }
        for (int i = 0; i < 8; ++i) {
            nArray[i] = this.memory[n + i];
        }
        return (n + 8) * 4;
    }

    public int ReadWord(int n) {
        int n2 = this.Index(n);
        return n2 < this.memory.length ? this.memory[n2] : 0;
    }

    public int ReadByte(int n) {
        return this.ReadWord(n) >> 8 * (n & 3) & 0xFF;
    }

    private String Percent(long l, long l2) {
        long l3 = 1000L * l / l2;
        return l3 / 10L + "." + l3 % 10L + "%";
    }

    public void Repaint() {
        if (this.stat_perf != null) {
            long l = this.readHits + this.readMisses;
            long l2 = this.writeHits + this.writeMisses;
            long l3 = l + l2;
            long l4 = this.readHits + this.writeHits;
            long l5 = this.readMisses + this.writeMisses;
            this.stat_perf.setValueAt(new Long(this.readHits), this.toffset + 0, 1);
            this.stat_perf.setValueAt(new Long(this.writeHits), this.toffset + 0, 2);
            this.stat_perf.setValueAt(new Long(l4), this.toffset + 0, 3);
            this.stat_perf.setValueAt(new Long(this.readMisses), this.toffset + 1, 1);
            this.stat_perf.setValueAt(new Long(this.writeMisses), this.toffset + 1, 2);
            this.stat_perf.setValueAt(new Long(l5), this.toffset + 1, 3);
            this.stat_perf.setValueAt(new Long(l), this.toffset + 2, 1);
            this.stat_perf.setValueAt(new Long(l2), this.toffset + 2, 2);
            this.stat_perf.setValueAt(new Long(l3), this.toffset + 2, 3);
            this.stat_perf.setValueAt(l > 0L ? this.Percent(this.readHits, l) : "", this.toffset + 3, 1);
            this.stat_perf.setValueAt(l2 > 0L ? this.Percent(this.writeHits, l2) : "", this.toffset + 3, 2);
            this.stat_perf.setValueAt(l3 > 0L ? this.Percent(l4, l3) : "", this.toffset + 3, 3);
            this.stat_perf.setValueAt(new Long(this.cycles), this.toffset + 4, 3);
        }
        this.repaint(100L);
    }

    private void Replace(int n, int n2, int n3, boolean bl) {
        if (this.nWays > 1) {
            switch (this.replacementStrategy) {
                case 0: 
                case 1: {
                    long l = this.age[n2];
                    int n4 = n2 + this.nLines;
                    this.rWay = 0;
                    for (int i = 1; i < this.nWays; ++i) {
                        if (this.age[n4] < l) {
                            this.rWay = i;
                            l = this.age[n4];
                        }
                        n4 += this.nLines;
                    }
                    break;
                }
                case 2: {
                    this.rWay = this.random.nextInt(this.nWays);
                    break;
                }
                case 3: {
                    this.rWay = (this.rWay + 1) % this.nWays;
                }
            }
        }
        ++this.totalReplacements;
        if (this.valid[n2 += this.rWay * this.nLines]) {
            ++this.validReplacements;
            if (this.dirty[n2]) {
                this.dirty[n2] = false;
                ++this.dirtyReplacements;
                this.cycles += (long)(4 + this.lineSize - 1);
            }
        }
        if (this.parent.simulation == null) {
            this.Message("addr=0x" + Integer.toHexString(n) + ": MISS, replace entry @ way=" + this.rWay + ", line=" + (n2 - this.rWay * this.nLines) + ", newtag=0x" + Integer.toHexString(n3));
        }
        this.valid[n2] = true;
        this.dirty[n2] = bl;
        this.tag[n2] = n3;
        this.cycles += (long)(4 + this.lineSize - 1);
        this.age[n2] = this.cycles;
    }

    public int CachedWriteWord(int n, int n2) {
        int n3 = this.WriteWord(n, n2);
        if (this.cache && n3 >= 0) {
            ++this.cycles;
            int n4 = n >> this.lineShift & this.lineMask;
            int n5 = n >> this.tagShift & this.tagMask;
            int n6 = n4;
            for (int i = 0; i < this.nWays; ++i) {
                if (this.valid[n6] && this.tag[n6] == n5) {
                    ++this.writeHits;
                    if (this.writeBack) {
                        this.dirty[n6] = true;
                    } else {
                        this.cycles += 4L;
                    }
                    if (this.replacementStrategy == 0) {
                        this.age[n6] = this.cycles;
                    }
                    if (this.parent.simulation == null) {
                        this.Message("addr=0x" + Integer.toHexString(n) + ": HIT @ way=" + i + ", line=" + n6);
                    }
                    return n3;
                }
                n6 += this.nLines;
            }
            this.Replace(n, n4, n5, this.writeBack);
            if (!this.writeBack) {
                this.cycles += 4L;
            }
        } else {
            this.cycles += 4L;
        }
        ++this.writeMisses;
        return n3;
    }

    public int CachedReadWord(int n) {
        int n2 = this.ReadWord(n);
        if (this.cache) {
            ++this.cycles;
            int n3 = n >> this.lineShift & this.lineMask;
            int n4 = n >> this.tagShift & this.tagMask;
            int n5 = n3;
            for (int i = 0; i < this.nWays; ++i) {
                if (this.valid[n5] && this.tag[n5] == n4) {
                    ++this.readHits;
                    if (this.replacementStrategy == 0) {
                        this.age[n5] = this.cycles;
                    }
                    if (this.parent.simulation == null) {
                        this.Message("addr=0x" + Integer.toHexString(n) + ": HIT @ way=" + i + ", line=" + n5);
                    }
                    return n2;
                }
                n5 += this.nLines;
            }
            this.Replace(n, n3, n4, false);
        } else {
            this.cycles += 4L;
        }
        ++this.readMisses;
        return n2;
    }

    public void Message(String string) {
        if (this.message != null) {
            if (string.length() == 0) {
                this.message.setText(string);
            } else {
                String string2 = this.message.getText();
                string2 = string2.length() == 0 ? string : string2 + "\n" + string;
                this.message.setText(string2);
            }
        }
    }

    public void CacheReset() {
        this.cycles = 0L;
        this.readMisses = 0L;
        this.writeMisses = 0L;
        this.readHits = 0L;
        this.writeHits = 0L;
        this.dirtyReplacements = 0L;
        this.validReplacements = 0L;
        this.totalReplacements = 0L;
        this.random.setSeed(0L);
        this.rWay = 0;
        this.Message("");
        if (this.cache) {
            int n = this.dirty.length;
            for (int i = 0; i < n; ++i) {
                this.dirty[i] = false;
                this.valid[i] = false;
                this.tag[i] = 0;
                this.age[i] = 0L;
            }
        }
        this.Repaint();
    }

    public void SetCacheParameters(boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        this.cache = bl;
        this.replacementStrategy = n;
        this.lineSize = n2;
        this.nWays = n3;
        this.totalLines = n4;
        this.writeBack = bl2;
        this.ProcessCacheParameters();
    }

    private void ProcessCacheParameters() {
        if (this.cache) {
            this.dirty = new boolean[this.totalLines];
            this.valid = new boolean[this.totalLines];
            this.tag = new int[this.totalLines];
            this.age = new long[this.totalLines];
            this.nLines = this.totalLines / this.nWays;
            this.lineShift = Memory.Log2(this.lineSize) + 2;
            this.lineMask = Memory.Mask(this.nLines);
            this.tagShift = this.lineShift + Memory.Log2(this.nLines);
            this.tagMask = (1 << 32 - this.tagShift) - 1;
            int n = 32 - this.tagShift;
            this.stat_address.setValueAt(new Integer(n), this.toffset + 0, 1);
            this.stat_address.setValueAt(new Integer(this.tagShift - this.lineShift), this.toffset + 1, 1);
            this.stat_address.setValueAt(new Integer(this.lineShift), this.toffset + 2, 1);
            int n2 = 32 * this.lineSize + n + 1 + (this.writeBack ? 1 : 0);
            int n3 = this.nLines == 1 ? this.totalLines * n2 * 50 : this.totalLines * n2 * 6 + (this.tagShift - this.lineShift) * 20 + this.nLines * 20 + n2 * this.nWays * 30;
            int n4 = this.nWays * (32 - this.tagShift);
            int n5 = n4 * 20;
            int n6 = this.nWays * 32 * (this.lineSize - 1);
            int n7 = n6 * 8;
            this.stat_cost.setValueAt(this.nLines > 1 ? "SRAM" : "Register bits", this.toffset + 0, 0);
            this.stat_cost.setValueAt(this.nLines > 1 ? this.nLines + "x" + this.nWays * n2 : Integer.toString(n2), this.toffset + 0, 1);
            this.stat_cost.setValueAt(new Integer(n3), this.toffset + 0, 2);
            this.stat_cost.setValueAt(new Integer(n4), this.toffset + 1, 1);
            this.stat_cost.setValueAt(new Integer(n5), this.toffset + 1, 2);
            this.stat_cost.setValueAt(new Integer(n6), this.toffset + 2, 1);
            this.stat_cost.setValueAt(new Integer(n7), this.toffset + 2, 2);
            this.stat_cost.setValueAt(new Integer(n3 + n5 + n7), this.toffset + 3, 2);
            this.ctl_lineSize.setEnabled(true);
            this.ctl_totalLines.setEnabled(true);
            this.ctl_nWays.setEnabled(true);
            this.ctl_replacementStrategy.setEnabled(this.nWays > 1);
            this.ctl_writeBack.setEnabled(true);
        } else {
            this.ctl_lineSize.setEnabled(false);
            this.ctl_totalLines.setEnabled(false);
            this.ctl_nWays.setEnabled(false);
            this.ctl_replacementStrategy.setEnabled(false);
            this.ctl_writeBack.setEnabled(false);
        }
        this.CacheReset();
    }
}

