/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EditFrame;
import gui.Transform;
import gui.UI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class EditCanvas
extends JPanel
implements ComponentListener {
    public EditFrame parent;
    public Transform viewTransform;
    public Rectangle tempRect;
    public int grid;
    int cursor;

    public EditCanvas(EditFrame editFrame) {
        this.setBackground(UI.EDITBGCOLOR);
        this.setOpaque(true);
        this.parent = editFrame;
        this.tempRect = new Rectangle();
        this.viewTransform = new Transform(0, 0, 0, 1.0);
        this.grid = 1;
        this.cursor = 0;
        this.addMouseListener(editFrame);
        this.addMouseMotionListener(editFrame);
        this.addKeyListener(editFrame);
        this.addComponentListener(this);
    }

    public void Repaint() {
        this.repaint();
    }

    public void Repaint(Rectangle rectangle) {
        this.viewTransform.TransformRectangle(rectangle, this.tempRect);
        ++this.tempRect.width;
        ++this.tempRect.height;
        this.repaint(this.tempRect);
    }

    public void Repaint(int n, int n2, int n3, int n4) {
        this.tempRect.setBounds(n, n2, n3, n4);
        this.Repaint(this.tempRect);
    }

    public void Activate(boolean bl) {
        this.setEnabled(bl);
        if (bl) {
            this.requestFocus();
            this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            this.Repaint();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void SetCursor(int n) {
        if (this.cursor != n) {
            this.cursor = n;
            if (this.isEnabled()) {
                this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            }
        }
    }

    public void DrawGrid(Graphics graphics, Rectangle rectangle) {
        if ((double)this.grid * this.viewTransform.scale >= 4.0) {
            int n = this.OnGrid(rectangle.x);
            int n2 = this.OnGrid(rectangle.x + rectangle.width);
            int n3 = this.OnGrid(rectangle.y);
            int n4 = this.OnGrid(rectangle.y + rectangle.height);
            graphics.setColor(UI.GRIDCOLOR);
            for (int i = n; i <= n2; i += this.grid) {
                for (int j = n3; j <= n4; j += this.grid) {
                    boolean bl = this.grid == 1 && i % 8 == 0 && j % 8 == 0;
                    this.viewTransform.DrawGridPoint(graphics, i, j, this.grid, bl);
                }
            }
            this.viewTransform.DrawLine(graphics, -1, 0, 1, 0);
            this.viewTransform.DrawLine(graphics, 0, -1, 0, 1);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        this.tempRect.setBounds(this.X(rectangle.x), this.Y(rectangle.y), this.X(rectangle.width + rectangle.x) - this.X(rectangle.x), this.Y(rectangle.height + rectangle.y) - this.Y(rectangle.y));
        this.DrawGrid(graphics, this.tempRect);
        this.parent.DrawContents(graphics, this.viewTransform, this.tempRect);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.parent.SetupScrollbars();
        this.parent.Surround();
    }

    public int X(int n) {
        if (this.viewTransform == null) {
            return 0;
        }
        return (int)Math.round(((double)n - this.viewTransform.orgx) / this.viewTransform.scale);
    }

    public int Y(int n) {
        if (this.viewTransform == null) {
            return 0;
        }
        return (int)Math.round(((double)n - this.viewTransform.orgy) / this.viewTransform.scale);
    }

    public int OnGrid(int n) {
        if (n < 0) {
            return (-n + (this.grid >> 1)) / this.grid * -this.grid;
        }
        return (n + (this.grid >> 1)) / this.grid * this.grid;
    }

    public void Surround(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        double d = n3 == 0 ? 4.0 : (double)dimension.width / (double)n3;
        double d2 = n4 == 0 ? 4.0 : (double)dimension.height / (double)n4;
        double d3 = 0.9 * (d < d2 ? d : d2);
        this.Recenter(n + (n3 >> 1), n2 + (n4 >> 1), d3);
    }

    public void Zoom(int n, int n2, int n3, int n4, double d) {
        this.viewTransform.orgx = n - (int)((double)n3 * d);
        this.viewTransform.orgy = n2 - (int)((double)n4 * d);
        this.SetScale(d);
    }

    public void Recenter(int n, int n2, double d) {
        Dimension dimension = this.getSize();
        this.viewTransform.orgx = dimension.width / 2 - (int)((double)n * d);
        this.viewTransform.orgy = dimension.height / 2 - (int)((double)n2 * d);
        this.SetScale(d);
    }

    public void SetScale(double d) {
        this.viewTransform.scale = d;
        this.parent.SetupScrollbars();
        this.Repaint();
    }

    public void SetGrid(int n) {
        if (n > 0 && this.grid != n) {
            this.grid = n;
            this.Repaint();
        }
    }

    public double GetScale() {
        return this.viewTransform.scale;
    }

    public int GetOriginX() {
        return (int)this.viewTransform.orgx;
    }

    public int GetOriginY() {
        return (int)this.viewTransform.orgy;
    }

    public void SetOriginX(int n) {
        this.viewTransform.orgx = n;
        this.Repaint();
    }

    public void SetOriginY(int n) {
        this.viewTransform.orgy = n;
        this.Repaint();
    }

    protected void RepaintRectangle(Rectangle rectangle) {
        this.viewTransform.TransformRectangle(rectangle, this.tempRect);
        this.Repaint(this.tempRect.x - 2, this.tempRect.y - 2, this.tempRect.width + 4, this.tempRect.height + 4);
    }
}

