/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.Vector;

public class UndoList {
    public String name;
    public Vector list;
    UndoList nextLink;
    UndoList prevLink;

    public UndoList(String string, Vector vector, UndoList undoList) {
        this.name = string;
        this.list = vector;
        if (undoList != null) {
            this.prevLink = undoList;
            undoList.nextLink = this;
        }
    }

    public final UndoList next() {
        return this.nextLink;
    }

    public final UndoList prev() {
        return this.prevLink;
    }

    public final void ignoreNext() {
        if (this.nextLink != null) {
            this.nextLink = this.nextLink.next();
        }
    }

    public final void ignorePrev() {
        if (this.prevLink != null) {
            this.prevLink = this.prevLink.prev();
        }
    }

    public final void unlink() {
        if (this.prevLink != null) {
            this.prevLink.ignoreNext();
        }
        if (this.nextLink != null) {
            this.nextLink.ignorePrev();
        }
    }

    public final void insertAfter(UndoList undoList) {
        undoList.unlink();
        this.prevLink = this;
        undoList.nextLink = this.nextLink;
        if (this.nextLink != null) {
            this.nextLink.prevLink = undoList;
        }
        this.nextLink = undoList;
    }

    public boolean CanUndoRedo(boolean bl) {
        UndoList undoList = bl ? this.next() : this.prev();
        return undoList != null;
    }
}

