/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.Component;
import java.util.Date;
import javax.swing.JOptionPane;
import logicsim.Gate;
import logicsim.I18N;
import logicsim.Wire;

public class CLK
extends Gate {
    static final long serialVersionUID = 3971572931629721831L;
    transient long lastTime;
    long highTime = 1000L;
    long lowTime = 1000L;

    public CLK() {
        this.imagename = "clock";
    }

    public CLK(Wire wire) {
        super(wire);
    }

    public int getNumInput() {
        return 0;
    }

    public int getNumOutput() {
        return 1;
    }

    public void simulate() {
        if (this.lastTime == 0L) {
            this.lastTime = new Date().getTime();
        }
        if (!this.out[0] && new Date().getTime() - this.lastTime > this.lowTime) {
            this.out[0] = true;
            this.lastTime = new Date().getTime();
        }
        if (this.out[0] && new Date().getTime() - this.lastTime > this.highTime) {
            this.out[0] = false;
            this.lastTime = new Date().getTime();
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public boolean showProperties(Component component) {
        String string = (String)JOptionPane.showInputDialog(component, I18N.getString("MESSAGE_ENTER_TIME_HIGH"), "LogicSim", 3, null, null, Integer.toString((int)this.highTime));
        if (string != null && string.length() > 0) {
            this.highTime = new Integer(string).intValue();
        }
        if ((string = (String)JOptionPane.showInputDialog(component, I18N.getString("MESSAGE_ENTER_TIME_LOW"), "LogicSim", 3, null, null, Integer.toString((int)this.lowTime))) != null && string.length() > 0) {
            this.lowTime = new Integer(string).intValue();
        }
        return true;
    }
}

