/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import logicsim.GateList;
import logicsim.LSFrame;
import logicsim.Wire;

public abstract class Gate
implements Serializable {
    static final long serialVersionUID = -6775454761569297690L;
    static final int INTYPE_NORMAL = 0;
    static final int INTYPE_NEGATIVE = 1;
    static final int INTYPE_HIGH = 2;
    static final int INTYPE_LOW = 3;
    String imagename;
    String onimagename;
    transient Image gateimage;
    transient Image onimage;
    int gateimagewidth;
    int gateimageheight;
    public int x;
    public int y;
    transient boolean active;
    Vector in;
    boolean[] out = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    int[] inputTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int numInput;

    public Gate() {
        this.in = new Vector(16);
        for (int i = 0; i < 16; ++i) {
            this.in.addElement(null);
        }
        this.active = true;
    }

    public Gate(Wire wire) {
        this();
        this.in.setElementAt(wire, 0);
    }

    public Gate(Wire wire, Wire wire2) {
        this();
        this.in.setElementAt(wire, 0);
        this.in.setElementAt(wire2, 1);
    }

    public Gate(Wire wire, Wire wire2, Wire wire3) {
        this();
        this.in.setElementAt(wire, 0);
        this.in.setElementAt(wire2, 1);
        this.in.setElementAt(wire3, 2);
    }

    public Gate(int n) {
        this();
        this.numInput = n;
    }

    public final void activate() {
        this.active = true;
    }

    public final void deactivate() {
        this.active = false;
    }

    public void simulate() {
    }

    public void clock() {
    }

    public boolean getOutput(int n) {
        if (n >= 0 && n < this.getNumOutput()) {
            return this.out[n];
        }
        return false;
    }

    public void setOutput(boolean bl) {
    }

    public int getNumInput() {
        return 0;
    }

    public int getNumOutput() {
        return 0;
    }

    public void setInput(int n, Wire wire) {
        if (n >= 0 && n < this.getNumInput()) {
            this.in.setElementAt(wire, n);
            if (this.inputTypes[n] == 2 || this.inputTypes[n] == 3) {
                this.inputTypes[n] = 0;
            }
        }
    }

    public final Wire getInput(int n) {
        Object object;
        if (this.in.size() < 16) {
            for (int i = this.in.size(); i <= 16; ++i) {
                this.in.addElement(null);
            }
            object = new int[16];
            for (int i = 0; i < 16; ++i) {
                object[i] = i <= this.inputTypes.length - 1 ? (Object)this.inputTypes[i] : (Object)false;
            }
            this.inputTypes = (int[])object;
        }
        if ((object = (Wire)this.in.get(n)) == null && this.inputTypes[n] != 0) {
            return new Wire(null, 0);
        }
        return object;
    }

    public boolean getInputState(int n) {
        if (this.inputTypes[n] == 0 && this.getInput(n) != null) {
            return this.getInput(n).getState();
        }
        if (this.inputTypes[n] == 1 && this.getInput(n) != null) {
            return !this.getInput(n).getState();
        }
        if (this.inputTypes[n] == 2) {
            return true;
        }
        if (this.inputTypes[n] == 3) {
            return false;
        }
        return false;
    }

    public void loadImage() {
        String string = "images/din/";
        if (LSFrame.gatedesign.equals("iso")) {
            string = "images/iso/";
        }
        this.gateimage = new ImageIcon(LSFrame.class.getResource(string + this.imagename + ".gif")).getImage();
        if (this.onimagename != null) {
            this.onimage = new ImageIcon(LSFrame.class.getResource(string + this.onimagename + ".gif")).getImage();
        }
        if (this.gateimage != null) {
            this.gateimagewidth = this.gateimage.getWidth(null);
            this.gateimageheight = this.gateimage.getHeight(null);
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        if (this.gateimage == null) {
            this.loadImage();
        }
        graphics.setColor(Color.black);
        graphics.drawImage(this.gateimage, this.x + 3, this.y, null);
        for (n2 = 0; n2 < this.getNumInput(); ++n2) {
            n = this.getInputPosition(n2);
            if (this.inputTypes[n2] == 1) {
                graphics.drawOval(this.x - 1, this.y + n - 2, 4, 4);
                continue;
            }
            if (this.inputTypes[n2] == 2) {
                graphics.drawString("1", this.x - 4, this.y + n + 4);
                continue;
            }
            if (this.inputTypes[n2] == 3) {
                graphics.drawString("0", this.x - 4, this.y + n + 4);
                continue;
            }
            graphics.drawLine(this.x, this.y + n, this.x + 3, this.y + n);
        }
        for (n2 = 0; n2 < this.getNumOutput(); ++n2) {
            n = this.getOutputPosition(n2);
            int n3 = this.gateimage.getWidth(null);
            if (this.isOutputPositive(n2)) {
                graphics.drawLine(this.x + n3 + 3, this.y + n, this.x + n3 + 6, this.y + n);
                continue;
            }
            graphics.drawOval(this.x + n3 + 3, this.y + n - 2, 4, 4);
        }
        if (this.active) {
            graphics.setColor(Color.blue);
            graphics.drawLine(this.x - 5, this.y - 5, this.x - 5, this.y);
            graphics.drawLine(this.x - 5, this.y - 5, this.x, this.y - 5);
            graphics.drawLine(this.x + this.gateimagewidth + 3, this.y - 5, this.x + this.gateimagewidth + 3 + 5, this.y - 5);
            graphics.drawLine(this.x + this.gateimagewidth + 3 + 5, this.y - 5, this.x + this.gateimagewidth + 3 + 5, this.y);
            graphics.drawLine(this.x + this.gateimagewidth + 3 + 5, this.y + this.gateimageheight, this.x + this.gateimagewidth + 3 + 5, this.y + this.gateimageheight + 5);
            graphics.drawLine(this.x + this.gateimagewidth + 3, this.y + this.gateimageheight + 5, this.x + this.gateimagewidth + 3 + 5, this.y + this.gateimageheight + 5);
            graphics.drawLine(this.x - 5, this.y + this.gateimageheight + 5, this.x, this.y + this.gateimageheight + 5);
            graphics.drawLine(this.x - 5, this.y + this.gateimageheight, this.x - 5, this.y + this.gateimageheight + 5);
            graphics.setColor(Color.black);
        }
        for (n2 = 0; n2 < this.getNumInput(); ++n2) {
            Wire wire = (Wire)this.in.get(n2);
            if (wire == null) continue;
            wire.draw(graphics);
        }
    }

    public final Wire tryConnectOutput(int n, int n2) {
        for (int i = 0; i < this.getNumOutput(); ++i) {
            if (n <= this.x + this.gateimagewidth + 6 - 5 || n >= this.x + this.gateimagewidth + 6 + 5 || n2 <= this.y + this.getOutputPosition(i) - 4 || n2 >= this.y + this.getOutputPosition(i) + 4) continue;
            Wire wire = new Wire(this, i);
            wire.addPoint(this.x + this.gateimagewidth + 6, this.y + this.getOutputPosition(i));
            return wire;
        }
        return null;
    }

    public final boolean tryConnectInput(int n, int n2, Wire wire) {
        if (wire == null) {
            return false;
        }
        for (int i = 0; i < this.getNumInput(); ++i) {
            if (n <= this.x - 5 || n >= this.x + 5 || n2 <= this.y + this.getInputPosition(i) - 4 || n2 >= this.y + this.getInputPosition(i) + 4) continue;
            this.setInput(i, wire);
            wire.addPoint(this.x, this.y + this.getInputPosition(i));
            return true;
        }
        return false;
    }

    public final boolean trySetInputType(int n, int n2, int n3) {
        for (int i = 0; i < this.getNumInput(); ++i) {
            if (n <= this.x - 5 || n >= this.x + 5 || n2 <= this.y + this.getInputPosition(i) - 4 || n2 >= this.y + this.getInputPosition(i) + 4) continue;
            if (n3 == 2 || n3 == 3) {
                this.setInput(i, null);
            }
            this.inputTypes[i] = n3;
            return true;
        }
        return false;
    }

    public void clicked(int n, int n2) {
    }

    public void mouseReleased() {
    }

    public boolean hasProperties() {
        return false;
    }

    public boolean showProperties(Component component) {
        return false;
    }

    public final boolean inside(int n, int n2) {
        return new Rectangle(this.x, this.y, this.gateimagewidth, this.gateimageheight).contains(n, n2);
    }

    public int getOutputPosition(int n) {
        return this.getConnectorPosition(n, this.getNumOutput());
    }

    public int getInputPosition(int n) {
        return this.getConnectorPosition(n, this.getNumInput());
    }

    public int getConnectorPosition(int n, int n2) {
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return 25;
        }
        if (n2 == 2) {
            switch (n) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 45;
                }
            }
        }
        if (n2 == 3) {
            switch (n) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 25;
                }
                case 2: {
                    return 45;
                }
            }
        }
        if (n2 == 4) {
            switch (n) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 15;
                }
                case 2: {
                    return 35;
                }
                case 3: {
                    return 45;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 15;
                }
                case 2: {
                    return 25;
                }
                case 3: {
                    return 35;
                }
                case 4: {
                    return 45;
                }
            }
        }
        if (n2 >= 6) {
            return 5 + n * 10;
        }
        return -1;
    }

    public boolean isOutputPositive(int n) {
        return true;
    }

    public void moveTo(int n, int n2, GateList gateList) {
        Serializable serializable;
        int n3;
        this.x = n - 20;
        this.y = n2 - 25;
        for (n3 = 0; n3 < this.getNumInput(); ++n3) {
            serializable = this.getInput(n3);
            if (serializable == null) continue;
            ((Wire)serializable).setLastPoint(this.x, this.y + this.getInputPosition(n3));
        }
        for (n3 = 0; n3 < gateList.size(); ++n3) {
            serializable = gateList.get(n3);
            for (int i = 0; i < ((Gate)serializable).getNumInput(); ++i) {
                Wire wire = ((Gate)serializable).getInput(i);
                if (wire == null || wire.gate != this) continue;
                wire.setFirstPoint(this.x + this.gateimagewidth + 6, this.y + this.getOutputPosition(wire.outNum));
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = false;
        }
    }

    public void printInfo() {
        System.out.println("this gate is an " + this.toString());
        System.out.println("it contains these wires:");
        for (int i = 0; i < this.getNumInput(); ++i) {
            this.getInput(i).printInfo();
        }
    }
}

