/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.io.Serializable;
import java.util.Vector;
import logicsim.Gate;
import logicsim.Module;
import logicsim.Wire;

public class GateList
implements Serializable {
    static final long serialVersionUID = 3458986578856078326L;
    Vector gates = new Vector();

    public void addGate(Gate g) {
        this.gates.addElement(g);
    }

    public int size() {
        return this.gates.size();
    }

    public void clear() {
        this.gates.clear();
    }

    public void remove(int n) {
        this.gates.remove(n);
        for (int i = 0; i < this.size(); ++i) {
            Gate g = this.get(i);
            for (int j = 0; j < g.getNumInput() && g.getInput(j) != null; ++j) {
                if (this.gates.contains(g.getInput((int)j).gate)) continue;
                g.setInput(j, null);
            }
        }
    }

    public Gate get(int n) {
        return (Gate)this.gates.get(n);
    }

    public void simulate() {
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.gates.size(); ++i) {
                Gate g = (Gate)this.gates.get(i);
                g.simulate();
            }
        }
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate g = (Gate)this.gates.get(i);
            g.clock();
        }
    }

    public void reconnect() {
        Gate g;
        int i;
        for (i = 0; i < this.size(); ++i) {
            g = (Gate)this.gates.get(i);
            for (int j = 0; j < 16; ++j) {
                Wire w = g.getInput(j);
                if (w == null) continue;
                for (int k = 0; k < this.size(); ++k) {
                    Gate ng = (Gate)this.gates.get(k);
                    Wire nw = ng.tryConnectOutput(w.poly.xpoints[0], w.poly.ypoints[0]);
                    if (nw == null) continue;
                    w.gate = nw.gate;
                    w.outNum = nw.outNum;
                }
            }
        }
        for (i = 0; i < this.size(); ++i) {
            g = this.get(i);
            if (!(g instanceof Module)) continue;
            Module m = (Module)g;
            m.loadModule();
        }
    }

    public void deactivateAll() {
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate g = (Gate)this.gates.get(i);
            g.deactivate();
            for (int j = 0; j < g.getNumInput(); ++j) {
                if (g.getInput(j) == null) continue;
                g.getInput(j).deactivate();
            }
        }
    }

    public void printInfo() {
        for (int i = 0; i < this.size(); ++i) {
            Gate g = this.get(i);
            g.printInfo();
        }
    }

    public void reloadImages() {
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate g = (Gate)this.gates.get(i);
            g.loadImage();
        }
    }
}

