/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import logicsim.Gate;
import logicsim.I18N;
import logicsim.LSFrame;

public class LCD
extends Gate {
    static final long serialVersionUID = -6532037559895208921L;
    transient Image digits;
    int displayType;

    public LCD() {
        this.imagename = "LCD";
    }

    public int getNumInput() {
        return 8;
    }

    public int getNumOutput() {
        return 0;
    }

    public void simulate() {
    }

    public void draw(Graphics graphics) {
        int n;
        if (this.onimage == null || this.gateimage == null) {
            this.loadImage();
        }
        if (this.digits == null) {
            this.digits = new ImageIcon(LSFrame.class.getResource("images/LCDdigits.gif")).getImage();
        }
        super.draw(graphics);
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            if (this.getInput(n) == null || !this.getInputState(n)) continue;
            n2 += 1 << n;
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        string = this.displayType == 1 ? Integer.toString(n2) : Integer.toHexString(n2);
        if (string.length() == 0) {
            string = "00";
        }
        if (string.length() == 1) {
            string = "0" + string;
        }
        for (int i = 0; i <= 1; ++i) {
            switch (string.charAt(i)) {
                case '0': {
                    n = 0;
                    break;
                }
                case '1': {
                    n = 15;
                    break;
                }
                case '2': {
                    n = 30;
                    break;
                }
                case '3': {
                    n = 45;
                    break;
                }
                case '4': {
                    n = 60;
                    break;
                }
                case '5': {
                    n = 75;
                    break;
                }
                case '6': {
                    n = 90;
                    break;
                }
                case '7': {
                    n = 105;
                    break;
                }
                case '8': {
                    n = 120;
                    break;
                }
                case '9': {
                    n = 135;
                    break;
                }
                case 'a': {
                    n = 150;
                    break;
                }
                case 'b': {
                    n = 165;
                    break;
                }
                case 'c': {
                    n = 180;
                    break;
                }
                case 'd': {
                    n = 195;
                    break;
                }
                case 'e': {
                    n = 210;
                    break;
                }
                case 'f': {
                    n = 225;
                }
            }
            if (i == 0) {
                n3 = n;
            }
            if (i != 1) continue;
            n4 = n;
        }
        graphics.setClip(this.x + 5 + 5, this.y + 24, 15, 30);
        graphics.drawImage(this.digits, this.x + 5 + 5 - n3, this.y + 24, null);
        graphics.setClip(this.x + 20 + 5, this.y + 24, 15, 30);
        graphics.drawImage(this.digits, this.x + 20 + 5 - n4, this.y + 24, null);
        graphics.setClip(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean hasProperties() {
        return true;
    }

    public boolean showProperties(Component component) {
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        if (this.displayType == 1) {
            jRadioButton2.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        EtchedBorder etchedBorder = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), I18N.getString("GATE_BINARYINPUT_DISPLAYTYPE"));
        jRadioButton.setText(I18N.getString("GATE_BINARYINPUT_HEX"));
        jRadioButton2.setText(I18N.getString("GATE_BINARYINPUT_DEC"));
        jPanel.setBorder(titledBorder);
        jPanel.setBounds(new Rectangle(11, 11, 171, 150));
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)jRadioButton, "North");
        jPanel.add((Component)jRadioButton2, "Center");
        JOptionPane jOptionPane = new JOptionPane(jPanel);
        jOptionPane.setMessageType(3);
        jOptionPane.setOptions(new String[]{I18N.getString("BUTTON_USE"), I18N.getString("BUTTON_CANCEL")});
        JDialog jDialog = jOptionPane.createDialog(component, I18N.getString("GATE_LCD_PROPERTIES"));
        jDialog.setResizable(true);
        jDialog.setSize(290, 180);
        jDialog.show();
        if (I18N.getString("BUTTON_USE").equals((String)jOptionPane.getValue())) {
            if (jRadioButton.isSelected()) {
                this.displayType = 0;
            } else if (jRadioButton2.isSelected()) {
                this.displayType = 1;
            }
            return true;
        }
        return false;
    }
}

