/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import logicsim.App;
import logicsim.ExampleFileFilter;
import logicsim.Gate;
import logicsim.GateList;
import logicsim.HTMLHelp;
import logicsim.I18N;
import logicsim.LSFrame_AboutBox;
import logicsim.LSFrame_jButton_addpoint_actionAdapter;
import logicsim.LSFrame_jButton_delpoint_actionAdapter;
import logicsim.LSFrame_jCheckBoxMenuItem_paintGrid_actionAdapter;
import logicsim.LSFrame_jList_gates_mouseAdapter;
import logicsim.LSFrame_jMenuItem_help_actionAdapter;
import logicsim.LSFrame_jMenuItem_new_actionAdapter;
import logicsim.LSFrame_jMenuItem_open_actionAdapter;
import logicsim.LSFrame_jMenuItem_save_actionAdapter;
import logicsim.LSFrame_jMenuItem_saveas_actionAdapter;
import logicsim.LSPanel;
import logicsim.MODIN;
import logicsim.MODOUT;
import logicsim.Module;
import logicsim.Simulate;

public class LSFrame
extends JInternalFrame
implements ActionListener {
    Object[] gateNames = new Object[]{I18N.getString("GATE_SWITCH"), I18N.getString("GATE_LED"), I18N.getString("GATE_AND"), I18N.getString("GATE_NAND"), I18N.getString("GATE_OR"), I18N.getString("GATE_NOR"), I18N.getString("GATE_NOT"), I18N.getString("GATE_XOR"), I18N.getString("GATE_EQUIVALENCE"), "---", I18N.getString("GATE_NORMALINPUT"), I18N.getString("GATE_INPUT_INVERTER"), I18N.getString("GATE_INPUT_HIGH"), I18N.getString("GATE_INPUT_LOW"), "---", I18N.getString("GATE_RSFF"), I18N.getString("GATE_DFF"), I18N.getString("GATE_DRFF"), I18N.getString("GATE_JKFF"), I18N.getString("GATE_JKMSFF"), I18N.getString("GATE_TFF"), "---", I18N.getString("GATE_CLOCK"), I18N.getString("GATE_MONOFLOP"), I18N.getString("GATE_TURNONDELAY"), I18N.getString("GATE_TURNOFFDELAY"), "---", I18N.getString("GATE_BINARYINPUT"), I18N.getString("GATE_LCD"), I18N.getString("GATE_SEVENSEGMENT"), I18N.getString("GATE_TEXTLABEL"), "---"};
    int[] actions = new int[]{4, 5, 1, 2, 9, 10, 3, 11, 12, 0, 24, 25, 26, 27, 0, 6, 23, 32, 7, 8, 21, 0, 13, 22, 28, 29, 0, 19, 20, 31, 30, 0};
    String[] gateInputNums = new String[]{"2 " + I18N.getString("MESSAGE_INPUTS"), "3 " + I18N.getString("MESSAGE_INPUTS"), "4 " + I18N.getString("MESSAGE_INPUTS"), "5 " + I18N.getString("MESSAGE_INPUTS")};
    String fileName = "./circuits/";
    JPopupMenu popup;
    JPopupMenu popup_list;
    JMenuItem menuItem_remove;
    JMenuItem menuItem_properties;
    JMenuItem menuItem_list_delmod;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel_gates = new JPanel();
    DefaultListModel jList_gates_model = new DefaultListModel();
    JList jList_gates = new JList(this.jList_gates_model);
    LSPanel lspanel = new LSPanel(this.statusBar);
    JScrollPane jScrollPane_lspanel = new JScrollPane(this.lspanel);
    JSplitPane jSplitPane = new JSplitPane(1, true);
    int popupGateIdx;
    int popupModule;
    JScrollPane jScrollPane_gates = new JScrollPane();
    Simulate sim;
    public static boolean isApplet = false;
    public static JApplet applet = null;
    JFrame window;
    JButton jButton_open = new JButton();
    JButton jButton_new = new JButton();
    JButton jButton_save = new JButton();
    JToolBar jToolBar = new JToolBar();
    JToggleButton jToggleButton_simulate = new JToggleButton();
    JButton jButton_reset = new JButton();
    JMenu jMenuModule = new JMenu();
    JMenuItem jMenuItem_createmod = new JMenuItem();
    JMenuItem jMenuItem_modproperties = new JMenuItem();
    JMenuItem jMenuItem_exportimage = new JMenuItem();
    JMenuItem jMenuItem_print = new JMenuItem();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JComboBox jComboBox_numinput = new JComboBox<String>(this.gateInputNums);
    BorderLayout borderLayout3 = new BorderLayout();
    JButton jButton_addpoint = new JButton();
    JMenuItem jMenuItem_new = new JMenuItem();
    JMenuItem jMenuItem_open = new JMenuItem();
    JMenuItem jMenuItem_save = new JMenuItem();
    JMenuItem jMenuItem_saveas = new JMenuItem();
    JMenuItem jMenuItem_help = new JMenuItem();
    Component component1;
    JButton jButton_delpoint = new JButton();
    Component component2;
    JMenu jMenuSettings = new JMenu();
    JCheckBoxMenuItem jCheckBoxMenuItem_paintGrid = new JCheckBoxMenuItem();
    JMenu jMenu_gatedesign = new JMenu();
    ButtonGroup buttongroup_gatedesign = new ButtonGroup();
    JRadioButtonMenuItem jMenuItem_gatedesign_din = new JRadioButtonMenuItem();
    JRadioButtonMenuItem jMenuItem_gatedesign_iso = new JRadioButtonMenuItem();
    JMenu jMenu_language = new JMenu();
    ButtonGroup buttongroup_language = new ButtonGroup();
    public static String gatedesign = "din";
    Properties userProperties = new Properties();
    String use_language;

    public LSFrame(JApplet applet) {
        LSFrame.applet = applet;
        isApplet = true;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LSFrame(JFrame window) {
        this.window = window;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LSFrame() {
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.contentPane.setLayout(this.borderLayout1);
        if (this.window != null) {
            this.window.setTitle("LogicSim");
        }
        this.statusBar.setText(" ");
        this.jMenuFile.setText(I18N.getString("MENU_FILE"));
        this.jMenuFileExit.setText(I18N.getString("MENU_EXIT"));
        this.jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuHelp.setText(I18N.getString("MENU_HELP"));
        this.jMenuHelpAbout.setText(I18N.getString("MENU_ABOUT"));
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jScrollPane_lspanel.setHorizontalScrollBarPolicy(32);
        this.jScrollPane_lspanel.setVerticalScrollBarPolicy(22);
        this.jPanel1.setLayout(this.borderLayout3);
        this.jButton_open.setIcon(new ImageIcon(LSFrame.class.getResource("images/open.gif")));
        this.jButton_open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jButton_open_actionPerformed(e);
            }
        });
        this.jButton_open.setToolTipText(I18N.getString("MENU_OPEN"));
        this.jButton_new.setIcon(new ImageIcon(LSFrame.class.getResource("images/new.gif")));
        this.jButton_new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jButton_new_actionPerformed(e);
            }
        });
        this.jButton_save.setIcon(new ImageIcon(LSFrame.class.getResource("images/save.gif")));
        this.jButton_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jButton_save_actionPerformed(e);
            }
        });
        this.jButton_save.setToolTipText(I18N.getString("MENU_SAVE"));
        this.jToggleButton_simulate.setText(I18N.getString("BUTTON_SIMULATE"));
        this.jToggleButton_simulate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jToggleButton_simulate_actionPerformed(e);
            }
        });
        this.jButton_reset.setText(I18N.getString("BUTTON_RESET"));
        this.jButton_reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jButton_reset_actionPerformed(e);
            }
        });
        this.jMenuModule.setText(I18N.getString("MENU_MODULE"));
        this.jMenuItem_createmod.setText(I18N.getString("MENU_CREATEMODULE"));
        this.jMenuItem_createmod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuItem_createmod_actionPerformed(e);
            }
        });
        this.jMenuItem_modproperties.setText(I18N.getString("MENU_MODULEPROPERTIES"));
        this.jMenuItem_modproperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuItem_modproperties_actionPerformed(e);
            }
        });
        this.jMenuItem_exportimage.setText(I18N.getString("MENU_EXPORT"));
        this.jMenuItem_exportimage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.exportImage();
            }
        });
        this.jMenuItem_print.setText(I18N.getString("MENU_PRINT"));
        this.jMenuItem_print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuItem_print_actionPerformed(e);
            }
        });
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setDividerLocation(170);
        this.jPanel_gates.setLayout(this.borderLayout2);
        this.jList_gates.addMouseListener(new LSFrame_jList_gates_mouseAdapter(this));
        this.jPanel_gates.setPreferredSize(new Dimension(120, 200));
        this.jPanel_gates.setMinimumSize(new Dimension(80, 200));
        this.jButton_addpoint.setToolTipText(I18N.getString("TOOLTIP_ADDPOINT"));
        this.jButton_addpoint.setIcon(new ImageIcon(LSFrame.class.getResource("images/addpoint.gif")));
        this.jButton_addpoint.addActionListener(new LSFrame_jButton_addpoint_actionAdapter(this));
        this.jMenuItem_new.setText(I18N.getString("MENU_NEW"));
        this.jMenuItem_new.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.jMenuItem_new.addActionListener(new LSFrame_jMenuItem_new_actionAdapter(this));
        this.jMenuItem_open.setText(I18N.getString("MENU_OPEN"));
        this.jMenuItem_open.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.jMenuItem_open.addActionListener(new LSFrame_jMenuItem_open_actionAdapter(this));
        this.jMenuItem_save.setText(I18N.getString("MENU_SAVE"));
        this.jMenuItem_save.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this.jMenuItem_save.addActionListener(new LSFrame_jMenuItem_save_actionAdapter(this));
        this.jMenuItem_saveas.setText(I18N.getString("MENU_SAVEAS"));
        this.jMenuItem_saveas.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.jMenuItem_saveas.addActionListener(new LSFrame_jMenuItem_saveas_actionAdapter(this));
        this.jMenuItem_help.setText(I18N.getString("MENU_HELP"));
        this.jMenuItem_help.addActionListener(new LSFrame_jMenuItem_help_actionAdapter(this));
        this.jButton_delpoint.setToolTipText(I18N.getString("BUTTON_REMOVE_WIRE_POINT"));
        this.jButton_delpoint.setIcon(new ImageIcon(LSFrame.class.getResource("images/delpoint.gif")));
        this.jButton_delpoint.addActionListener(new LSFrame_jButton_delpoint_actionAdapter(this));
        this.jMenuSettings.setText(I18N.getString("MENU_SETTINGS"));
        this.jCheckBoxMenuItem_paintGrid.setText(I18N.getString("MENU_PAINTGRID"));
        this.jCheckBoxMenuItem_paintGrid.setSelected(true);
        this.jCheckBoxMenuItem_paintGrid.addActionListener(new LSFrame_jCheckBoxMenuItem_paintGrid_actionAdapter(this));
        this.jMenuFile.add(this.jMenuItem_new);
        this.jMenuFile.add(this.jMenuItem_open);
        this.jMenuFile.add(this.jMenuItem_save);
        this.jMenuFile.add(this.jMenuItem_saveas);
        this.jMenuFile.add(this.jMenuItem_exportimage);
        this.jMenuFile.add(this.jMenuItem_print);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuHelp.add(this.jMenuItem_help);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuModule);
        this.jMenuBar1.add(this.jMenuSettings);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.statusBar, "South");
        this.lspanel.setBackground(Color.white);
        this.jPanel_gates.add((Component)this.jScrollPane_gates, "Center");
        this.jPanel_gates.add((Component)this.jComboBox_numinput, "South");
        this.jSplitPane.add((Component)this.jPanel_gates, "left");
        this.jSplitPane.add((Component)this.jScrollPane_lspanel, "right");
        this.contentPane.add((Component)this.jSplitPane, "Center");
        this.jScrollPane_gates.getViewport().add((Component)this.jList_gates, null);
        this.jToolBar.add((Component)this.jButton_new, null);
        this.jToolBar.add(this.jButton_open);
        this.jToolBar.add(this.jButton_save);
        this.jToolBar.add(this.component1, null);
        this.jToolBar.add((Component)this.jButton_addpoint, null);
        this.jToolBar.add((Component)this.jButton_delpoint, null);
        this.jToolBar.add(this.component2, null);
        this.jToolBar.add((Component)this.jToggleButton_simulate, null);
        this.jToolBar.add((Component)this.jButton_reset, null);
        this.jPanel1.add((Component)this.jToolBar, "Center");
        this.contentPane.add((Component)this.jPanel1, "North");
        this.jMenuModule.add(this.jMenuItem_createmod);
        this.jMenuModule.add(this.jMenuItem_modproperties);
        this.jMenu_gatedesign.setText(I18N.getString("MENU_GATEDESIGN"));
        this.buttongroup_gatedesign.add(this.jMenuItem_gatedesign_din);
        this.buttongroup_gatedesign.add(this.jMenuItem_gatedesign_iso);
        this.jMenuItem_gatedesign_din.setText(I18N.getString("MENU_GATEDESIGN_DIN"));
        this.jMenuItem_gatedesign_iso.setText(I18N.getString("MENU_GATEDESIGN_ISO"));
        this.jMenu_gatedesign.add(this.jMenuItem_gatedesign_din);
        this.jMenu_gatedesign.add(this.jMenuItem_gatedesign_iso);
        this.jMenuItem_gatedesign_din.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuItem_gatedesign_actionPerformed(e);
            }
        });
        this.jMenuItem_gatedesign_iso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSFrame.this.jMenuItem_gatedesign_actionPerformed(e);
            }
        });
        boolean paintgrid = true;
        this.jMenuItem_gatedesign_din.setSelected(true);
        this.use_language = "en";
        try {
            String s;
            if (isApplet) {
                URL url = new URL(applet.getCodeBase() + "logicsim.cfg");
                this.userProperties.load(url.openStream());
            } else {
                this.userProperties.load(new FileInputStream("logicsim.cfg"));
            }
            if (this.userProperties.containsKey("paint_grid")) {
                paintgrid = this.userProperties.getProperty("paint_grid").equals("true");
            }
            if ((s = this.userProperties.getProperty("gatedesign")) != null && s.equals("iso")) {
                this.jMenuItem_gatedesign_iso.setSelected(true);
                gatedesign = "iso";
            }
            if (this.userProperties.containsKey("language")) {
                this.use_language = this.userProperties.getProperty("language");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jMenu_language.setText(I18N.getString("MENU_LANGUAGE"));
        this.create_language_menu(this.jMenu_language, this.use_language);
        this.jCheckBoxMenuItem_paintGrid.setSelected(paintgrid);
        this.lspanel.setPaintGrid(paintgrid);
        this.jMenuSettings.add(this.jCheckBoxMenuItem_paintGrid);
        this.jMenuSettings.add(this.jMenu_gatedesign);
        this.jMenuSettings.add(this.jMenu_language);
        this.popup = new JPopupMenu();
        this.menuItem_remove = new JMenuItem(I18N.getString("MENU_REMOVEGATE"));
        this.menuItem_remove.addActionListener(this);
        this.popup.add(this.menuItem_remove);
        this.menuItem_properties = new JMenuItem(I18N.getString("MENU_PROPERTIES"));
        this.menuItem_properties.addActionListener(this);
        this.popup.add(this.menuItem_properties);
        this.lspanel.addMouseListener(new PopupListener());
        this.popup_list = new JPopupMenu();
        this.menuItem_list_delmod = new JMenuItem(I18N.getString("MENU_DELETEMODULE"));
        this.menuItem_list_delmod.addActionListener(this);
        this.popup_list.add(this.menuItem_list_delmod);
        this.jList_gates.addMouseListener(new PopupListener());
        this.fillGateList();
        this.requestFocus();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        if (!this.showDiscardDialog(I18N.getString("MENU_EXIT"))) {
            return;
        }
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        LSFrame_AboutBox dlg = new LSFrame_AboutBox(this.window);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source == this.menuItem_remove) {
            this.lspanel.gates.remove(this.popupGateIdx);
            this.lspanel.repaint();
        } else if (source == this.menuItem_properties) {
            if (this.popupGateIdx >= 0) {
                Gate g = this.lspanel.gates.get(this.popupGateIdx);
                g.showProperties(this);
                this.lspanel.repaint();
            }
        } else if (source == this.menuItem_list_delmod) {
            if (isApplet) {
                return;
            }
            String fname = App.getModulePath() + this.jList_gates_model.getElementAt(this.popupModule) + ".mod";
            String s = I18N.getString("MESSAGE_DELETE").replaceFirst("%s", fname);
            int r = JOptionPane.showConfirmDialog(this, s);
            if (r == 0) {
                File f = new File(fname);
                f.delete();
                this.fillGateList();
            }
        }
    }

    void jButton_addpoint_actionPerformed(ActionEvent e) {
        this.lspanel.setAction(16);
    }

    void jButton_delpoint_actionPerformed(ActionEvent e) {
        this.lspanel.setAction(17);
    }

    void jToggleButton_simulate_actionPerformed(ActionEvent e) {
        if (((JToggleButton)e.getSource()).isSelected()) {
            if (this.sim == null || !this.sim.running) {
                this.sim = new Simulate(this.lspanel);
            }
        } else if (this.sim != null) {
            this.sim.stop();
        }
    }

    void jButton_reset_actionPerformed(ActionEvent e) {
        this.staticReset();
        if (this.sim != null) {
            this.sim.reset();
        }
    }

    void staticReset() {
        if (this.sim == null || !this.sim.running) {
            this.lspanel.gates.simulate();
            for (int i = 0; i < this.lspanel.gates.size(); ++i) {
                Gate g = this.lspanel.gates.get(i);
                g.reset();
            }
            this.lspanel.repaint();
            this.lspanel.gates.simulate();
            this.lspanel.gates.simulate();
        }
    }

    void showMessage(String s) {
        JOptionPane.showMessageDialog(this, s);
    }

    boolean showDiscardDialog(String title) {
        if (this.lspanel.changed) {
            int r = JOptionPane.showConfirmDialog(this, I18N.getString("MESSAGE_REALLYNEW"), title, 0);
            if (r != 0) {
                return false;
            }
            this.lspanel.changed = false;
        }
        return true;
    }

    void jMenuItem_new_actionPerformed(ActionEvent e) {
        if (!this.showDiscardDialog(I18N.getString("MENU_NEW"))) {
            return;
        }
        this.fileName = "./circuits/";
        if (this.window != null) {
            this.window.setTitle("LogicSim");
        }
        this.lspanel.gates.clear();
        this.lspanel.repaint();
    }

    void jMenuItem_open_actionPerformed(ActionEvent e) {
        if (isApplet) {
            this.showMessage(I18N.getString("ERROR_APPLET"));
            return;
        }
        if (!this.showDiscardDialog(I18N.getString("MENU_OPEN"))) {
            return;
        }
        JFileChooser chooser = new JFileChooser(this.fileName);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.fileName = chooser.getSelectedFile().getAbsolutePath();
        if (this.sim != null) {
            this.sim.stop();
            this.jToggleButton_simulate.setSelected(false);
        }
        try {
            ObjectInputStream s = new ObjectInputStream(new FileInputStream(new File(this.fileName)));
            this.lspanel.gates = (GateList)s.readObject();
            s.close();
        }
        catch (FileNotFoundException x) {
            this.showMessage(I18N.getString("ERROR_FILENOTFOUND"));
        }
        catch (StreamCorruptedException x) {
            this.showMessage(I18N.getString("ERROR_FILECORRUPTED"));
        }
        catch (IOException x) {
            this.showMessage(I18N.getString("ERROR_READ"));
        }
        catch (ClassNotFoundException x) {
            this.showMessage(I18N.getString("ERROR_CLASS"));
        }
        if (this.window != null) {
            this.window.setTitle("LogicSim - " + new File(this.fileName).getName());
        }
        this.lspanel.gates.reconnect();
        this.lspanel.repaint();
        this.lspanel.changed = false;
        this.staticReset();
    }

    void jMenuItem_save_actionPerformed(ActionEvent e) {
        Object s;
        if (isApplet) {
            this.showMessage(I18N.getString("ERROR_APPLET"));
            return;
        }
        if (!(this.fileName != null && this.fileName.length() != 0 && this.fileName != "." && this.fileName != "./circuits/" || this.showSaveDialog())) {
            return;
        }
        try {
            s = new ObjectOutputStream(new FileOutputStream(new File(this.fileName)));
            s.writeObject(this.lspanel.gates);
            s.close();
        }
        catch (FileNotFoundException x) {
            this.showMessage(I18N.getString("ERROR_FILENOTFOUND"));
            return;
        }
        catch (IOException x) {
            this.showMessage(I18N.getString("ERROR_SAVE"));
            return;
        }
        if (this.window != null) {
            this.window.setTitle("LogicSim - " + new File(this.fileName).getName());
        }
        s = I18N.getString("STATUS_SAVED").replaceFirst("%s", this.fileName);
        this.statusBar.setText((String)s);
        this.fillGateList();
        this.lspanel.changed = false;
    }

    public boolean showSaveDialog() {
        JFileChooser chooser = new JFileChooser(this.fileName);
        chooser.setDialogTitle(I18N.getString("MESSAGE_SAVEDIALOG"));
        if (chooser.showSaveDialog(this) == 0) {
            this.fileName = chooser.getSelectedFile().getAbsolutePath();
            return true;
        }
        return false;
    }

    void jMenuItem_saveas_actionPerformed(ActionEvent e) {
        if (isApplet) {
            this.showMessage(I18N.getString("ERROR_APPLET"));
            return;
        }
        if (!this.showSaveDialog()) {
            return;
        }
        this.jMenuItem_save_actionPerformed(e);
    }

    void jMenuItem_help_actionPerformed(ActionEvent e) {
        new HTMLHelp(this.use_language);
    }

    void jButton_open_actionPerformed(ActionEvent e) {
        this.jMenuItem_open_actionPerformed(e);
    }

    void jButton_save_actionPerformed(ActionEvent e) {
        this.jMenuItem_save_actionPerformed(e);
    }

    void jButton_new_actionPerformed(ActionEvent e) {
        this.jMenuItem_new_actionPerformed(e);
    }

    void jMenuItem_createmod_actionPerformed(ActionEvent e) {
        if (isApplet) {
            this.showMessage(I18N.getString("ERROR_APPLET"));
            return;
        }
        MODIN g = new MODIN();
        if (!g.showProperties(this)) {
            return;
        }
        this.fileName = App.getModulePath() + g.ModuleName + ".mod";
        if (this.window != null) {
            this.window.setTitle("LogicSim - " + new File(this.fileName).getName());
        }
        g.x = 15;
        g.y = 15;
        this.lspanel.gates.addGate(g);
        MODOUT g2 = new MODOUT();
        g2.x = 710;
        g2.y = 15;
        this.lspanel.gates.addGate(g2);
        this.lspanel.repaint();
    }

    void jMenuItem_modproperties_actionPerformed(ActionEvent e) {
        if (isApplet) {
            this.showMessage(I18N.getString("ERROR_APPLET"));
            return;
        }
        MODIN modin = null;
        for (int i = 0; i < this.lspanel.gates.size(); ++i) {
            Gate g = this.lspanel.gates.get(i);
            if (!(g instanceof MODIN)) continue;
            modin = (MODIN)g;
        }
        if (modin == null) {
            this.showMessage(I18N.getString("ERROR_NOMODULE"));
            return;
        }
        if (modin.showProperties(this)) {
            this.fileName = App.getModulePath() + modin.ModuleName + ".mod";
            if (this.window != null) {
                this.window.setTitle("LogicSim - " + new File(this.fileName).getName());
            }
            this.fillGateList();
        }
    }

    void jMenuItem_print_actionPerformed(ActionEvent e) {
        this.lspanel.doPrint();
    }

    void exportImage() {
        String filename = "logicsim.png";
        JFileChooser chooser = new JFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("png");
        filter.setDescription("PNG");
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(I18N.getString("MESSAGE_SAVEDIALOG"));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        filename = chooser.getSelectedFile().getAbsolutePath();
        BufferedImage image = (BufferedImage)this.createImage(this.lspanel.getWidth(), this.lspanel.getHeight());
        Graphics g = image.getGraphics();
        this.lspanel.gates.deactivateAll();
        this.lspanel.paint(g);
        try {
            ImageIO.write((RenderedImage)image, "png", new File(filename));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void fillGateList() {
        this.jList_gates_model.clear();
        for (int i = 0; i < this.gateNames.length; ++i) {
            this.jList_gates_model.addElement(this.gateNames[i]);
        }
        if (isApplet) {
            return;
        }
        File mods = new File(App.getModulePath());
        String[] list = mods.list();
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < list.length; ++i) {
            int idx = list[i].lastIndexOf(".mod");
            if (idx <= 0) continue;
            this.jList_gates_model.addElement(list[i].substring(0, idx));
        }
    }

    void jList_gates_mouseClicked(MouseEvent e) {
        int sel = this.jList_gates.getSelectedIndex();
        if (sel < 0) {
            return;
        }
        if (sel < this.actions.length) {
            int a = this.actions[sel];
            if (a != -1) {
                switch (a) {
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.lspanel.setAction(a, new Integer(this.jComboBox_numinput.getSelectedItem().toString().substring(0, 1)));
                        break;
                    }
                    default: {
                        this.lspanel.setAction(a);
                    }
                }
            }
        } else {
            String s = (String)this.jList_gates.getSelectedValue();
            if (s != null && s.length() > 0) {
                Module mod = new Module(s);
                if (mod.moduleLoaded) {
                    this.lspanel.setAction(18, mod);
                }
            }
        }
        this.jList_gates.clearSelection();
    }

    void jCheckBoxMenuItem_paintGrid_actionPerformed(ActionEvent e) {
        this.lspanel.setPaintGrid(this.jCheckBoxMenuItem_paintGrid.isSelected());
        this.lspanel.repaint();
        this.userProperties.setProperty("paint_grid", "" + this.jCheckBoxMenuItem_paintGrid.isSelected());
        try {
            this.userProperties.store(new FileOutputStream("logicsim.cfg"), "LogicSim Configuration");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jMenuItem_gatedesign_actionPerformed(ActionEvent e) {
        String gatedesign = null;
        gatedesign = this.jMenuItem_gatedesign_din.isSelected() ? "din" : "iso";
        this.userProperties.setProperty("gatedesign", gatedesign);
        LSFrame.gatedesign = gatedesign;
        this.lspanel.gates.reloadImages();
        this.lspanel.repaint();
        try {
            this.userProperties.store(new FileOutputStream("logicsim.cfg"), "LogicSim Configuration");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jMenuItem_language_actionPerformed(ActionEvent e, String name) {
        this.userProperties.setProperty("language", name);
        try {
            this.userProperties.store(new FileOutputStream("logicsim.cfg"), "LogicSim Configuration");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.showMessage(I18N.getString("MESSAGE_LANGUAGE_RESTART"));
    }

    void create_language_menu(JMenu menu, String activeitem) {
        if (isApplet) {
            return;
        }
        File dir = new File("languages/");
        Object[] files = dir.list();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (!((String)files[i]).endsWith(".txt")) continue;
            final String name = ((String)files[i]).substring(0, ((String)files[i]).length() - 4);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
            if (name.equals(activeitem)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LSFrame.this.jMenuItem_language_actionPerformed(e, name);
                }
            });
            this.buttongroup_language.add(item);
            menu.add(item);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int idx;
                if (e.getSource() == LSFrame.this.lspanel) {
                    for (int i = 0; i < LSFrame.this.lspanel.gates.size(); ++i) {
                        Gate g = LSFrame.this.lspanel.gates.get(i);
                        if (!g.inside(e.getX(), e.getY())) continue;
                        LSFrame.this.popupGateIdx = i;
                        LSFrame.this.menuItem_properties.setEnabled(g.hasProperties());
                        LSFrame.this.popup.show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                } else if (e.getSource() == LSFrame.this.jList_gates && (idx = LSFrame.this.jList_gates.locationToIndex(e.getPoint())) >= LSFrame.this.actions.length) {
                    LSFrame.this.popupModule = idx;
                    LSFrame.this.popup_list.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

