/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.util.Vector;
import logicsim.Gate;
import logicsim.GateList;
import logicsim.Wire;

public abstract class ModularGate
extends Gate {
    static final long serialVersionUID = 1632712342754364805L;
    transient GateList gates = new GateList();
    Vector inputGates = new Vector(16);
    Vector inputNums;
    Vector outputGates;
    Vector outputNums;

    public ModularGate() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.inputGates.addElement(null);
        }
        this.inputNums = new Vector(16);
        for (n = 0; n < 16; ++n) {
            this.inputNums.addElement(new Integer(0));
        }
        this.outputGates = new Vector(16);
        for (n = 0; n < 16; ++n) {
            this.outputGates.addElement(null);
        }
        this.outputNums = new Vector(16);
        for (n = 0; n < 16; ++n) {
            this.outputNums.addElement(new Integer(0));
        }
        this.createModule();
    }

    public void createModule() {
    }

    public void simulate() {
        for (int i = 0; i < this.inputGates.size(); ++i) {
            Gate gate = (Gate)this.inputGates.get(i);
            if (gate == null) continue;
            Integer n = (Integer)this.inputNums.get(i);
            gate.inputTypes[n.intValue()] = this.inputTypes[i];
        }
        if (this.gates == null) {
            this.gates = new GateList();
            this.createModule();
        }
        this.gates.simulate();
    }

    public boolean getOutput(int n) {
        Gate gate = (Gate)this.outputGates.get(n);
        Integer n2 = (Integer)this.outputNums.get(n);
        if (gate != null) {
            return gate.getOutput(n2);
        }
        return false;
    }

    public void setInput(int n, Wire wire) {
        Gate gate = (Gate)this.inputGates.get(n);
        if (gate == null) {
            return;
        }
        Integer n2 = (Integer)this.inputNums.get(n);
        gate.setInput(n2, wire);
        super.setInput(n, wire);
    }

    public void reset() {
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate gate = this.gates.get(i);
            if (gate == null) continue;
            gate.reset();
        }
    }
}

