/* Interface for a vector-like data structure
 * that can be stored to and retrieved from disk.
 * See Vector.h for the rest of the specification.
 */
#ifndef _PersistentVector_h_
#define _PersistentVector_h_

#include "Vector.h"


/*--------------------------------------------------------------------------*
 * Read a vector from a file
 * After use, the Vector must be freed using vecDelete().
 *--------------------------------------------------------------------------*
 * Parameter: the name of the file from which the vector is to be read
 *
 * Return: a pointer to the new vector
 *         If this pointer is NULL, an error has occurred.
 *--------------------------------------------------------------------------*/
Vector* vecRead(const char* filename);


/*--------------------------------------------------------------------------*
 * Write a vector to a file
 * If the file already exists, it is silently overwritten.
 *--------------------------------------------------------------------------*
 * Parameters:
 *   the vector to be written
 *   the file pointer to which the vector is to be written
 *
 * Return: 0 if ok; nonzero if error
 *--------------------------------------------------------------------------*/
int vecWrite(const Vector* vector, const char* filename);

#endif
