/* Project 7 (PART 3B) by David Taralla | 27-03-2010
*  =================================================
*  This file contain implementations of functions used
*  by both dbget and dbput programs.
*/


#include "dbcommon.h"
#include "PersistentVector.h"
#include <stdlib.h>
#include <string.h>


ListItem* getListItem(const Vector* v, int index) {
    if (index >= v->size)
        return NULL;
    
    ListItem* toReturn = v->head;
    for (int i = 0; i < index; i++) {
        toReturn = toReturn->succ;
    }
    
    return toReturn;
}

int getKeyIndex(Vector* vector, char* key) {
    int vectorSize = vecSize(vector);
    for (int i = 0; i < vectorSize; i++) {
        DataStructure* db = vecGet(vector, i);
        if (db != NULL && strncmp(db->key, key, 21) == 0)
            return i;
    }
    
    // Not found
    return -1;
}

void freeEntireVector(Vector* vector) {
    while (vecSize(vector) > 0) {
        DataStructure* ds = vecRemove(vector, 0);
        if (ds != NULL)
            free(ds);
    }
    
    if (vector != NULL)
        vecDelete(vector);
}
