/* Project 7 (PART 3A) by David Taralla | 27-03-2010
*  =================================================
*  This file contain declarations of functions used
*  by both dbget and dbput programs. Implementations
*  can be found in dbcommon.c.
*/


#include "newTypes.h"

#ifndef _dbcommon_h_
#define _dbcommon_h_

/* ----------------------------------------------------------------------------
*  Description :
*  ==============
*  Get the adress of the item at index [index] in vector [v].
*  ----------------------------------------------------------------------------
*  Parameters :
*  =============
*  - Pointer leading to the vector which contains the item to get ;
*  - Index of the item to get.
*  ----------------------------------------------------------------------------
*  Return :
*  =========
*  - Operation succeeded : the adress of the item n[index] in vector [v] ;
*  - Any error           : NULL.
*  --------------------------------------------------------------------------*/
ListItem* getListItem(const Vector* v, int index);


/* ----------------------------------------------------------------------------
*  Description :
*  ==============
*  Get the first index of an existing key.
*  ----------------------------------------------------------------------------
*  Parameters :
*  =============
*  - Pointer leading to the vector in which we are searching ;
*  - Pointer leading to the key string to find.
*  ----------------------------------------------------------------------------
*  Return :
*  =========
*  - Key found   : the first index of the key in the vector ;
*  - Key unfound : -1.
*  --------------------------------------------------------------------------*/
int getKeyIndex(Vector* vector, char* key);


/* ----------------------------------------------------------------------------
*  Description :
*  ==============
*  Free all allocated memory : manually allocated + the vector itself.
*  ----------------------------------------------------------------------------
*  Parameters :
*  =============
*  - Pointer leading to the vector to free.
*  --------------------------------------------------------------------------*/
void freeEntireVector(Vector* vector);

#endif /* _dbcommon_h_ */
