/* Project 7 (PART 2) by David Taralla | 20-03-2010
*  =================================================
*  This program loads from a file a key-value structure
*  and displays the value associated to the entered key.
*  This key-value structure has been saved with the dbput
*  program.
*/


#include "dbcommon.h"
#include "PersistentVector.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/******************************************************************************
*------------------------------- Main program --------------------------------*
******************************************************************************/
int main(int argc, char* argv[]) {
    // Note : [argc] ALSO count program name as first argument
    if (argc < 3) {
        fprintf(stderr, "Program hasn't been launched correctly: Not enough "
                        "args on command line (%d instead of 2 expected).\n",
                        argc - 1);
        return -1;
    }
    
    const char* FILE_NAME = argv[1];
    char keyToLoad[21];
    strncpy(keyToLoad, argv[2], 20);
    keyToLoad[20] = '\0';
    
    // -- LOADING PREVIOUS VECTOR --
    Vector* dataVector = vecRead(FILE_NAME);
    
    // -- PROVIDE VALUE IF KEY FOUND --
    if (dataVector != NULL) {
        int existingKeyIndex = getKeyIndex(dataVector, keyToLoad);
        if (existingKeyIndex == -1) {
            freeEntireVector(dataVector);
            
            return 0;
        }
        
        DataStructure* loadedDS = vecGet(dataVector, existingKeyIndex);
        printf("%s\n", loadedDS->value);
    }
    else {
        fprintf(stderr, "Error opening \"%s\": No such file or directory.\n",
                        FILE_NAME);
        return -1;
    }
    
    // -- CLEAN UP ME%MORY --
    freeEntireVector(dataVector);
    
    return 0;
}
