/* Project 7 (PART 1) by David Taralla | 27-03-2010
*  =================================================
*  This program saves in a file a list of key-value
*  structures. The values can get the values back
*  in using the dbget program.
*/


#include "dbcommon.h"
#include "PersistentVector.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


/******************************************************************************
*------------------------------- Main program --------------------------------*
******************************************************************************/
int main(int argc, char* argv[]) {
    // Note : [argc] ALSO count program name as first argument
    if (argc < 4) {
        fprintf(stderr, "Program hasn't be launched correctly: Not enough args"
                        " on command line (%d instead of 3 expected).\n",
                        argc - 1);
        return -1;
    }
    
    const char* FILE_NAME = argv[1];
    DataStructure* toSave = malloc(sizeof(DataStructure));
    if (toSave == NULL) {
        fprintf(stderr, "Memory can't be allocated: Not enough memory.\n");
        return -1;
    }
    
    strncpy(toSave->key, argv[2], 20);
    toSave->key[20] = '\0';
    strncpy(toSave->value, argv[3], 20);
    toSave->value[20] = '\0';
    
    // -- READING OLD DATA & PREPARING DATA TO WRITE --
    Vector* dataVector = vecRead(FILE_NAME);
    if (dataVector != NULL) {
        int existingKeyIndex = getKeyIndex(dataVector, toSave->key);
        if (existingKeyIndex != -1) {
            free(vecGet(dataVector, existingKeyIndex));
            vecSet(dataVector, existingKeyIndex, toSave);
        }
        else
            vecInsert(dataVector, 0, toSave);
    }
    // Else file does not exists : assuming we loaded an empty vector
    else {
        dataVector = vecCreate();
        vecInsert(dataVector, 0, toSave);
    }
    
    // -- WRITING --
    if (vecWrite(dataVector, FILE_NAME) == -1) {
        printf("Error opening \"%s\": No such file or directory.\n"
               "The file might be in read-only state, or already in use with "
               "another program.\n", FILE_NAME);
        freeEntireVector(dataVector);
        return -1;
    }
    
    // -- CLEAN UP MEMORY --
    freeEntireVector(dataVector);
    
    return 0;
}
