/* Project 7 (PART 4) by David Taralla | 27-03-2010
*  ================================================
*  This file contain implementations of functions vecRead
*  and vecWrite.
*/


#include "dbcommon.h"
#include "PersistentVector.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>


/******************************************************************************
*--------------------------------- Functions ---------------------------------*
******************************************************************************/
/* ----------------------------------------------------------------------------
*  Description :
*  ==============
*  Delete unwanted carriage returns.
*  ----------------------------------------------------------------------------
*  Parameters :
*  =============
*  - Pointer leading to the string to modify.
*  ----------------------------------------------------------------------------
*  Return :
*  =========
*  - "\n" found   : 0 ;
*  - "\n" unfound : -1.
*  --------------------------------------------------------------------------*/
static int deleteNewLineChar(char *string) {
    char *ptr = strchr(string, '\n'); // Finding "\n"

    //If "\n" found, replacing it with "\0"
    if (ptr) {
        *ptr = 0;
        return 0;
    }
    
    // Not found
    return -1;
}

Vector* vecRead(const char* filename) {
    FILE* dataBase = fopen(filename, "r");
    if (dataBase == NULL)
        return NULL;
    
    Vector* toReturn = vecCreate();
    if (toReturn == NULL) {
        fprintf(stderr, "Memory can't be allocated: Not enough memory.\n");
        return NULL;
    }
    
    while(true) {
        char keyToAdd[21] = "";
        fgets(keyToAdd, 22, dataBase);  /* 22nd char for additional \n to
                                           delete, else problems */
        deleteNewLineChar(keyToAdd);
        keyToAdd[20] = '\0';
        
        if (strncmp(keyToAdd, "NULL_OBJECT", 11) == 0)
            vecInsert(toReturn, 0, NULL);
        else if (strlen(keyToAdd) == 0)
            break;
        else {
            DataStructure* dataToAdd = malloc(sizeof(DataStructure));
            if (dataToAdd == NULL) {
                fprintf(stderr, "Memory can't be allocated: Not enough "
                                "memory.\n");
                return NULL;
            }
            
            strncpy(dataToAdd->key, keyToAdd, 21);
            
            char valueToAdd[21];
            fgets(valueToAdd, 22, dataBase); /* 22nd char for additional \n to
                                                delete, else problems */
            deleteNewLineChar(valueToAdd);
            valueToAdd[20] = '\0';
            strncpy(dataToAdd->value, valueToAdd, 21);
            
            vecInsert(toReturn, 0, dataToAdd);
        }
    }
    
    fclose(dataBase);
    
    return toReturn;
}

int vecWrite(const Vector* v, const char* filename) {
    FILE* dataBase = fopen(filename, "w");
    if (dataBase == NULL)
        return -1;
    
    ListItem* currItem = getListItem(v, 0);
    for (int writObjCount = 0; writObjCount < v->size; writObjCount++) {
        if (currItem->element != NULL) {
            fprintf(dataBase, "%s\n",
                                 ((DataStructure*)(currItem->element))->key);
            fprintf(dataBase, "%s\n",
                                 ((DataStructure*)(currItem->element))->value);
        }
        else
            fprintf(dataBase, "NULL_OBJECT\n");
        
        currItem = currItem->succ;
    }
    
    fclose(dataBase);
    
    return 0;
}
