/* Project 7 (PART 5) by David Taralla | 27-03-2010
*  ================================================
*  This implementation does the same work
*  than arrayVector.c, but use the double-
*  chained-list method. See prototypes in
*  Vector.h for further information on the
*  functions implemented here.
*/


#include "dbcommon.h"
#include "PersistentVector.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdbool.h>


/******************************************************************************
*--------------------------------- Functions ---------------------------------*
******************************************************************************/
Vector* vecCreate() {
    Vector* newInstancePtr = malloc(sizeof(Vector));
    if (newInstancePtr == NULL)
        return NULL;
    
    newInstancePtr->head = newInstancePtr->queue = NULL;
    newInstancePtr->size = 0;
    
    return newInstancePtr;
}

void vecDelete(Vector* toDelete) {
    free(toDelete);
}

int vecSize(const Vector* v) {
    return v->size;
}

void* vecGet(const Vector* v, int index) {
    return getListItem(v, index)->element;
}

static ListItem* appendEmptyItem(Vector* v) {
    ListItem* newItemPtr = malloc(sizeof(ListItem));
    
    if (newItemPtr == NULL)
        return NULL;
    
    // If v is empty
    if (v->queue == NULL) {
        newItemPtr->prev = NULL;
        newItemPtr->succ = NULL;
        newItemPtr->element = NULL;
        
        v->queue = v->head = newItemPtr;
    }
    else {
        newItemPtr->prev = v->queue;
        newItemPtr->succ = NULL;
        newItemPtr->element = NULL;
        v->queue->succ = newItemPtr;
        v->queue = newItemPtr;
    }
    
    v->size += 1;
    
    return newItemPtr;
}

int vecSet(Vector* v, int index, void* data) {
    ListItem* itemToSet = NULL;
    
    /* If out of vector bounds, adding needed NULL elements and placing in the
       last one the user's data */
    if (index >= v->size) {
        for (int i = v->size; i <= index; i++) {
            itemToSet = appendEmptyItem(v);
            if (itemToSet == NULL)
                return -1;
        }
        
        itemToSet->element = data;
        
        return 0;
    }
    
    itemToSet = getListItem(v, index);
    itemToSet->element = data;
    
    return 0;
}

int vecInsert(Vector* v, int index, void* data) {
    // If out of vector bounds, leaving vecSet configure the vector
    if (index >= v->size)
        return vecSet(v, index, data);
    
    // Else, inserting at the right place
    ListItem* toInsert = malloc(sizeof(ListItem));
    if  (toInsert == NULL)
        return -1;
    
    ListItem* ItemToShift = getListItem(v, index);
    toInsert->element = data;
    
    toInsert->succ = ItemToShift;
    toInsert->prev = ItemToShift->prev;
    
    // If ItemToShift is the first element of v
    if (ItemToShift->prev == NULL)
        v->head = toInsert;
    else
        ItemToShift->prev->succ = toInsert;
    ItemToShift->prev = toInsert;
    v->size += 1;
    
    return 0;
}

void* vecRemove(Vector* v, int index) {
    if (index >= v->size)
        return NULL;
    
    ListItem* toRemove = getListItem(v, index);
    void* dataPtrToReturn = NULL;
    
    // If we remove the ONLY item in v
    if (toRemove->succ == NULL && toRemove->prev == NULL)
        v->queue = v->head = NULL;
    // If toRemove == queue
    else if (toRemove->succ == NULL) {
        toRemove->prev->succ = NULL;
        v->queue = toRemove->prev;
    }
    // If toRemove == head
    else if (toRemove->prev == NULL) {
        toRemove->succ->prev = NULL;
        v->head = toRemove->succ;
    }
    else {
        toRemove->prev->succ = toRemove->succ;
        toRemove->succ->prev = toRemove->prev;
    }
    
    dataPtrToReturn = toRemove->element;
    free(toRemove);
    v->size -= 1;
        
    return dataPtrToReturn;
}

void vecReverse(Vector* v) {
    int j = 0;
    int i = v->size - 1;
    
    // Linking doesn't need to be updated ; only elements must be switched
    while (j <= i) {
        void* lowerElmt = getListItem(v, j)->element;
        void* upperElmt = getListItem(v, i)->element;
        vecSet(v, j, upperElmt);
        vecSet(v, i, lowerElmt);
        i--;
        j++;
    }
}
