/* Project 7 (PART 6) by David Taralla | 27-03-2010
*  ================================================
*  Here are defined the three new types used
*  in listVector.c, dbcommon.c, dbget and dbput
*  programs.
*/


#include "Vector.h"

#ifndef _newTypes_h_
#define _newTypes_h_

typedef struct {
    char key[21];
    char value[21];
} DataStructure;

/* - [prev] is always pointing to the previous ListItem in the vector ;
*  - [succ] is always pointing to the next ListItem in the vector ;
*  - [element] contain the adress of the data stored by the user.
*
*  - [prev] of a [head] is always pointing to NULL ;
*  - [succ] of a [queue] is always pointing on NULL. */
typedef struct ListItem_t {
    struct ListItem_t* prev;
    struct ListItem_t* succ;
    struct ListItem_t* element;
} ListItem;

/* - [head] is always pointing to the FIRST item of the vector ;
*  - [queue] is always pointing to the LAST item of the vector.
*
*  - If vector is empty, both head and queue point on NULL ;
*  - If vector contain only 1 item, head = queue = this item. */
struct Vector_t {
    ListItem* head;
    ListItem* queue;
    int size;
};

#endif /* _newTypes_h_ */
