% Homework: female voice at 90 degree (60 dBA) & noise source at 180 degree (60 dBA)

% Goal: Apply beam forming to reduce the noise
% Notice: we need to filter the signals (telephonic band) and 
% amplify them by the factor (100-200) to be heard better


% Number of microphones (N_mic)
N_mic=unknown;

% Distance betweent two microphones (in meter)
D_mic=unknown;

% Steering angle, i.e., detection angle [Azimoth, Elevation]
angSteer=[unknown,unknown];

% Sound speed c
c=unknown;


% Read all .wav files (with samplig period fs) to constract the matrix sigArray (wich has N_mic column)

% Directory address
Dir_add='Female Voice 90deg 60dBA Noise 180deg 60dBA\';

% Refrence microphone number (N_mic_ref)
N_mic_ref=9;

% Refrence microphone id
Ref_id=strcat(Dir_add,sprintf('Micro %d_001.wav', 9));

% Read .wav of the refrence microphone (fs is the samplig period)
[y_ref,fs] = audioread(Ref_id);

% Register all in sigArray
sigArray=zeros(length(y_ref),N_mic);
sigArray_new=zeros(length(y_ref),N_mic);

for i=1:1:N_mic
    id=strcat(Dir_add,sprintf('Micro %d_001.wav', i));
    [y,~] = audioread(id);
    sigArray(:,i)=y;
end


% Multiplying by correction coefficents

% load correction coefficents
load beamforming_homework_correction_coeffs

for i=1:1:N_mic
    sigArray(:,i)=sigArray(:,i)*correction_coeffs(i);
end


% Filtering the all signals (bandpass: 300-3400, transition band 100 Hz)

% Load the filter object
load beamforming_homework_300Hz_3400Hz

% Filter...
sigArray=filter(unknown,unknown);


% Amplify all signals (+ noise): mutiplied by Ak

% Amplification (Ak)
Ak=200;

% Amplify...
sigArray=200.*sigArray;


t = 0:1/fs:(length(sigArray(:,9))-1)*1/fs;
figure(1)
plot(t,sigArray(:,9));
xlabel('Time (sec)'); ylabel ('Amplitude (V)');
title('Recorded signal by Mic. 9'); ylim([-3 3]);


% Output signal
Output_sig = unknown(unknown,2);

% Play
sound(Output_sig,fs);

% Plot
figure(2)
plot(t,Output_sig);
xlabel('Time (Sec)'); ylabel ('Amplitude (V)');
title('Time Delay Beamformer Output'); ylim([-3 3]);


% Plot response

% Working frequency (fc)
fc=800;

% Polar plot of directivity (in dB)
figure(3)
beamforming_directivity_plot_alternative(N_mic,D_mic,fc,angSteer(1,1),c)


