
#include <string.h>
#include "mergesort_str.h"

static void merge_str(char **tab, int lo, int mid, int hi, char **aux) {
  int i = lo, j = mid;

  for (int k = lo; k <= hi; k++)
    if (i == mid)
      aux[k] = tab[j++];
    else if (j == hi + 1)
      aux[k] = tab[i++];
    else if (strcmp(tab[i], tab[j]) < 0)
      aux[k] = tab[i++];
    else
      aux[k] = tab[j++];

  for (int k = lo; k <= hi; k++)
    tab[k] = aux[k];
  
}
  
static void mergesort_aux_str(char **tab, int lo, int hi, char **aux) {
  int n = hi - lo + 1;
  if (n <= 1)
    return;
  int mid = lo + (n + 1) / 2;
  mergesort_aux_str(tab, lo, mid - 1, aux);
  mergesort_aux_str(tab, mid, hi, aux);
  merge_str(tab, lo, mid, hi, aux);
}

void mergesortstr(char **tab, int n) {
  char *aux[n];
  mergesort_aux_str(tab, 0, n-1, aux);
}

