#include <stdlib.h>
#include <stdio.h>
#include "queue.h"

const int MAX_QUEUE_SIZE = 1000;
 
struct Queue_t {
  void *array[MAX_QUEUE_SIZE];
  int head;
  int tail;
};

static void terminate(const char *message) {
  printf("%s\n",message);
  exit(EXIT_FAILURE);
}

Queue *queueCreate() {

  Queue *q = malloc(sizeof(Queue));

  if (!q)
    terminate("Queue can not be created");

  q -> head = 0;
  q -> tail = 0;

  return q;
}

void queueFree(Queue *q) {  
  free(q);
}

void queueEnqueue(Queue *q, void *data) {

  if (queueSize(q) >= MAX_QUEUE_SIZE - 1)
    terminate("Queue is full");

  q -> array[q -> tail] = data;
  q -> tail = (q -> tail + 1) % MAX_QUEUE_SIZE;

}

void *queueDequeue(Queue *q) {

  if (q -> tail == q -> head)
    terminate("Queue is empty");

  void *data = q -> array[q -> head];
  
  q -> head = (q -> head + 1) % MAX_QUEUE_SIZE;
  
  return data;
}

void *queueHead(Queue *q) {

  if (q -> tail == q -> head)
    terminate("Queue is empty");

  return q -> array[q -> head];
  
}

int queueSize(Queue *q) {
  return (MAX_QUEUE_SIZE + q -> tail - q -> head) % MAX_QUEUE_SIZE;
}

int queueIsEmpty(Queue *q) {
  return (q -> head == q -> tail);
}
