#include <stdlib.h>
#include <stdio.h>
#include "queue.h"

typedef struct Node_t {
  void          *data;
  struct Node_t *next;
} Node;

struct Queue_t {
  Node *head;
  Node *tail;
  int   size;
};

static void terminate(const char *message) {
  printf("%s\n",message);
  exit(EXIT_FAILURE);
}

Queue *queueCreate() {

  Queue *q = malloc(sizeof(Queue));

  if (!q)
    terminate("Queue: Queue can not be created");

  q -> head = NULL;
  q -> tail = NULL;
  q -> size = 0;

  return q;
}

void queueFree(Queue *q) {
  
  Node *n = q -> head;
  while (n) {
    Node *nNext = n -> next;
    free(n);
    n = nNext;
  }
  free(q);
}

void queueEnqueue(Queue *q, void *data) {
  Node *n = malloc(sizeof(Node));

  if (!n)
    terminate("Queue: queue node can not be created");

  n -> data = data;
  n -> next = NULL;

  if (q -> tail)
    q -> tail -> next = n;
  else
    q -> head = n;
  q -> tail = n;

  q -> size++;  
}

void *queueDequeue(Queue *q) {

  if (!(q -> head))
    terminate("Queue is empty");

  Node *n = q -> head;
  void *data = n -> data;
  
  q -> head = n -> next;
  q -> size--;
  if (q -> size == 0)
    q -> tail = NULL;
  
  free(n);
  
  return data;
}

void *queueHead(Queue *q) {

  if (!(q -> head))
    terminate("Queue is empty");

  return q -> head -> data;
  
}

int queueSize(Queue *q) {
  return q -> size;
}

int queueIsEmpty(Queue *q) {
  return (q -> size == 0);
}
