/*
 * INFO0952 - 2018-2019
 *
 * Application de la file: trie les symboles fournis sur l'entrée
 * compilation: gcc -o sortfile sortfile.c queue-ll.c mergesort_str.c
 * usage: ./sortfile < addresses.txt
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "queue.h"
#include "mergesort_str.h"

const int BUFFER_SIZE = 1000;

int main() {

  char buffer[BUFFER_SIZE];
  Queue *q = queueCreate();
  
  while (fgets(buffer, BUFFER_SIZE, stdin)) {
    int lenstr = strlen(buffer)-1;
    buffer[lenstr]='\0';

    char *newstring = malloc((lenstr+1)*sizeof(char));
    if (!newstring)
      exit(-1);
    strcpy(newstring, buffer);

    queueEnqueue(q, newstring);
  }

  int sizeQ = queueSize(q);
  char **array = malloc(sizeQ * sizeof(char *));

  for (int i = 0; i<sizeQ; i++)
    array[i] = (char *) queueDequeue(q);

  queueFree(q);

  mergesortstr(array, sizeQ);

  for (int i = 0; i < sizeQ; i++)
    printf("%s\n", array[i]);
  
}
