#include <stdlib.h>
#include <stdio.h>
#include "stack.h"

const int MAX_STACK_SIZE = 1000;

struct Stack_t {
  void *array[MAX_STACK_SIZE];
  int   size;
};

static void terminate(const char *message) {
  printf("%s\n",message);
  exit(EXIT_FAILURE);
}

Stack *stackCreate() {
  Stack *s = malloc(sizeof(Stack));
  if (!s)
    terminate("Stack can not be created");
  s -> size = 0;
  return s;
}

void stackFree(Stack *s) {
  free(s);
}

void stackPush(Stack *s, void *data) {
  if (s -> size >= MAX_STACK_SIZE)
    terminate("Maximum stack size reached");
  
  s -> array[s -> size++] = data;
}

void *stackPop(Stack *s) {
  if (s -> size == 0)
    terminate("Stack is empty");

  return s -> array[--(s -> size)];
}

void *stackTop(Stack *s) {

  if (s -> size == 0)
    terminate("Stack is empty");

  return s -> array[s -> size - 1];
}

int stackSize(Stack *s) {
  return s -> size;
}

int stackIsEmpty(Stack *s) {
  return (s -> size == 0);
}
