#include <stdlib.h>
#include <stdio.h>
#include "stack.h"

typedef struct Node_t {
  void          *data;
  struct Node_t *next;
} Node;

struct Stack_t {
  Node *top;
  int   size;
};

static void terminate(const char *message) {
  printf("%s\n",message);
  exit(EXIT_FAILURE);
}

Stack *stackCreate() {
  Stack *s = malloc(sizeof(Stack));
  if (!s)
    terminate("Stack can not be created");
  s -> top = NULL;
  s -> size = 0;
  return s;
}

void stackFree(Stack *s) {
  Node *n = s -> top;
  while (n) {
    Node *nNext = n -> next;
    free(n);
    n = nNext;
  }
  free(s);
}

void stackPush(Stack *s, void *data) {
  Node *n = malloc(sizeof(Node));
  
  if (!n)
    terminate("Stack node can not be created");

  n -> data = data;
  n -> next = s -> top;
  s -> top = n;
  s -> size++;
}

void *stackPop(Stack *s) {
  if (!(s -> top))
    return NULL;

  Node *n = s -> top;
  void *data = n -> data;

  s -> top = n -> next;
  s -> size--;

  free(n);

  return data;
}

void *stackTop(Stack *s) {

  if (!(s -> top))
    return NULL;

  return s -> top -> data;
}

int stackSize(Stack *s) {
  return s -> size;
}

int stackIsEmpty(Stack *s) {
  return (s -> size == 0);
}
