/*
 * INFO0952 - 2018-2019
 *
 * Application de la file: trie les symboles fournis sur l'entrée
 * compilation: gcc -o rpneval rpneval.c stack-ll-double.c
 * usage: ./rpneval
 *        (chaque nombre/opérateur est séparé par un 'enter', 'ctrl-d' pour terminer)
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "stack-double.h"

const int BUFFER_SIZE = 1000;

int main() {

  char buffer[BUFFER_SIZE];
  Stack *s = stackCreate();

  while (fgets(buffer, BUFFER_SIZE, stdin)) {
    int lenstr = strlen(buffer)-1;
    buffer[lenstr]='\0';

    if (strcmp(buffer, "+") == 0)
      stackPush(s, stackPop(s)+stackPop(s));
    else if (strcmp(buffer, "-") == 0)
      stackPush(s, -stackPop(s)+stackPop(s));
    else if (strcmp(buffer, "/") == 0)
      stackPush(s, stackPop(s)/stackPop(s));
    else if (strcmp(buffer, "*") == 0)
      stackPush(s, stackPop(s)*stackPop(s));
    else {
      stackPush(s, strtod(buffer, NULL));
    }
  }

  printf("Result = %f\n",stackPop(s));
}
    
    
