
/*
 * Compilation: gcc -o testbtree testbtree.c BTree.c queue.c
 * Test: ./testbtree
 */ 

#include <stdio.h>
#include "queue.h"
#include "BTree.h"

static void btInorderTreeWalkAux(BTree *tree, BTNode *n);
static void btInorderTreeWalk(BTree *tree);
static void btBreadthFirstTreeWalk(BTree *tree);
static int btHeight(BTree *tree);
static int btHeightAux(BTree *tree, BTNode *n);

static void btInorderTreeWalk(BTree *tree) {
  if (btSize(tree)>0)
    btInorderTreeWalkAux(tree, btRoot(tree));
  printf("\n");
}

static void btInorderTreeWalkAux(BTree *tree, BTNode *n) {
  if (btHasLeft(tree, n))
    btInorderTreeWalkAux(tree, btLeft(tree, n));
  printf(" %d ", btGetData(tree, n));
  if (btHasRight(tree, n))
    btInorderTreeWalkAux(tree, btRight(tree, n));
}

static void btBreadthFirstTreeWalk(BTree *tree) {
  Queue *q = queueCreate();
  if (btSize(tree)>0)
    queueEnqueue(q, btRoot(tree));
  while (!queueIsEmpty(q)) {
    BTNode *n = queueDequeue(q);
    printf(" %d ", btGetData(tree, n));
    if (btHasLeft(tree, n))
      queueEnqueue(q, btLeft(tree, n));
    if (btHasRight(tree, n))
      queueEnqueue(q, btRight(tree, n));
  }
  queueFree(q);
  printf("\n");
}

static int btHeight(BTree *tree) {
   return btHeightAux(tree, btRoot(tree));
}

static int btHeightAux(BTree *tree, BTNode *n) {
  if (btIsExternal(tree, n))
     return 0;
  else {
    int hl = 0;
    int hr = 0;
    if (btHasLeft(tree, n))
      hl = btHeightAux(tree, btLeft(tree, n));
    if (btHasRight(tree, n))
      hr = btHeightAux(tree, btRight(tree, n));
    return 1 + (hl>hr? hl: hr);
  }
}

static int btNodeDepth(BTree *tree, BTNode *n);

static int btNodeDepth(BTree *tree, BTNode *n) {
  if (btIsRoot(tree, n))
     return 0;
  else
     return 1+btNodeDepth(tree, btParent(tree, n));  
}

int main() {

  /*
      6
     / \
    2   8
   / \   \
  1   4   11 
  
  */
  
  BTree *tree = btCreate();
  BTNode *root = btCreateRoot(tree, 6);
  BTNode *rootleft = btInsertLeft(tree, root, 2);
  BTNode *nodeA = btInsertLeft(tree, rootleft, 1);
  btInsertRight(tree, rootleft, 4);
  BTNode *rootright = btInsertRight(tree, root, 8);
  btInsertRight(tree, rootright, 11);

  btInorderTreeWalk(tree);

  btBreadthFirstTreeWalk(tree);

  printf("Tree height is %d\n", btHeight(tree));
  printf("Depth of nodeA is %d\n", btNodeDepth(tree, nodeA));
  printf("Depth of rootleft is %d\n", btNodeDepth(tree, rootleft));
  
  btFree(tree);
}
