#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define NSTEPS 10000000000UL

int main(int argc, const char* argv[]) {
  const double step = 1.0 / NSTEPS;
  const int max_threads = omp_get_max_threads();

  double* sum = malloc(max_threads*sizeof(double));
  
  double start = omp_get_wtime();

  #pragma omp parallel
  {
    int tid = omp_get_thread_num();
    
    sum[tid] = 0.0;

    #pragma omp for
    for(unsigned long i = 0; i < NSTEPS; i++) {
      double x = (i + 0.5) * step;
      sum[tid] += 4.0/(1.0 + x * x);
    }
  }

  double pi = 0.0;
  for(int i = 0; i < max_threads; i++) {
    pi += sum[i]*step;
  }

  double elapsed = omp_get_wtime() - start;

  printf("PI = %.16g computed in %.4g seconds\n", pi, elapsed);

  return 0;
}