#include <stdio.h>
#include <omp.h>

#define NSTEPS 10000000000UL

int main(int argc, const char* argv[]) {
  const double step = 1.0 / NSTEPS;
  double pi = 0.0;

  double start = omp_get_wtime();

  double sum;
  #pragma omp parallel private(sum)
  {
    sum = 0.0;
    
    #pragma omp for
    for(unsigned long i = 0; i < NSTEPS; i++) {
      double x = (i + 0.5) * step;
      sum += 4.0/(1.0 + x * x);
    }

    #pragma omp atomic
    pi += sum;
  }

  pi = pi * step;
  
  double elapsed = omp_get_wtime() - start;

  printf("PI = %.16g computed in %.4g seconds\n", pi, elapsed);

  return 0;
}