#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <omp.h>

void compute(int n, double* a, omp_sched_t sched, int chunk);

int main ( int argc, char *argv[] ) {
  double time1, time2, time3, time4;

  printf ( "\n  Number of threads = %d\n", omp_get_max_threads());

  int low = 1;
  int high = 65536;
  int factor = 2;

  double* a = (double*)malloc(high*sizeof(double));

  printf ( "\n" );
  printf ( "                 Default        Static       Dynamic        Guided\n" );
  printf ( "         N          Time          Time          Time          Time\n" );
  printf ( "\n" );

  int n = low;

  while (n <= high)
  {
    time1 = omp_get_wtime();
    compute(n, a, omp_sched_static, 0);
    time1 = omp_get_wtime() - time1;

    time2 = omp_get_wtime();
    compute(n, a, omp_sched_static, 100);
    time2 = omp_get_wtime() - time2;

    time3 = omp_get_wtime();
    compute(n, a, omp_sched_dynamic, 100);
    time3 = omp_get_wtime() - time3;

    time4 = omp_get_wtime();
    compute(n, a, omp_sched_guided, 100);
    time4 = omp_get_wtime() - time4;

    printf("  %8d  %12f  %12f  %12f  %12f\n", n, time1, time2, time3, time4);

    n *= factor;
  }

  printf ( "\n" );

  return 0;
}

void compute(int n, double* a, omp_sched_t sched, int chunk) {

  omp_set_schedule(sched, chunk);

  #pragma omp parallel shared(a, n)
  {
    #pragma omp for schedule(runtime)
    for (int i = 0; i < n; ++i) {
      a[i] = 0.0;

      for (int j = 0; j < i; ++j) {
        a[i] += cos( -3.1 * sin( 2.3 * cos ( (double) j ))) ;
      }      
    }
  }
}