#include <omp.h>

int main(int argc, char* argv[]) {
	int max_threads = omp_get_max_threads();

	double a[max_threads];
	double b[max_threads];

	for(int i = 0; i < max_threads; ++i) {
		a[i] = (double)i;
		b[i] = (double)i;
	}

	double c = 3.0;

	int tid, neighb;
	#pragma omp parallel private(tid, neighb)
	{
		tid = omp_get_thread_num();
		neighb = tid - 1;

		if (tid == 0) 
			neighb = omp_get_num_threads() - 1;

		a[tid] = a[tid] * 3.5;

		#pragma omp barrier

		b[tid] = a[neighb] + c;
	}
}
