#include <stdio.h>
#include <omp.h>

int main(int argc, char* argv[]) {
    int n = 100;

    int a[n];

    #pragma omp for
    for (int i = 0; i < n; ++i)
        a[i] = i;

    int tid, sum = 0, local_sum = 0;
    #pragma omp parallel shared(sum) private(tid, local_sum)
    {
        tid = omp_get_thread_num(); 
        local_sum = 0;
    
        #pragma omp for
        for (unsigned int i = 0; i < n; ++i)
            local_sum += a[i];
    
        #pragma omp critical 
        {
            sum += local_sum;
            printf("Thread %d: local sum = %d, sum = %d.\n", 
                    tid, local_sum, sum);
        }
    }
    
    printf("Sum after parallel region: %d.\n", sum);

    return 0;
}