#include <stdio.h>
#include <omp.h>

#define MIN(a, b) ((a) < (b) ? (a) : (b))

int main(int argc, char* argv[]) {
  int max_threads = omp_get_max_threads();
  int iterations[max_threads];

  for(int i = 0; i < max_threads; ++i)
    iterations[i] = 0;

  int n = 1000;
  #pragma omp parallel
  {
    int tid = omp_get_thread_num();
    int nthreads = omp_get_num_threads();

    int low = tid * (n / nthreads);
    int high = (tid + 1) * (n / nthreads);

    for(int i = low; i < MIN(high, n); ++i)
      iterations[tid]++;
  }

  for(int i = 0; i < max_threads; ++i)
    printf("Number of iteration for thread %d: %d\n", i, iterations[i]);
  
  return 0;
}