#include <stdio.h> 
#include <mpi.h>

int main(int argc, char** argv) { 
  int world_size, rank, name_len; 
  char proc_name[MPI_MAX_PROCESSOR_NAME];
  
  MPI_Init(&argc, &argv);

  MPI_Comm_size(MPI_COMM_WORLD, &world_size);  
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Get_processor_name(proc_name, &name_len);

  printf("Hello world from rank %d "
         "out of %d on node %s.\n", 
         rank, world_size, proc_name);
  
  MPI_Finalize();

  return 0;
}