#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

/**
 * This file contains all the examples of the communication mode and message
 * Matching section the slides. Macros are used to select the example to build
 * 
 * Here are the example commands to build the example with OpenMPI:
 * 
 * mpicc -DEX1 -o message_matching_ex1 message_matching.c
 * mpicc -DEX2 -o message_matching_ex2 message_matching.c
 * mpicc -DEX3 -o message_matching_ex3 message_matching.c
 * mpicc -DEX4 -o message_matching_ex4 message_matching.c
 * mpicc -DEX5 -o message_matching_ex5 message_matching.c
 * 
 * !!! NOTE !!! Example 2 will dealock
 */

int main(int argc, char* argv[]) {
  int val1, val2, rank, bufsize;
  void* buf;

  const int tag1 = 99;
  const int tag2 = 1;
  
  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) {
    val1 = 12345;
    val2 = 67890;

    MPI_Pack_size(1, MPI_INT, MPI_COMM_WORLD, &bufsize);
    bufsize = 2*(bufsize + MPI_BSEND_OVERHEAD);
    
    buf = malloc(bufsize);
    MPI_Buffer_attach(buf, bufsize);
  }

#ifdef EX1
  if (rank == 0) {
    MPI_Ssend(&val1, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);
    MPI_Ssend(&val2, 1, MPI_INT, 1, tag2, MPI_COMM_WORLD);

    printf(" First Ssend with tag %d sent %d\n", tag1, val1);
    printf("Second Ssend with tag %d sent %d\n", tag2, val2);
  } else if(rank == 1) {
    MPI_Recv(&val1, 1, MPI_INT, 0, tag1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    MPI_Recv(&val2, 1, MPI_INT, 0, tag2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    printf(" First Recv with tag %d gets %d\n", tag1, val1);
    printf("Second Recv with tag %d gets %d\n", tag2, val2);
  }
#endif

#ifdef EX2
  // This will dealock
  if (rank == 0) {
    MPI_Ssend(&val1, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);
    MPI_Ssend(&val2, 1, MPI_INT, 1, tag2, MPI_COMM_WORLD);

    printf(" First Ssend with tag %d sent %d\n", tag1, val1);
    printf("Second Ssend with tag %d sent %d\n", tag2, val2);
  } else if(rank == 1) {
    MPI_Recv(&val2, 1, MPI_INT, 0, tag2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    MPI_Recv(&val1, 1, MPI_INT, 0, tag1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    printf(" First Recv with tag %d gets %d\n", tag2, val2);
    printf("Second Recv with tag %d gets %d\n", tag1, val1);
  }
#endif

#ifdef EX3
  if (rank == 0) {
    MPI_Bsend(&val1, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);
    MPI_Bsend(&val2, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);

    printf(" First Bsend with tag %d sent %d\n", tag1, val1);
    printf("Second Bsend with tag %d sent %d\n", tag1, val2);
  } else if(rank == 1) {
    MPI_Recv(&val1, 1, MPI_INT, 0, tag1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    MPI_Recv(&val2, 1, MPI_INT, 0, tag1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    printf(" First Recv with tag %d gets %d\n", tag1, val1);
    printf("Second Recv with tag %d gets %d\n", tag1, val2);
  }
#endif

#ifdef EX4
  if (rank == 0) {
    MPI_Bsend(&val1, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);
    MPI_Bsend(&val2, 1, MPI_INT, 1, tag2, MPI_COMM_WORLD);

    printf(" First Bsend with tag %d sent %d\n", tag1, val1);
    printf("Second Bsend with tag %d sent %d\n", tag2, val2);
  } else if(rank == 1) {
    MPI_Recv(&val2, 1, MPI_INT, 0, tag2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    MPI_Recv(&val1, 1, MPI_INT, 0, tag1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    printf(" First Recv with tag %d gets %d\n", tag2, val2);
    printf("Second Recv with tag %d gets %d\n", tag1, val1);
  }
#endif

#ifdef EX5
  if (rank == 0) {
    MPI_Bsend(&val1, 1, MPI_INT, 1, tag1, MPI_COMM_WORLD);
    MPI_Bsend(&val2, 1, MPI_INT, 1, tag2, MPI_COMM_WORLD);

    printf(" First Bsend with tag %d sent %d\n", tag1, val1);
    printf("Second Bsend with tag %d sent %d\n", tag2, val2);
  } else if(rank == 1) {
    MPI_Recv(&val1, 1, MPI_INT, 0, MPI_ANY_TAG, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    MPI_Recv(&val2, 1, MPI_INT, 0, MPI_ANY_TAG, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    printf(" First Recv gets %d\n", val1);
    printf("Second Recv gets %d\n", val2);
  }
#endif

  if (rank == 0) {
    MPI_Buffer_detach(&buf, &bufsize);
    free(buf);
  }

  return 0;
}